/* 
TEST_HEADER
 id = $HopeName$
 summary = create register root without registering thread
 language = c
 link = myfmt.o testlib.o
END_HEADER
*/

#include "testlib.h"
#include "mpscamc.h"
#include "myfmt.h"

void *stackpointer;

static void test(void)
{
 mps_space_t space;
 mps_thr_t thread;
 mps_root_t root;

 cdie(mps_space_create(&space), "create space");

/*
 cdie(mps_thread_reg(&thread, space), "register thread");
*/

 cdie(
  mps_root_create_reg(&root, space, MPS_RANK_AMBIG, 0, thread,
   mps_stack_scan_ambig, stackpointer, 0),
  "create root");

 mps_root_destroy(root);
 comment("Destroyed root.");

/*
 mps_thread_dereg(thread);
 comment("Deregistered thread.");
*/

 mps_space_destroy(space);
 comment("Destroyed space.");
}

int main(void)
{
 void *m;
 stackpointer=&m; /* hack to get stack pointer */

 easy_tramp(test);
 return 0;
}

