/* 
TEST_HEADER
 id = $HopeName: MMQA_test_function!44.c(trunk.5) $
 summary = clamp and arena_collect tests
 language = c
 harness = 2.1
 link = testlib.o exfmt.o
OUTPUT_SPEC
 diff0 > 0
 diff1 > 0
 completed = yes
END_HEADER
*/

#include "testlib.h"
#include "mpscawl.h"
#include "mpscamc.h"
#include "exfmt.h"
#include "mpsavm.h"


#define genCOUNT (3)

static mps_gen_param_s testChain[genCOUNT] = {
  { 6000, 0.90 }, { 8000, 0.65 }, { 16000, 0.50 } };


void *stackpointer;


static void test(void)
{
 mps_arena_t arena;
 mps_pool_t poolamc, poolawl;
 mps_thr_t thread;
 mps_root_t root, root1;

 mps_fmt_t format;
 mps_chain_t chain;
 mps_ap_t apamc, apawl;

 size_t size0, size1;
 mycell *a, *b, *c, *d, *e, *f, *g;

 int i;
 int j;

 RC;

 deathcomments = 0;

 cdie(mps_arena_create(&arena, mps_arena_class_vm(), mmqaArenaSIZE),
      "create arena");

 die(mps_thread_reg(&thread, arena), "register thread");
 die(mps_root_create_reg(&root, arena, MPS_RANK_AMBIG, 0, thread,
                         mps_stack_scan_ambig, stackpointer, 0),
     "create root");

 cdie(
  mps_root_create_table(&root1, arena, MPS_RANK_AMBIG, 0, &exfmt_root, 1),
  "create exfmt root");

 die(mps_fmt_create_A(&format, arena, &fmtA), "create format");
 cdie(mps_chain_create(&chain, arena, genCOUNT, testChain), "chain_create");

 die(mmqa_pool_create_chain(&poolamc, arena, mps_class_amc(), format, chain),
     "create pool");

 cdie(
  mps_pool_create(&poolawl, arena, mps_class_awl(), format),
  "create pool");

 cdie(
  mps_ap_create(&apawl, poolawl, MPS_RANK_WEAK),
  "create ap");

 cdie(
  mps_ap_create(&apamc, poolamc, MPS_RANK_EXACT),
  "create ap");

 b = allocone(apamc, 1, 1);

 for (j=1; j<10; j++) {
  comment("%i of 10.", j);
  a = allocone(apawl, 5, 1);
  setref(b, 0, a);
  b = a;
  c = a;
  d = a;
  e = a;
  f = a;
  g = a;
  for (i=1; i<1000; i++) {
   if (i%100 == 0) {
    comment("   %i", i);
   }
   if (ranint(2)) {
    c = allocone(apamc, 1000, 1);
   } else {
    c = allocone(apawl, 1000, 1);
   }
   if (ranint(8) == 0) d = c;
   if (ranint(8) == 0) e = c;
   if (ranint(8) == 0) f = c;
   if (ranint(8) == 0) g = c;
   setref(b, 0, c);
   setref(c, 1, d);
   setref(c, 2, e);
   setref(c, 3, f);
   setref(c, 4, g);
   b = c;
  }
  if (j==3) {
   DC;
   comment("...collecting:");
   RC;
   size0 = arena_committed_and_used(arena);
   mps_arena_collect(arena);
   size1 = arena_committed_and_used(arena);
   report("sizebefore0", "%lu", (unsigned long) size0);
   report("sizeafter0", "%lu", (unsigned long) size1);
   report("diff0", "%lu", (unsigned long) size0-size1);
   DC;
   mps_arena_release(arena);
   comment("...released");
  }
  DC;
  comment("clamping...");
  mps_arena_park(arena);
  RC;
  for (i=1; i<1000; i++) {
   if (i%100 == 0) {
    comment("   %i", i);
   }
   if (ranint(2)) {
    c = allocone(apamc, 1000, 1);
   } else {
    c = allocone(apawl, 1000, 1);
   }
   if (ranint(8) == 0) d = c;
   if (ranint(8) == 0) e = c;
   if (ranint(8) == 0) f = c;
   if (ranint(8) == 0) g = c;
   setref(b, 0, c);
   setref(c, 1, d);
   setref(c, 2, e);
   setref(c, 3, f);
   setref(c, 4, g);
   b = c;
  }
  asserts(counters[COPY_COUNT]==0, "Eppur si muove!");
  DC;
  if (j==9) {
   comment("collecting...");
   size0 = arena_committed_and_used(arena);
   mps_arena_collect(arena);
   size1 = arena_committed_and_used(arena);
   report("sizebefore1", "%lu", (unsigned long) size0);
   report("sizeafter1", "%lu", (unsigned long) size1);
   report("diff1", "%lu", (unsigned long) size0-size1);
   DC;
  }
  mps_arena_release(arena);
  comment("released.");
  RC;
 }

 mps_ap_destroy(apawl);
 mps_ap_destroy(apamc);
 mps_pool_destroy(poolamc);
 mps_pool_destroy(poolawl);
 mps_chain_destroy(chain);
 mps_fmt_destroy(format);
 mps_root_destroy(root);
 mps_root_destroy(root1);
 mps_thread_dereg(thread);
 mps_arena_destroy(arena);
 comment("Destroyed arena.");
}


int main(void)
{
 void *m;
 stackpointer=&m; /* hack to get stack pointer */

 easy_tramp(test);
 pass();
 return 0;
}
