# replicator-test.py -- Test script for the replicator.
# Nicholas Barnes, Ravenbrook Limited, 2000-11-27.
# $Id: //info.ravenbrook.com/project/p4dti/version/0.4/code/replicator/bugzilla_test.py#2 $
#
# Copyright 2000 Ravenbrook Limited.  This document is provided "as is",
# without any express or implied warranty. In no event will the authors
# be held liable for any damages arising from the use of this document.
# You may make and distribute copies and derivative works of this
# document provided that (1) you do not charge a fee for this document or
# for its distribution, and (2) you retain as they appear all copyright
# and licence notices and document history entries, and (3) you append
# descriptions of your modifications to the document history.

import configure_bugzilla
import dt_bugzilla
import replicator
import p4

# The replicator identifier.
rid = 'case'

# The Perforce server identifier.
sid = 'p4_swan'

# E-mail address of integration administrator.
administrator_address = 'rb@ravenbrook.com'

# A format string used to build the URL for change descriptions, or None if
# there is no URL for change descriptions.
changelist_url = None

# The distingished Bugzilla status that maps to the Perforce state 'closed', or
# None if you don't want to distinguish it.  Case insensitive.
closed_state = None

# File to write logs to.
log_file = "p4dti.log"

# Path to Perforce client executable.
p4_client_executable = 'p4'

# Replicator's password on Perforce server.
p4_password = ''

# Hostname and port of Perforce server.
p4_port = 'sandpiper.ravenbrook.com:1667'

# Human-readable description of Perforce server.
p4_server_description = 'Test Perforce server on swan'

# Replicator's user name on Perforce server.
p4_user = 'P4DTI-%s' % rid

# The list of fields that will be replicated between Bugzilla issues and
# Perforce jobs.  Note that the system fields "bug_status", "assigned_to"
# and "short_desc" are always replicated and shouldn't appear in this list.
replicated_fields = []

# The e-mail address that the replicator uses.
replicator_address = 'p4dti-%s@ravenbrook.com' % rid

# Address of SMTP server for sending e-mail.
smtp_server = 'smtp.ravenbrook.com'

dbms_host = 'localhost'
dbms_database = 'bugs'
dbms_port = 3306
dbms_user = 'bugs'
dbms_password = ''
bugzilla_user = 'p4dti@ravenbrook.com'

# Advanced users only below here!  See appendix E of the Administrator Guide.
bugzilla_config, p4_config, replicator_config, jobspec = \
    configure_bugzilla.configuration \
    (
     administrator_address = administrator_address,
     changelist_url = changelist_url,
     closed_state = closed_state,
     log_file = log_file,
     p4_client_executable = p4_client_executable,
     p4_password = p4_password,
     p4_port = p4_port,
     p4_server_description = p4_server_description,
     p4_user = p4_user,
     replicator_address = replicator_address,
     replicated_fields = replicated_fields,
     smtp_server = smtp_server,
     dbms_host = dbms_host,
     dbms_database = dbms_database,
     dbms_port = dbms_port,
     dbms_user = dbms_user,
     dbms_password = dbms_password,
     bugzilla_user = bugzilla_user,
    )

dt = dt_bugzilla.dt_bugzilla(rid, sid, bugzilla_config)
p4_interface = p4.p4(p4_config)
r = replicator.replicator(rid, dt, p4_interface, replicator_config)
r.p4.run('jobspec -i', [jobspec])
r.init()

# B. Document History
# 
# 2000-12-05 NB *_user_name -> *_user
# 
# 2000-12-07 RB Implemented automatic configurator for Bugzilla integration.

