# config_bugzilla.py -- Configuration for Bugzilla.
# Nicholas Barnes, Ravenbrook Limited, 2000-11-27.
# $Id: //info.ravenbrook.com/project/p4dti/version/0.4/code/replicator/config_bugzilla.py#2 $
#
# Copyright 2000 Ravenbrook Limited.  This document is provided "as is",
# without any express or implied warranty. In no event will the authors
# be held liable for any damages arising from the use of this document.
# You may make and distribute copies and derivative works of this
# document provided that (1) you do not charge a fee for this document or
# for its distribution, and (2) you retain as they appear all copyright
# and licence notices and document history entries, and (3) you append
# descriptions of your modifications to the document history.

import MySQLdb
import dt_bugzilla
import logger
import replicator
import socket
import p4

# The replicator identifier.
rid = ????

# The Perforce server identifier.
sid = ????

# File to write logs to.
log_file = "p4dti.log"

# The logger object that handles the logging.  This logger object logs both to
# the file and to stdout.
logger = logger.multi_logger([logger.file_logger(open(log_file, "a")),
                              logger.file_logger()])

# Pairs of states (Bugzilla state, Perforce state).
states = [
    ('UNCONFIRMED', 'unconfirmed'), 
    ('NEW', 'open'), 
    ('ASSIGNED', 'assigned'), 
    ('REOPENED', 'reopened'), 
    ('RESOLVED', 'resolved'), 
    ('VERIFIED', 'verified'), 
    ('CLOSED', 'closed')
    ]

# function that takes a Bugzilla bug (as a dictionary) and returns a jobname.
def jobname(bug) :
    return ('bug%d' % bug['bug_id'])

bugzilla_config = {
    'logger': logger,
    'db' : MySQLdb.connect,
    'dbms-host': 'localhost',
    'dbms-database': 'bugs',
    'dbms-port': 3306,
    'dbms-user': 'bugs',
    'dbms-password': '',
    'jobname-function' : jobname
    }

p4_user_name =  'P4DTI-%s' % rid
bugzilla_user_name = 'p4dti@ravenbrook.com'

p4_config = {
    # Hostname and port of Perforce server.
    'p4-port': '127.0.0.1:1666',

    # Path to Perforce client executable: must P4/xxx/2000.1/17595 or later.
    'p4-client-executable': '/usr/local/bin/p4',

    # Perforce user identifier
    'p4-user' : p4_user_name,

    # Perforce client identifier
    'p4-client' : 'p4dti-%s' % socket.gethostname(),

    # Perforce password
    'p4-password' : '',
}

p4_interface = p4.p4(p4_config)

dt = dt_bugzilla.dt_bugzilla(rid, sid, bugzilla_config)

user_translator = dt_bugzilla.user_translator(bugzilla_user_name, p4_user_name)

replicator_config = \
{
    # A logger object that handles the logging for the replicator.
    'logger': logger,

    # E-mail address of integration administrator.
    'administrator-address': 'nb@ravenbrook.com',

    # Address of SMTP server for sending e-mail.
    'smtp-server': 'martin.ravenbrook.com',

    # The list of fields that will be replicated between Bugzilla issues and
    # Perforce jobs.  Each entry is a 3-tuple (Bugzilla field name, Perforce
    # field name, translator).
    'replicated-fields':
    [ ( 'assigned_to', 'User', user_translator),
      ( 'bug_status', 'Status',
        dt_bugzilla.status_translator(states) ),
      ( 'short_desc', 'Description',
        dt_bugzilla.text_translator() ),
      ],

    # Translator for users.
    'user-translator': user_translator,

    # Translator for dates.
    'date-translator': dt_bugzilla.date_translator(),

    # Name of field 102 in the jobspec.
    'job-status-field': 'Status',
  }

r = replicator.replicator(rid, dt, p4_interface, replicator_config)
r.init()

# B. Document History
# 
# 2000-12-07 RB Updated the user translator in the Bugzilla integration to
# match the method used in the TeamTrack integration.
