# bugzilla_test.py -- Test script for the replicator.
#
# Nicholas Barnes, Ravenbrook Limited, 2000-11-27.
#
# $Id: //info.ravenbrook.com/project/p4dti/version/0.5/code/replicator/bugzilla_test.py#2 $
#
# Copyright 2000 Ravenbrook Limited.  This document is provided "as is",
# without any express or implied warranty. In no event will the authors
# be held liable for any damages arising from the use of this document.
# You may make and distribute copies and derivative works of this
# document provided that (1) you do not charge a fee for this document or
# for its distribution, and (2) you retain as they appear all copyright
# and licence notices and document history entries, and (3) you append
# descriptions of your modifications to the document history.
#
# 1. INTRODUCTION
#
# This is the configuration script for the Bugzilla integration of the
# Perforce Defect Tracking Integration (P4DTI)
# <http://www.ravenbrook.com/project/p4dti>.
#
# Edit this script according to the instructions in section 5.2,
# "Configuring the P4DTI software", of the "Perforce Defect Tracking
# Integration Administrator's Guide" [RB 2000-08-10].
#

import configure_bugzilla
import dt_bugzilla
import replicator
import p4

# The replicator identifier.
rid = 'case'

# The Perforce server identifier.
sid = 'p4_swan'

# E-mail address of P4DTI administrator.
administrator_address = 'nb@ravenbrook.com'

# A format string used to build a URL for change descriptions in the
# defect tracker's user interface, or <code class="source">None</code> if
# there is no URL for change descriptions.
changelist_url = "http://swan.ravenbrook.com:8080/%d?ac=10"

# The name of the replicator's log file.
log_file = "p4dti.log"

# The path to the Perforce client executable that the replicator uses.
p4_client_executable = 'p4'

# The address and port of the Perforce server.
p4_port = 'swan.ravenbrook.com:1666'

# Replicator's user name and password on the Perforce server.
p4_user = 'P4DTI-%s' % rid
p4_password = ''

# Human-readable description of Perforce server.
p4_server_description = 'Test Perforce server on swan'

# The list of fields that will be replicated to Perforce jobs in addition
# to the system fields.
# [Not yet supported in Bugzilla.  Leave as the empty list.  RB 2000-12-08]
replicated_fields = []

# The e-mail address from which the replicator appears to sends e-mail.
replicator_address = 'p4dti-%s@ravenbrook.com' % rid

# The address of the SMTP server that the replicator uses to send e-mail.
smtp_server = 'smtp.ravenbrook.com'

# The host on which the Bugzilla MySQL server is running.
dbms_host = 'localhost'

# The port number on which the Bugzilla MySQL server is listening.
dbms_port = 3306

# The is the name of the database in which Bugzilla is storing its data
# on the MySQL server.
dbms_database = 'bugs'

# The user name and password that the replicator uses to log in to MySQL
# to use the Bugzilla database.
dbms_user = 'bugs'
dbms_password = ''

# The Bugzilla user name that the replicator uses when the Perforce
# user associated with some replicated data does not have a
# corresponding Bugzilla user.
bugzilla_user = 'p4dti@ravenbrook.com'


# Set this to 1 to get a lot more output.
verbose = 1

# Advanced users only below here!  See appendix E of the Administrator Guide.

bugzilla_config, p4_config, replicator_config, jobspec = \
    configure_bugzilla.configuration \
    (
     administrator_address = administrator_address,
     changelist_url = changelist_url,
     log_file = log_file,
     p4_client_executable = p4_client_executable,
     p4_password = p4_password,
     p4_port = p4_port,
     p4_server_description = p4_server_description,
     p4_user = p4_user,
     replicator_address = replicator_address,
     replicated_fields = replicated_fields,
     smtp_server = smtp_server,
     dbms_host = dbms_host,
     dbms_database = dbms_database,
     dbms_port = dbms_port,
     dbms_user = dbms_user,
     dbms_password = dbms_password,
     bugzilla_user = bugzilla_user,
     verbose = verbose,
    )

dt = dt_bugzilla.dt_bugzilla(rid, sid, bugzilla_config)
p4_interface = p4.p4(p4_config)
r = replicator.replicator(rid, dt, p4_interface, replicator_config)
r.p4.run('jobspec -i', [jobspec])
r.init()

#
# A. REFERENCES
#
# [RB 2000-08-10] "Perforce Defect Tracking Integration Administrator's
# Guide"; Richard Brooksby; Ravenbrook Limited; 2000-08-10.
#
#
# B. DOCUMENT HISTORY
#
# 2000-12-05 NB *_user_name -> *_user
# 
# 2000-12-07 RB Implemented automatic configurator for Bugzilla integration.
#
# 2000-12-08 RB Removed "closed_state" as it doesn't make much sense for
#               Bugzilla.  Documented paramters using consistent text
#               from [RB 2000-08-10].  Added introduction.
#
# 2000-12-11 NB Added comment explaining bugzilla_user.
#
# 2000-12-15 NB Added verbosity support.
