# config_bugzilla.py -- Test script for the replicator.
# Nicholas Barnes, Ravenbrook Limited, 2000-11-27.
# $Id: //info.ravenbrook.com/project/p4dti/version/0.5/code/replicator/config_bugzilla.py#2 $
#
# Copyright 2000 Ravenbrook Limited.  This document is provided "as is",
# without any express or implied warranty. In no event will the authors
# be held liable for any damages arising from the use of this document.
# You may make and distribute copies and derivative works of this
# document provided that (1) you do not charge a fee for this document or
# for its distribution, and (2) you retain as they appear all copyright
# and licence notices and document history entries, and (3) you append
# descriptions of your modifications to the document history.

import configure_bugzilla
import dt_bugzilla
import replicator
import p4

# The replicator identifier.
rid = 'replicator0'

# The Perforce server identifier.
sid = 'perforce0'

# E-mail address of integration administrator.
administrator_address = ????

# A format string used to build the URL for change descriptions, or None if
# there is no URL for change descriptions.
#
# If you are running p4web, replace ???.???.??? with your p4web server name.
changelist_url = "http://???.???.???:8080/%d?ac=10"

# The name of the replicator's log file.
log_file = "p4dti.log"

# The path to the Perforce client executable that the replicator uses.
p4_client_executable = 'p4'

# Replicator's user name and password on the Perforce server.
p4_user = 'P4DTI-%s' % rid
p4_password = ''

# Hostname and port of Perforce server.
# e.g. 'perforce.yourcompany.com:1666'
p4_port = ????

# Human-readable description of Perforce server.
p4_server_description = 'Perforce server on ????'

# The list of fields that will be replicated between Bugzilla issues and
# Perforce jobs.  Note that the system fields "bug_status", "assigned_to"
# and "short_desc" are always replicated and shouldn't appear in this list.
# [Not yet supported in Bugzilla.  Leave as the empty list.  RB 2000-12-08]
replicated_fields = []

# The e-mail address from which the replicator appears to send e-mail.
replicator_address = 'p4dti-%s' % rid

# The address of the SMTP server that the replicator uses to send e-mail.
smtp_server = ????

# The host on which the Bugzilla MySQL server is running.
dbms_host = 'localhost'

# The port number on which the Bugzilla MySQL server is listening
dbms_port = 3306

# The name of the MySQL database in which bugzilla stores its data
dbms_database = 'bugs'

# The MySQL user name and password that the replicator uses
# to access the Bugzilla database.
dbms_user = 'bugs'
dbms_password = ''

# The Bugzilla user name that the replicator uses when the Perforce
# user associated with some replicated data does not have a
# corresponding Bugzilla user.
bugzilla_user = ????

# Set this to 1 to get a lot more output.
verbose = 0

# Advanced users only below here!  See appendix E of the Administrator Guide.

bugzilla_config, p4_config, replicator_config, jobspec = \
    configure_bugzilla.configuration \
    (
     administrator_address = administrator_address,
     changelist_url = changelist_url,
     log_file = log_file,
     p4_client_executable = p4_client_executable,
     p4_password = p4_password,
     p4_port = p4_port,
     p4_server_description = p4_server_description,
     p4_user = p4_user,
     replicator_address = replicator_address,
     replicated_fields = replicated_fields,
     smtp_server = smtp_server,
     dbms_host = dbms_host,
     dbms_database = dbms_database,
     dbms_port = dbms_port,
     dbms_user = dbms_user,
     dbms_password = dbms_password,
     bugzilla_user = bugzilla_user,
     verbose = verbose,
    )

dt = dt_bugzilla.dt_bugzilla(rid, sid, bugzilla_config)
p4_interface = p4.p4(p4_config)
r = replicator.replicator(rid, dt, p4_interface, replicator_config)
r.p4.run('jobspec -i', [jobspec])
r.init()

# A. REFERENCES
#
# [RB 2000-08-10] "Perforce Defect Tracking Integration Administrator's
# Guide"; Richard Brooksby; Ravenbrook Limited; 2000-08-10.
#
#
# B. DOCUMENT HISTORY
#
# 2000-12-05 NB *_user_name -> *_user
# 
# 2000-12-07 RB Implemented automatic configurator for Bugzilla integration.
#
# 2000-12-13 NB Brought back into line with bugzilla_test.
#
# 2000-12-15 NB Added verbosity control.
