# config_teamtrack.py -- P4DTI configuration for replication to TeamTrack.
# Gareth Rees, Ravenbrook Limited, 2000-10-16.
# $Id: //info.ravenbrook.com/project/p4dti/version/0.5/code/replicator/config_teamtrack.py#2 $
#
# Copyright 2000 Ravenbrook Limited.  This document is provided "as is",
# without any express or implied warranty. In no event will the authors
# be held liable for any damages arising from the use of this document.
# You may make and distribute copies and derivative works of this
# document provided that (1) you do not charge a fee for this document or
# for its distribution, and (2) you retain as they appear all copyright
# and licence notices and document history entries, and (3) you append
# descriptions of your modifications to the document history.

import configure_teamtrack
import dt_teamtrack
import p4
import replicator

# See section 5.2 of the Administrator's Guide for detailed descriptions of
# these configuration parameters and recommendations for suitable values.

# The replicator identifier.
rid = 'replicator0'

# The Perforce server identifier.
sid = 'perforce0'

# E-mail address of integration administrator.
administrator_address = ????

# A format string used to build the URL for change descriptions, or None if
# there is no URL for change descriptions.
changelist_url = None

# The distingished TeamTrack state that maps to the Perforce state 'closed', or
# None if you don't want to distinguish it.  Case insensitive.
closed_state = None

# File to write logs to.
log_file = "p4dti.log"

# Path to Perforce client executable.
p4_client_executable = 'p4'

# Replicator's user name on Perforce server.
p4_password = ''

# Hostname and port of Perforce server.
p4_port = ????

# Human-readable description of Perforce server.
p4_server_description = 'Perforce server 0'

# Replicator's user name on Perforce server.
p4_user = 'P4DTI-%s' % rid

# The list of fields that will be replicated between TeamTrack issues and
# Perforce jobs.  Note that the system fields STATE, OWNER and TITLE are always
# replicated and shouldn't appear in this list.
replicated_fields = []

# The e-mail address that the replicator uses.
replicator_address = 'p4dti-%s' % rid

# Address of SMTP server for sending e-mail.
smtp_server = ????

# Replicator's password on TeamTrack server.
teamtrack_password = ''

# Hostname and optionally port of TeamTrack server.
teamtrack_server = ????

# Replicator's username on the TeamTrack server.
teamtrack_user = 'P4DTI-%s' % rid

# Set this to 1 to get a lot more output.
verbose = 0

# Advanced users only below here!  See appendix E of the Administrator Guide.
teamtrack_config, p4_config, replicator_config, jobspec = \
    configure_teamtrack.configuration \
    (
     administrator_address = administrator_address,
     changelist_url = changelist_url,
     closed_state = closed_state,
     log_file = log_file,
     p4_client_executable = p4_client_executable,
     p4_password = p4_password,
     p4_port = p4_port,
     p4_server_description = p4_server_description,
     p4_user = p4_user,
     replicator_address = replicator_address,
     replicated_fields = replicated_fields,
     smtp_server = smtp_server,
     teamtrack_password = teamtrack_password,
     teamtrack_server = teamtrack_server,
     teamtrack_user = teamtrack_user,
     verbose = verbose,
     )

dt = dt_teamtrack.dt_teamtrack(rid, sid, teamtrack_config)
p4_interface = p4.p4(p4_config)
r = replicator.replicator(rid, dt, p4_interface, replicator_config)
r.p4.run('jobspec -i', [jobspec])
r.init()

# B. Document History
# 
# 2000-11-30  GDR  Added changelist_url configuration parameter.
# 
# 2000-12-04 GDR Alphabetized parameters.  Added replicator_address.  Made sure
# to pass all parameters to configure_teamtrack.
#
# 2000-12-15 NB Added verbosity control.
