# migrate_teamtrack.py -- Migrate Perforce jobs to TeamTrack.
# Gareth Rees, Ravenbrook Limited, 2000-10-19.
# $Id: //info.ravenbrook.com/project/p4dti/version/0.5/code/replicator/migrate_teamtrack.py#1 $
#
# Copyright 2000 Ravenbrook Limited.  This document is provided "as is",
# without any express or implied warranty. In no event will the authors
# be held liable for any damages arising from the use of this document.
# You may make and distribute copies and derivative works of this
# document provided that (1) you do not charge a fee for this document or
# for its distribution, and (2) you retain as they appear all copyright
# and licence notices and document history entries, and (3) you append
# descriptions of your modifications to the document history.

import teamtrack
from config_teamtrack import r, dt
r.init()

jobs = r.p4_run('jobs -e P4DTI-rid=None')
for j in jobs:
    case = dt.config['case-class'](dt.server.new_record(teamtrack.table['CASES']), dt)

    # Specify values for fields that must be present for submission to succeed.
    case['TITLE'] = "Perforce job %s" % j['Job'] ????
    case['PROJECTID'] = 7 ???? # See PROJECTS table.
    case['SEVERITY'] = 67 ???? # Medium.  See SELECTIONS table.
    case['ISSUETYPE'] = 51 ???? # Bug.  See SELECTIONS table.

    # Submit an issue.
    case.transform_from_job(j, [], [])
    userid = dt.transform_user_p4_to_dt(j['P4DTI-user'])
    user = dt.user_id_to_name[userid]
    case.case.submit(user)
    r.log("Submitted a case corresponding to job %s", j['Job'])

    # Discover what happened to the issue we just submitted.
    cases = dt.server.query(teamtrack.table['CASES'],
                            "TS_P4DTI_JOBNAME='%s'" % j['Job'])
    if len(cases) == 0:
        r.log("-- Uh oh!  No case replicates to that jobname.")
    elif len(cases) > 1:
        r.log("-- Uh oh!  Many cases replicate to that jobname.")
    else:
        c = dt.config['case-class'](cases[0], dt)
        j['P4DTI-rid'] = r.rid
        j['P4DTI-issue-id'] = c.id()
        r.p4_run('job -i', [j])
        r.log("-- Job '%s' replicates to case '%s'", (j['Job'], c.id()))

        # Now replicate in earnest to make sure filespecs, fixes etc are
        # replicated.
        r.replicate_issue_to_job(c, j)

# B. Document History
# 
# 2000-10-19 GDR Created.
