# refresh_perforce.py -- Delete all jobs from Perforce and replicate all issues
# and fixes from the defect tracker to Perforce.
# Gareth Rees, Ravenbrook Limited, 2000-12-08.
# $Id$
#
# Copyright 2000 Ravenbrook Limited.  This document is provided "as is",
# without any express or implied warranty. In no event will the authors
# be held liable for any damages arising from the use of this document.
# You may make and distribute copies and derivative works of this
# document provided that (1) you do not charge a fee for this document or
# for its distribution, and (2) you retain as they appear all copyright
# and licence notices and document history entries, and (3) you append
# descriptions of your modifications to the document history.

from config_teamtrack import r

# Delete all the jobs.
jobs = r.p4.run('jobs')
for job in jobs:
    r.p4.run('job -d %s' % job['Job'])

# Replicate from the defect tracker.
r.replicate_all_dt_to_p4()

# B. Document History
#
# 2000-12-08 GDR Created.
