# shell.py -- debugging shell for interacting with TeamTrack interface.
# Gareth Rees, Ravenbrook Limited, 2000-08-07.
# $Id: //info.ravenbrook.com/project/p4dti/version/1.2/code/python-teamtrack-interface/shell.py#2 $
#
# This file is copyright (c) 2001 Perforce Software, Inc.  All rights
# reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
#
# 1.  Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#
# 2.  Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in
#     the documentation and/or other materials provided with the
#     distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# HOLDERS AND CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
# BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
# OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
# ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
# TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
# USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
# DAMAGE.

# Set up paths so that the teamtrack and replicator modules can be loaded.  The
# relative path assumes that this script is being run from the teamtrack
# development directory (version/1.2/code/teamtrack).
import sys
sys.path = sys.path + ['..\\build\\debug', '..\\replicator']

# Set up paths so that IDLE (a Python GUI) can be run on Ravenbrook's
# development platforms.
sys.path = sys.path + ['c:\\Program Files\\Python20\\Tools\\idle',
					   'd:\\Program Files\\Python20\\Tools\\idle']

# Run IDLE.
import idle

# B. Document History
#
# 2000-08-07 GDR Created.
#
# 2000-08-08 GDR Look for Python tools on D: as well as C:.
#
# 2001-02-01 GDR Updated for Python 2.0.
#
# 2001-03-02  RB    Transferred copyright to Perforce under their license.
