/* teamtrack-python.h -- wrapper round Python.h
   Gareth Rees, Ravenbrook Limited, 2000-12-05
   $Id: //info.ravenbrook.com/project/p4dti/version/1.2/code/python-teamtrack-interface/teamtrack-python.h#2 $

   This header is a wrapper around Python.h that undefines _DEBUG when
   the NO_PYTHON_DEBUGGING macro is defined.  If _DEBUG is defined, then
   Python.h defines various debugging functions that are not present in
   the usual Python library, but only in the debugging version of that
   library.  So if we want to build a debugging teamtrack module that is
   linked with the release version of Python then we must define
   NO_DEBUGGING_PYTHON.

   See "Python interface to TeamTrack: design"
   <version/1.2/design/python-teamtrack-interface/> for the design. */

/*
  This file is copyright (c) 2001 Perforce Software, Inc.  All rights
  reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are
  met:

  1.  Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.

  2.  Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in
      the documentation and/or other materials provided with the
      distribution.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  HOLDERS AND CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
  OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
  TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
  DAMAGE.
*/

#if !defined(TEAMTRACK_PYTHON_H)
#define TEAMTRACK_PYTHON_H

#if defined(NO_DEBUGGING_PYTHON) && defined(_DEBUG)
#undef _DEBUG
#include "Python.h"
#define _DEBUG
#else /* !(defined(NO_DEBUGGING_PYTHON) && defined(_DEBUG)) */
#include "Python.h"
#endif /* defined(NO_DEBUGGING_PYTHON) && defined(_DEBUG) */

#endif /* !defined(TEAMTRACK_PYTHON_H) */

/* B. Document History

   2000-12-05 GDR Created.

*/
