/* teamtrack-record.h -- Python wrapper round TSRecord class
   Gareth Rees, Ravenbrook Limited, 2000-08-07
   $Id: //info.ravenbrook.com/project/p4dti/version/1.2/code/python-teamtrack-interface/teamtrack-record.h#2 $

   See "Python interface to TeamTrack: design" for the design
   <version/1.2/design/python-teamtrack-interface/>. */

/*
  This file is copyright (c) 2001 Perforce Software, Inc.  All rights
  reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are
  met:

  1.  Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.

  2.  Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in
      the documentation and/or other materials provided with the
      distribution.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  HOLDERS AND CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
  OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
  TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
  DAMAGE.
*/

#if !defined(TEAMTRACK_RECORD_H)
#define TEAMTRACK_RECORD_H


#include "teamtrack-python.h"
#include "teamtrack-server.h"
#include "TSRecord.h"


/* A teamtrack_record object is a Python wrapper around a TSRecord object. */

typedef struct {
  PyObject_HEAD
  TSRecord *r; /* The wrapped record. */
  teamtrack_server *server; /* Python wrapper round server this record belongs
                               to. */
  int delete_p; /* Delete the TSRecord object when Python wrapper deleted? */
} teamtrack_record;


/* teamtrack_record_type is the type object for teamtrack_record objects. */

extern PyTypeObject teamtrack_record_type;


/* teamtrack_record_p(x) is true iff x (which must be a Python object) is a
   teamtrack_record. */

#define teamtrack_record_p(x) ((x)->ob_type == &teamtrack_record_type)



/* teamtrack_record_new(r, server, delete_p) returns a Python wrapper for the
   TSRecord object r, or 0 if there is an error.  The server argument is the
   Python wrapper for the TSServer object to which the record belongs.  Iff
   delete_p is true, then the TSRecord object will be deleted when the Python
   wrapper is deleted. */

extern PyObject *
teamtrack_record_new(TSRecord *r, teamtrack_server *server, int delete_p);


#endif /* !defined(TEAMTRACK_RECORD_H) */


/* B. Document History

   2000-08-07  GDR  Created.

   2000-08-29  GDR  Changed "tTrack" to "TeamTrack" throughout.

   2000-08-31 GDR The Python wrapper round TSRecord now stores the Python
   wrapper around the TSServer object that the record belongs to.  This is so
   that the record object can provide add, update, submit and transition
   methods.

*/
