/* teamtrack-server.h -- Python wrapper round TSServer class
   Gareth Rees, Ravenbrook Limited, 2000-08-08
   $Id: //info.ravenbrook.com/project/p4dti/version/1.2/code/python-teamtrack-interface/teamtrack-server.h#2 $

   See "Python interface to TeamTrack: design" for the design
   <version/1.2/design/python-teamtrack-interface/>. */

/*
  This file is copyright (c) 2001 Perforce Software, Inc.  All rights
  reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are
  met:

  1.  Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.

  2.  Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in
      the documentation and/or other materials provided with the
      distribution.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
  HOLDERS AND CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
  OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
  TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
  DAMAGE.
*/

#if !defined(TEAMTRACK_SERVER_H)
#define TEAMTRACK_SERVER_H


#include "teamtrack-python.h"
#include "TSServer.h"


/* A teamtrack_server object is a Python wrapper around a TSServer object. */

typedef struct {
  PyObject_HEAD
  TSServer *s;
  int delete_p; /* Delete the TSServer object when Python wrapper deleted? */
  int case_table_id; /* Table id of the cases table. */
  TSString *case_table_name; /* Name of the cases table, or NULL meaning "TS_CASES". */
} teamtrack_server;


/* teamtrack_server_type is the type object for teamtrack_server objects. */

extern PyTypeObject teamtrack_server_type;


/* teamtrack_server_p(x) is true iff x (which must be a Python object) is a
   teamtrack_server. */

#define teamtrack_server_p(x) ((x)->ob_type == &teamtrack_server_type)


/* teamtrack_server_new(s, delete_p) returns a Python wrapper for the TSServer
   object s, or 0 if there is an error.  Iff delete_p is true, then the
   TSServer object will be deleted when the Python wrapper is deleted. */

extern PyObject *teamtrack_server_new(TSServer *s, int delete_p);


#endif /* !defined(TEAMTRACK_SERVER_H) */


/* B. Document History

   2000-08-08 GDR Created.

   2000-08-29 GDR Changed "tTrack" to "TeamTrack" throughout.

   2001-06-26 GDR Added case_table_id field to teamtrack_server objects.

   2001-06-28 GDR Added case_table_name field to teamtrack_server
   objects.

*/
