#                Perforce Defect Tracking Integration Project
#                 <http://www.ravenbrook.com/project/p4dti/>
#
#                        CATALOG.PY -- MESSAGE CATALOG
#
#                 Gareth Rees, Ravenbrook Limited, 2001-03-12
#
#
# 1. INTRODUCTION
#
# This module defines message catalogs for the P4DTI.  A message catalog is a
# dictionary mapping message id to the formatting string used to build the
# message.  When the message is printed, arguments will be substituted for the
# format specifiers using the % operator.
#
# These message catalogs are intended to be used by the message.catalog_factory
# class in the message module in order to:
#
#  1. Support future localization of the P4DTI (by using different message
# catalogs for different languages); and
#
#  2. Help developers to prevent message ids from clashing, by providing a
# catalog of all messages.
#
# The name of a catalog should include the product name and the ISO language
# code for the language [ISO 639].
#
# The P4DTI's message system is documented in detail in section 6.6, "Logging
# and error handling" of the P4DTI Integrator's Guide [GDR 2000-10-16].
#
# If you change a message in a catalog, make sure to also change the comment in
# the code next to each use of the message (there may be several uses) and the
# entry in section 11.2 of the Administrator's Guide.
#
# Never re-use message ids.  If you stop using a message, then leave a
# placeholder in this file with priority message.NOT_USED.  (This will mean
# that an attempt to use the message results in an error.)
#
# The intended readership of this document is project developers.
#
# This document is not confidential.

import message


# 2. P4DTI MESSAGES IN ENGLISH
#
# This is a catalog of messages in English for the "P4DTI" product.

p4dti_en_catalog = {


    # 2.1. Messages from bugzilla.py (100-199)

    100: (message.DEBUG, "Executing SQL command '%s'."),
    101: (message.DEBUG, "MySQL returned '%s'."),
    102: (message.DEBUG, "fetchone() returned '%s'."),
    103: (message.DEBUG, "fetchall() returned '%s'."),
    104: (message.DEBUG, "Running command '%s'."),
    105: (message.ERR, "Given '%s' when expecting a string or integer."),
    106: (message.ERR, "Select '%s' of %s returns no rows."),
    107: (message.ERR, "Select '%s' of %s expecting one row but returns %d."),
    108: (message.ERR, "Trying to fetch a row from non-select '%s'."),
    109: (message.ERR, "Select '%s' of %s returned an unfetchable row."),
    110: (message.ERR, "Trying to fetch rows from non-select '%s'."),
    111: (message.ERR, "Select '%s' of %s returned unfetchable rows."),
    112: (message.ERR, "Select '%s' of %s expecting no more than one row but returns %d."),
    113: (message.ERR, "Select '%s' of %s returns %d keys but %d values."),
    115: (message.ERR, "Select '%s' of %s returns %d keys but %d columns."),
    116: (message.ERR, "Couldn't insert row in table '%s'."),
    117: (message.ERR, "Couldn't update row in table '%s' where %s."),
    118: (message.NOT_USED,
          "Old P4DTI/Bugzilla schema version %s detected; "
          "dropping old tables and replacing with version %s."),
    119: (message.WARNING,
          "Old P4DTI/Bugzilla schema version %s detected; "
          "altering tables to upgrade to schema version %s."),
    120: (message.CRIT,
          "Unknown or future P4DTI/Bugzilla schema version %s detected."),
    121: (message.WARNING,
          "Your P4DTI/Bugzilla schema is prior to release 1.0.2. "
          "Altering tables to upgrade schema to release 1.0.2."),
    122: (message.CRIT,
          "Nothing in p4dti_replications table: database corrupted?"),
    123: (message.CRIT,
          "Bugzilla version %s is not supported by the P4DTI."),
    124: (message.INFO,
          "Bugzilla version %s detected, with these additional tables present: %s."),
    125: (message.INFO,
          "Bugzilla version %s detected."),
    126: (message.NOT_USED,
          "P4DTI configuration specifies Bugzilla version %s, but version %s detected."),
    127: (message.ERR,
          "Bugzilla's fielddefs table does not include '%s'."),


    # 2.2. Messages from check_config.py (200-299)

    200: (message.CRIT, "Configuration parameter '%s' must be 0 or 1."),
    201: (message.CRIT, "Configuration parameter '%s' (value '%s') is not a valid date.  The right format is 'YYYY-MM-DD HH:MM:SS'."),
    202: (message.CRIT, "Configuration parameter '%s' (value '%s') is not a valid e-mail address."),
    203: (message.CRIT, "Configuration parameter '%s' must be a function."),
    204: (message.CRIT, "Configuration parameter '%s' must be an integer."),
    205: (message.CRIT, "Configuration parameter '%s' must be a list."),
    206: (message.CRIT, "Configuration parameter '%s' must be a list of %s."),
    207: (message.CRIT, "Configuration parameter '%s' must be a string."),
    208: (message.CRIT, "Configuration parameter '%s' must be None or a string."),
    209: (message.CRIT, "Configuration parameter '%s' (value '%s') must be from 1 to 32 characters long, start with a letter or number, and consist of letters, numbers and underscores only."),
    210: (message.CRIT, "Configuration parameter '%s' (value '%s') must contain exactly one %%d format specifier, any number of doubled percents, but no other format specifiers."),
    211: (message.CRIT, "Configuration parameter '%s' (value '%s') must contain exactly one %%s format specifier, any number of doubled percents, but no other format specifiers."),


    # 2.3. Messages from configure_bugzilla.py (300-399)

    300: (message.CRIT, "Two Bugzilla states '%s' and '%s' map to the same Perforce state '%s'."),
    301: (message.CRIT, "You specified the closed_state '%s', but there's no such Bugzilla state."),
    302: (message.CRIT, "The '%s' column of Bugzilla's 'bugs' table is not an enum type."),
    303: (message.CRIT, "Configuration parameter 'bugzilla_directory' does not name a directory."),
    304: (message.CRIT, "Configuration parameter 'bugzilla_directory' does not name a directory containing a processmail script."),
    305: (message.CRIT, "Bugzilla's table 'profiles' does not have a 'login_name' column."),
    306: (message.CRIT, "The 'login_name' column of Bugzilla's 'profiles' table does not have a 'text' type."),
    307: (message.CRIT, "Bugzilla's table 'bugs' does not have a '%s' column."),
    308: (message.CRIT, "The 'bug_status' column of Bugzilla's 'bugs' table is not an enum type."),
    309: (message.CRIT, "The 'resolution' column of Bugzilla's 'bugs' table is not an enum type."),
    310: (message.CRIT, "The 'resolution' column of Bugzilla's 'bugs' table does not have a 'FIXED' value."),
    311: (message.CRIT, "Field '%s' specified in 'replicated_fields' is a system field: leave it out!"),
    312: (message.CRIT, "Field '%s' appears twice in 'replicated_fields'."),
    313: (message.CRIT, "Field '%s' specified in 'replicated_fields' list not in Bugzilla 'bugs' table."),
    314: (message.CRIT, "Field '%s' specified in 'replicated_fields' list has type '%s': this is not yet supported by P4DTI."),
    315: (message.CRIT, "Field '%s' specified in 'replicated_fields' list has floating-point type: this is not yet supported by P4DTI."),
    316: (message.CRIT, "You can't have a field called 'code' in the Perforce jobspec."),
    317: (message.CRIT, "Too many fields to replicate: Perforce jobs can contain only 99 fields."),
    318: (message.CRIT, "Jobspec fields '%s' and '%s' have the same number %d."),


    # 2.4. Messages from configure_teamtrack.py (400-499)

    400: (message.CRIT, "Two TeamTrack states '%s' and '%s' map to the same Perforce state '%s'."),
    401: (message.CRIT, "You specified the closed_state '%s', but there's no such TeamTrack state."),
    402: (message.CRIT, "Couldn't get descriptions for TeamTrack system fields STATE, OWNER, and TITLE."),
    403: (message.CRIT, "Field '%s' specified in 'replicated_fields' list not in TeamTrack FIELDS table."),
    404: (message.CRIT, "Field '%s' specified in 'replicated_fields' list is a system field: leave it out!"),
    405: (message.CRIT, "Field '%s' appears twice in 'replicated_fields'."),
    406: (message.CRIT, "Field '%s' has type %d: this is not supported by P4DTI."),
    407: (message.CRIT, "You can't have a field called 'code' in the Perforce jobspec."),
    408: (message.CRIT, "Too many fields to replicate: Perforce jobs can contain only 99 fields."),


    # 2.5. Messages from dt_bugzilla.py (500-599)

    500: (message.ERR, "User %d isn't in the right bug group to change field '%s' of bug %d to %s."),
    501: (message.ERR, "User %d doesn't have permission to change field '%s' of bug %d to %s."),
    502: (message.ERR, "The P4DTI does not support marking bugs as DUPLICATE from Perforce."),
    503: (message.ERR, "Bugzilla does not allow a transition from status '%s' to '%s'."),
    504: (message.ERR, "Cannot change Bugzilla field '%s'."),
    505: (message.ERR, "Can only append to Bugzilla field '%s'."),
    506: (message.ERR, "Updating non-existent Bugzilla field '%s'."),
    507: (message.ERR, "Bugzilla does not have a group called '%s'."),
    508: (message.NOT_USED, "Bugzilla's fielddefs table does not include '%s'."),
    509: (message.ERR, "No Perforce status corresponding to Bugzilla status '%s'."),
    510: (message.ERR, "No Bugzilla status corresponding to Perforce status '%s'."),
    511: (message.ERR, "Perforce field value '%s' could not be translated to a number for replication to Bugzilla."),
    512: (message.ERR, "Bugzilla P4DTI user '%s' has e-mail address matching Perforce user '%s', not Perforce P4DTI user '%s'."),
    513: (message.ERR, "Bugzilla P4DTI user '%s' is not a known Bugzilla user."),
    514: (message.ERR, "There is no Bugzilla user corresponding to Perforce user '%s'."),
    515: (message.NOTICE, "A user field containing one of these users will be translated to the user's e-mail address in the corresponding Perforce job field."),
    516: (message.NOTICE, "It will not be possible to use Perforce to assign bugs to these users.  Changes to jobs made by these users will be ascribed in Bugzilla to the replicator user <%s>."),
    517: (message.NOTICE, "These Perforce users have duplicate e-mail addresses.  They may have been matched with the wrong Bugzilla user."),


    # 2.6. Messages from dt_teamtrack.py (600-699)

    600: (message.INFO, "-- Transition: %d; User: %s."),
    601: (message.INFO, "Installing field '%s' in the TS_CASES table."),
    602: (message.INFO, "Partially installed the new fields in the TS_CASES table. Previous installation was not up to date."),
    603: (message.INFO, "Installed all new fields in the TS_CASES table."),
    604: (message.INFO, "Put '%s' parameter in replicator configuration with value '%s'."),
    605: (message.INFO, "Updated '%s' parameter in replicator configuration to have value '%s'."),
    606: (message.NOT_USED, "Reading table %s."),
    607: (message.WARNING, "Warning: table '%s' has two entries called '%s'."),
    608: (message.NOT_USED, "Reading FIELDS and SELECTIONS tables."),
    609: (message.NOT_USED, "Reading PROJECTS and STATES tables."),
    610: (message.NOT_USED, "Reading PROJECTS table to discover available transitions."),
    611: (message.NOT_USED, "Reading SELECTIONS table to find type prefixes."),
    612: (message.NOT_USED, "Reading USERS table."),
    613: (message.DEBUG, "Matched TeamTrack user '%s' with Perforce user '%s' by e-mail address '%s'."),
    614: (message.ERR, "No transition from state '%s' to state '%s'."),
    615: (message.ERR, "No login id in TeamTrack's USERS table corresponding to replicator's login id '%s'."),
    616: (message.ERR, "No LAST_CHANGE record for this replicator."),
    617: (message.ERR, "TeamTrack database version %d is not supported by the P4DTI.  The minimum supported version is %d."),
    618: (message.ERR, "Incorrect date in Perforce: '%s' is not in the format 'YYYY/mm/dd HH:MM:SS'."),
    619: (message.ERR, "Incorrect time in Perforce: '%s' is not in the format 'H:MM:SS'."),
    620: (message.ERR, "No such table: %s."),
    621: (message.ERR, "No TeamTrack entity in table '%s' with id %d."),
    622: (message.ERR, "No TeamTrack entity in table '%s' with name '%s'."),
    623: (message.ERR, "No TeamTrack selection name for selection id '%d'."),
    624: (message.ERR, "No TeamTrack selection for field '%s' corresponding to Perforce selection '%s'."),
    625: (message.ERR, "No Perforce state corresponding to TeamTrack state '%s'."),
    626: (message.ERR, "No state name for TeamTrack state %d."),
    627: (message.ERR, "Perforce state '%s' is unknown."),
    628: (message.ERR, "No TeamTrack state in project '%s' corresponding to Perforce state '%s'."),
    629: (message.NOTICE, "These TeamTrack users will appear as themselves in Perforce even though there is no such Perforce user."),
    630: (message.NOTICE, "These Perforce users will appear in TeamTrack as the user (None).  It will not be possible to assign issues to these users."),
    631: (message.DEBUG, "TeamTrack query: SELECT * FROM %s WHERE %s."),
    632: (message.DEBUG, "TeamTrack query: SELECT * FROM %s."),
    633: (message.ERR, "The TeamTrack field %s is append-only: you're not allowed to edit previous comments."),
    634: (message.DEBUG, "Matched TeamTrack user '%s' with Perforce user '%s' by userid."),
    635: (message.DEBUG, "Two TeamTrack users ('%s' and '%s') have the same e-mail address '%s'."),
    636: (message.NOTICE, "These TeamTrack users have duplicate e-mail addresses.  They may have been matched with the wrong Perforce user."),
    637: (message.NOTICE, "These Perforce users have duplicate e-mail addresses.  They may have been matched with the wrong TeamTrack user."),


    # 2.7. Messages from p4.py (700-799)

    700: (message.DEBUG, "Perforce input: '%s'."),
    701: (message.DEBUG, "Perforce command: '%s'."),
    702: (message.DEBUG, "Perforce status: '%s'."),
    703: (message.DEBUG, "Perforce results: '%s'."),
    704: (message.ERR, "Perforce client changelevel %d is not supported by P4DTI.  Client must be at changelevel %d or above."),
    705: (message.ERR, "The command '%s' didn't report a recognizable version number.  Check your setting for the 'p4_client_executable' parameter."),
    706: (message.ERR, "%s  The Perforce client exited with error code %d."),
    707: (message.ERR, "The Perforce client exited with error code %d.  Is the server down or the server address incorrect?"),
    708: (message.ERR, "%s"),
    709: (message.CRIT, "The Perforce interface does not support the operating system '%s'."),


    # 2.8. Messages from replicator.py (800-999)

    800: (message.INFO, "Mailing '%s' re: '%s'."),
    802: (message.INFO, "Replicated changelist %d."),
    803: (message.INFO, "Set up issue '%s' to replicate to job '%s'."),
    804: (message.INFO, "Replicating issue '%s' to job '%s'."),
    805: (message.INFO, "Replicating job '%s' to issue '%s'."),
    806: (message.NOTICE, "Issue '%s' and job '%s' have both changed.  Consulting conflict resolution policy."),
    807: (message.INFO, "Conflict resolution policy decided: no action."),
    808: (message.INFO, "Job '%s' could not be replicated to issue '%s': %s: %s"),
    810: (message.NOTICE, "Overwrite issue '%s' with job '%s'."),
    811: (message.NOTICE, "Overwrite job '%s' with issue '%s'."),
    812: (message.INFO, "-- Changed fields: %s."),
    813: (message.INFO, "-- No issue fields were replicated."),
    814: (message.INFO, "-- Filespecs changed to '%s'."),
    815: (message.INFO, "-- Deleted fix for change %s."),
    816: (message.INFO, "-- Added fix for change %d with status %s."),
    817: (message.INFO, "-- Fix for change %d updated to status %s."),
    818: (message.INFO, "-- Deleted fix for change %d."),
    819: (message.INFO, "-- Considering Perforce fix %s."),
    820: (message.INFO, "-- Added fix for change %s with status %s."),
    821: (message.INFO, "-- Fix for change %s updated to status %s."),
    822: (message.INFO, "-- Deleted filespec %s."),
    823: (message.INFO, "-- Added filespec %s."),
    824: (message.INFO, "-- Changed fields: %s."),
    825: (message.INFO, "-- No job fields were replicated."),
    826: (message.INFO, "-- Defect tracker made changes as a result of the update: %s."),
    827: (message.INFO, "Checking changelists to see if they need replicating..."),
    828: (message.INFO, "-- %d changelists to check."),
    829: (message.INFO, "The replicator failed to poll successfully: %s: %s"),
    830: (message.NOT_USED, "The replicator identifier must consist of letters, numbers and underscores only: '%s' is not allowed."),
    831: (message.NOT_USED, "The Perforce server identifier must consist of letters, numbers and underscores only: '%s' is not allowed."),
    832: (message.NOT_USED, "The replicator identifier must consist of letters, numbers and underscores only: '%s' is not allowed."),
    833: (message.CRIT, "The replicator's RID ('%s') doesn't match the defect tracker's RID ('%s')."),
    834: (message.CRIT, "The Perforce server changelevel %d is not supported by the P4DTI.  The server must be at changelevel %d or above."),
    835: (message.CRIT, "The Perforce command 'p4 info' didn't report a recognisable version."),
    836: (message.CRIT, "Field '%s' not found in Perforce jobspec."),
    837: (message.ERR, "Expected a job but found %s."),
    838: (message.ERR, "Asked for job '%s' but got job '%s'."),
    839: (message.ERR, "P4DTI-filespecs field has value '%s': this should end in a newline."),
    840: (message.ERR, "Issue '%s' not found."),
    841: (message.NOTICE, "Defect tracker issue '%s' and Perforce job '%s' have both changed since the last time the replicator polled the databases.  The replicator's conflict resolution policy decided to overwrite the job with the issue."),
    842: (message.NOTICE, "Defect tracker issue '%s' and Perforce job '%s' have both changed since the last time the replicator polled the databases.  The replicator's conflict resolution policy decided to overwrite the issue with the job."),
    844: (message.NOT_USED, "1 issue has changed."),
    845: (message.NOT_USED, "%d issues have changed."),
    846: (message.NOT_USED, "1 job has changed."),
    847: (message.NOT_USED, "%d jobs have changed."),
    848: (message.NOTICE, "Job '%s' could not be replicated to issue '%s'."),
    849: (message.NOTICE, "The replicator failed to replicate Perforce job '%s' to defect tracker issue '%s'.  There was no error message.  See the Python traceback below for more details about the error."),
    850: (message.NOTICE, "The most likely reasons for this problem are: you don't have permission to update the issue; the job contained data that was invalid in TeamTrack; or the job was missing a field that is required in TeamTrack."),
    851: (message.NOTICE, "The replicator failed to replicate Perforce job '%s' to defect tracker issue '%s', because of the following problem:"),
    852: (message.NOTICE, "Here's a full Python traceback:"),
    853: (message.NOTICE, "If you are having continued problems, please contact your P4DTI administrator <%s>."),
    854: (message.NOTICE, "The replicator failed to replicate Perforce job '%s' to defect tracker issue '%s' because of this problem:"),
    855: (message.NOTICE, "The replicator attempted to restore the job to a copy of the issue, but this failed too, because of the following problem:"),
    856: (message.NOTICE, "The replicator has now given up."),
    857: (message.NOTICE, "Issue '%s' overwritten by job '%s'."),
    858: (message.NOTICE, "The replicator has therefore overwritten defect tracker issue '%s' with Perforce job '%s'."),
    859: (message.NOTICE, "The defect tracker issue looked like this before being overwritten:"),
    860: (message.NOTICE, "Job '%s' overwritten by issue '%s'."),
    861: (message.NOTICE, "The replicator has therefore overwritten Perforce job '%s' with defect tracker issue '%s'.  See section 2.2 of the P4DTI User Guide for more information."),
    862: (message.NOTICE, "The job looked like this before being overwritten:"),
    863: (message.NOTICE, "The replicator failed to poll successfully."),
    864: (message.NOTICE, "The replicator failed to poll successfully, because of the following problem:"),
    865: (message.INFO, "This is an automatically generated e-mail from the Perforce Defect Tracking Integration replicator '%s'."),
    866: (message.INFO, "The P4DTI replicator has started."),
    867: (message.NOTICE, "The following Perforce users do not correspond to defect tracker users.  The correspondence is based on the e-mail addresses in the defect tracker and Perforce user records."),
    868: (message.INFO, "User"),
    869: (message.INFO, "E-mail address"),
    870: (message.INFO, "The following defect tracker users do not correspond to Perforce users.  The correspondence is based on the e-mail addresses in the defect tracker and Perforce user records."),
    871: (message.INFO, "Checking consistency for replicator '%s'."),
    872: (message.ERR, "Issue '%s' should be replicated but is not."),
    873: (message.ERR, "Issue '%s' should be replicated to job '%s' but that job either does not exists or is not replicated."),
    874: (message.ERR, "Issue '%s' is replicated to job '%s' but that job is replicated to issue '%s'."),
    875: (message.ERR, "Job '%s' would need the following set of changes in order to match issue '%s': %s."),
    876: (message.ERR, "Job '%s' has associated filespec '%s' but there is no corresponding filespec for issue '%s'."),
    877: (message.ERR, "Issue '%s' has associated filespec '%s' but there is no corresponding filespec for job '%s'."),
    878: (message.ERR, "Change %s fixes job '%s' but there is no corresponding fix for issue '%s'."),
    879: (message.ERR, "Change %d fixes issue '%s' but there is no corresponding fix for job '%s'."),
    880: (message.ERR, "Change %s fixes job '%s' with status '%s', but change %d fixes issue '%s' with status '%s'."),
    881: (message.ERR, "Job '%s' is marked as being replicated to issue '%s' but that issue is being replicated to job '%s'."),
    882: (message.ERR, "Job '%s' is marked as being replicated to issue '%s' but that issue either doesn't exist or is not being replicated by this replicator."),
    883: (message.INFO, "Consistency check completed.  1 issue checked."),
    884: (message.INFO, "Consistency check completed.  %d issues checked."),
    885: (message.INFO, "Looks all right to me."),
    886: (message.ERR, "1 inconsistency found."),
    887: (message.ERR, "%d inconsistencies found."),
    888: (message.ERR, "Asked for issue '%s' but got an error instead."),
    889: (message.ERR, "Job '%s' has a date field in the wrong format: %s."),
    890: (message.INFO, "Checking issue '%s' against job '%s'."),
    891: (message.ERR, "Defect tracker error (%s): %s"),


    # 2.9. Messages from init.py, check.py, run.py, refresh.py,
    # teamtrack.py (1000-1099)

    1000: (message.NOT_USED, "The defect tracker '%s' is not supported."),
    1001: (message.CRIT, "You must delete your Perforce jobs before running the P4DTI for the first time.  See section 3.2.2 of the Administrator's Guide."),
    1002: (message.NOTICE, "WARNING!  This script will delete all jobs in Perforce.  Please use it according to the instructions in section 9.2 of the P4DTI Administrator's Guide.  Are you sure you want to go ahead?"),
    1003: (message.CRIT, "TeamTrack version %s is not supported by the P4DTI."),

    }


# 3. A P4DTI MESSAGE FACTORY
#
# We define 'factory', a message factory for the P4DTI and 'msg()', a function
# to get messages from it.

factory = message.catalog_factory(p4dti_en_catalog, "P4DTI")

def msg(id, args = ()):
    return factory.new(id, args)


# A. REFERENCES
#
# [GDR 2000-10-16] "Perforce Defect Tracking Integration Integrator's Guide";
# Richard Brooksby; Ravenbrook Limited; 2000-10-16.
#
# [ISO 639] "Code for the representation of names of languages"; ISO;
# 1988-04-01.
#
#
# B. DOCUMENT HISTORY
#
# 2001-03-12 GDR Created.
#
# 2001-03-14 GDR Added consistency checking messages from replicator.py.
#
# 2001-03-15 GDR Added messages from init.py.
#
# 2001-03-25 RB  Added 889 due to merge from version 1.0 sources.
#
# 2001-04-10 NB  Added 118 due to merge from version 1.0 sources.
#
# 2001-05-15 GDR Added 631, set 844 to 847 to NOT_USED, since cursor
# implementation means we don't get this information.
#
# 2001-05-18 GDR Added 632.  Improved 606, 631, 888.  Set 606, 608-612
# to NOT_USED since we use 631 and 632 to log this information.
#
# 2001-06-14 GDR Added 891.
#
# 2001-07-03 GDR Added 1003.
#
# 2001-07-09 NB Added 211.
#
# 2001-07-16 NB Message 118 not used.  Added 119-122 to support schema
# upgrades and replication since start date.
#
# 2001-07-17 GDR Error messages that only appear in e-mail messages get
# priority NOTICE.
#
# 2001-09-10 NB Modified message 105.  See job000262.
#
# 2001-09-25 GDR Message 126 not used.  See job000393.
#
# 2001-10-01 GDR Added 633.
#
# 2001-10-02 GDR Added 634, 635, 636, 637.
#
# 2001-10-18 GDR Improved error messages for bad dates and times.
#
#
# C. COPYRIGHT AND LICENCE
#
# This file is copyright (c) 2001 Perforce Software, Inc.  All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# 1.  Redistributions of source code must retain the above copyright notice,
#     this list of conditions and the following disclaimer.
#
# 2.  Redistributions in binary form must reproduce the above copyright notice,
#     this list of conditions and the following disclaimer in the documentation
#     and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS AND CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
#
#
# $Id: //info.ravenbrook.com/project/p4dti/version/1.2/code/replicator/catalog.py#2 $
