#             Perforce Defect Tracking Integration Project
#              <http://www.ravenbrook.com/project/p4dti/>
#
#     CHECKSUM.PY -- CHECKSUM THE P4DTI SOURCES TO DETECT CHANGES
#
#             Gareth Rees, Ravenbrook Limited, 2001-03-05.
#
#
# 1. INTRODUCTION
#
# This Python script prints an MD5 checksum of the P4DTI sources.  The
# purpose is to allow Perforce support to easily determine if an
# organization has altered the P4DTI sources (and so are running an
# unsupported configuration) by asking the customer to run checksum.py
# and comparing the result to the checksum for the release.  This fixes
# job000252.


import md5

# We produced this by running p4 files "*.py" and removing (a) deleted
# files and (b) files that people are supposed to change, namely
# config.py and example_trigger.py.

files = [
    'bugzilla.py',
    'catalog.py',
    'check.py',
    'check_config.py',
    'checksum.py',
    'configure_bugzilla.py',
    'configure_teamtrack.py',
    'dt_bugzilla.py',
    'dt_interface.py',
    'dt_teamtrack.py',
    'init.py',
    'logger.py',
    'message.py',
    'p4.py',
    'refresh.py',
    'replicator.py',
    'run.py',
    'stacktrace.py',
    'teamtrack.py',
    'translator.py',
    ]

# Python 1.5.2 doesn't have md5.hexdigest(), so we do it ourselves:
def hexify(s):
    result = ""
    for c in s:
       result = result + ("%02x" % ord(c))
    return result

cs = md5.new()
for file in files:
    cs.update(open(file, 'r').read())
print hexify(cs.digest())


# A. REFERENCES
#
#
# B. Document History
#
# 2001-03-05 GDR Created.
#
# 2001-03-07 NB Made it work on Python 1.5.2.
#
# 2001-03-29 RB Corrected title, description, and creation date.
#
# 2001-08-07 GDR Formatted as a document.  Updated files.
#
#
# C. COPYRIGHT AND LICENCE
#
# This file is copyright (c) 2001 Perforce Software, Inc.  All rights
# reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
#
# 1.  Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#
# 2.  Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in
#     the documentation and/or other materials provided with the
#     distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# HOLDERS AND CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
# BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
# OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
# ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
# TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
# USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
# DAMAGE.
#
#
# $Id: //info.ravenbrook.com/project/p4dti/version/1.2/code/replicator/checksum.py#1 $
