#ifndef TS_DEF_H_
#define TS_DEF_H_

/*
 * make sure BOOL is typedefed.  If your system
 * already defined BOOL to something other than
 * an int you can remove this.
 */

typedef int BOOL;
#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

/*
 * API Version.  If you upgrade to a newer version of
 * TeamTrack, it is possible, however unlikely that it
 * will be incompatible with the older version of the
 * API and this number won't match the number used in
 * the new version of TeamTrack and your API program
 * will have to be recompiled.  Also, it's worth noting
 * that this number does NOT match the version number
 * of TeamTrack, it's the version number for the API
 * which hopefully won't need to change when a newer
 * version of TeamTrack is installed.
 */

/*  TS_APIVERSION set to 2 on 1-26-2001, 
    build 4506, dbversion 27, object version 27 */
#define TS_APIVERSION 2

/*
 * API Revision.  This minor version number is incremented
 * each time functionality is added or bugs are fixed.
 * Unlike the TS_APIVERSION number, new revisions of the
 * API will continue to be compatible with your version
 * of TeamTrack.
 */

/*  TS_APIREVISION reset to 1 on 1-26-2000, TS_APIVERSION = 2 */
#define TS_APIREVISION 1

/*
 * If we aren't using MFC define AFX_EXT_CLASS to be
 * nothing.
 * If you get an AFX_EXT_CLASS is redefined and this
 * is the first definition, then you need to make
 * sure "stdafx.h" is included before this file.
 */
#ifndef AFX_EXT_CLASS
#define AFX_EXT_CLASS
#endif

/* 
 * Error status codes for the TeamTrack API
 */
#define TS_OK 1
#define TS_ERROR -1
#define TS_INVALID_DATA_TYPE -2
#define TS_NO_PERMISSION -3
#define TS_NO_SUCH_FIELD -4
#define TS_MEMORY_ERROR -5
#define TS_SOCKET_READ_ERROR -6
#define TS_SOCKET_WRITE_ERROR -7
#define TS_SOCKET_CONNECT_FAILED -8
#define TS_SOCKET_CREATE_FAILED -9
#define TS_INVALID_DATATYPE -10
#define TS_INVALID_USER -11
#define TS_NO_RESULTS -12
#define TS_SERVER_ERROR -13
#define TS_INVALID_VERSION -14

/* SQL data type codes for Microsoft ODBC.*/
#define	SQL_EMPTY       	  0
#define SQL_CHAR            1
#define SQL_INTEGER         4
#define SQL_DOUBLE          8
#define SQL_VARCHAR        12
#define SQL_LONGVARCHAR  (-1)
#define SQL_LONGVARCHAR1 (1000)
#define SQL_LONGVARCHAR2 (1001)


#define TS_SCHEMATYPE_DBCOL    1
#define TS_SCHEMATYPE_DBXCOL   2
#define TS_SCHEMATYPE_NONDB    3
#define TS_SCHEMATYPE_LIST     4
#define TS_SCHEMATYPE_TREELIST 5

#define TS_DATATYPE_INTEGER    1
#define TS_DATATYPE_DOUBLE     2
#define TS_DATATYPE_BOOL       3
#define TS_DATATYPE_STRING     4
#define TS_DATATYPE_RECORDLIST 5
#define TS_DATATYPE_INTLIST    6
#define TS_DATATYPE_UNKNOWN    7


// Constants for GetDbInfo()
const int TS_DBINFO_VERSION           = 1;
const int TS_DBINFO_EXITURL           = 2;
const int TS_DBINFO_EXPIRATIONDATE    = 3;
const int TS_DBINFO_ROOTPROJECTID     = 4;
const int TS_DBINFO_ROOTPROJECTNAME   = 5;  
const int TS_DBINFO_DBMSNAME          = 6;
const int TS_DBINFO_DBMSVER           = 7;
const int TS_DBINFO_ROOTFOLDERID      = 8;
const int TS_DBINFO_OBJECTVERSION     = 9;
const int TS_DBINFO_VARCHARLENGTH     = 10;
const int TS_DBINFO_LONGVARCHARLENGTH = 11;
const int TS_DBINFO_ALLOWANONYMOUS    = 12;

// Table Id Values (used in Tables table)
const int TS_TBLID_NONE                      = -1; // default
const int TS_TBLID_CASES                     = 1;
const int TS_TBLID_CHANGES                   = 2;
const int TS_TBLID_FIELDS                    = 3;
const int TS_TBLID_GROUPS                    = 4;
const int TS_TBLID_LICENSES                  = 5;
const int TS_TBLID_MEMBERS                   = 6;
const int TS_TBLID_PRIVILEGES                = 7;
const int TS_TBLID_PROJECTS                  = 8;
const int TS_TBLID_PROJECTSELECTIONS         = 9;
const int TS_TBLID_PROPERTIES                = 10;
const int TS_TBLID_REPORTS                   = 11;
const int TS_TBLID_SELECTIONS                = 12;
const int TS_TBLID_STATES                    = 13;
const int TS_TBLID_TRANSISSUETYPES           = 14;
const int TS_TBLID_SYSTEMINFO                = 15;
const int TS_TBLID_TRANSITIONS               = 16;
const int TS_TBLID_USERS                     = 17;
const int TS_TBLID_TABLES                    = 18;
const int TS_TBLID_ATTACHMENTS               = 19;
const int TS_TBLID_FOLDERS                   = 20;
const int TS_TBLID_FOLDERITEMS               = 21;
const int TS_TBLID_FOLDERCOLUMNS             = 22;
const int TS_TBLID_VCACTIONS                 = 23;
const int TS_TBLID_PROJECTTRANSITIONS        = 24;
const int TS_TBLID_NOTIFICATIONS             = 25;
const int TS_TBLID_NOTIFICATIONRULES         = 26;
const int TS_TBLID_NOTIFICATIONCONDITIONS    = 27;
const int TS_TBLID_NOTIFICATIONEVENTS        = 28;
const int TS_TBLID_NOTIFICATIONFIELDS        = 29;
const int TS_TBLID_NOTIFICATIONMESSAGES      = 30;
const int TS_TBLID_NOTIFICATIONPERMISSIONS   = 31;
const int TS_TBLID_NOTIFICATIONSUBSCRIPTIONS = 32;
const int TS_TBLID_MACROS                    = 33;
const int TS_TBLID_WORKFLOWS                 = 34;
const int TS_TBLID_FIELDORDERINGS            = 35;
const int TS_TBLID_FIELDOVERRIDES            = TS_TBLID_FIELDORDERINGS; // DELETE IN NOVEMBER - Keven 10/27/99
const int TS_TBLID_INCIDENTS                 = 36;
const int TS_TBLID_COMPANIES                 = 37;
const int TS_TBLID_CONTACTS                  = 38;
const int TS_TBLID_MERCHANDISE               = 39;
const int TS_TBLID_SERVICEAGREEMENTS         = 40;
const int TS_TBLID_PROBLEMS                  = 41;
const int TS_TBLID_RESOLUTIONS               = 42;
const int TS_TBLID_PRODUCTS                  = 43;
const int TS_TBLID_KEYWORDS                  = 44;
const int TS_TBLID_PRODUCTUSAGES             = 45;
const int TS_TBLID_KEYWORDUSAGES             = 46;
const int TS_TBLID_TRANSTRIGGERS             = 47;
const int TS_TBLID_TRANSTRIGGERSTATES        = 48;
const int TS_TBLID_TRANSTRIGGERTRANSITIONS   = 49;

// Field Type Constants
const int TS_FLDTYPE_NUMERIC            = 100;
const int TS_FLDTYPE_TEXT               = 101;
const int TS_FLDTYPE_MEMO               = 102;
const int TS_FLDTYPE_DATETIME           = 103;
const int TS_FLDTYPE_SELECTION          = 104;
const int TS_FLDTYPE_BINARY             = 105;
const int TS_FLDTYPE_STATE              = 106;
const int TS_FLDTYPE_USER               = 107;
const int TS_FLDTYPE_PROJECT            = 108;
const int TS_FLDTYPE_SUMMATION          = 109;
const int TS_FLDTYPE_MULTIPLE_SELECTION = 110;
const int TS_FLDTYPE_CONTACT            = 111;
const int TS_FLDTYPE_COMPANY            = 112;
const int TS_FLDTYPE_INCIDENT           = 113;
const int TS_FLDTYPE_PRODUCT            = 114;
const int TS_FLDTYPE_SERVICEAGREEMENT   = 115;
const int TS_FLDTYPE_FOLDER             = 116;
const int TS_FLDTYPE_KEYWORDLIST        = 117;
const int TS_FLDTYPE_PRODUCTLIST        = 118;
const int TS_FLDTYPE_PROBLEM            = 119;
const int TS_FLDTYPE_RESOLUTION         = 120;
const int TS_FLDTYPE_MERCHANDISE        = 121;


// Field Attribute Constants
const int TS_FLDATTRIB_MEMO						= 0;
const int TS_FLDATTRIB_FIXEDTEXT				= 1;
const int TS_FLDATTRIB_INT							= 0;
const int TS_FLDATTRIB_FLOAT						= 1;
const int TS_FLDATTRIB_DT_DATEONLY			= 0;
const int TS_FLDATTRIB_DT_DATETIME			= 1;
const int TS_FLDATTRIB_DT_TIMEOFDAY		= 2;
const int TS_FLDATTRIB_DT_ELAPSEDTIME	= 3;
const int TS_FLDATTRIB_BIN_LISTBOX			= 0;
const int TS_FLDATTRIB_BIN_RADIOBUTTON	= 1;
const int TS_FLDATTRIB_BIN_CHECKBOX		= 2;

// Field Mask Constants

// Define generic field masks
#define TS_FLDMASK_USER                0x0001
#define TS_FLDMASK_ADVANCED            0x0002
#define TS_FLDMASK_MANAGER             0x0004
#define TS_FLDMASK_SYSTEM              0x0008
#define TS_FLDMASK_HIDDEN              0x0010

		// Define masks for m_chgmask
#define TS_FLDMASK_NONE                0x0001
#define TS_FLDMASK_ALL                 0x0002
#define TS_FLDMASK_LAST                0x0004
#define TS_FLDMASK_NEWEST_FIRST				0x0008

    // Define masks for m_browser
#define TS_FLDMASK_PREF_TABLE          0x000001    // off = prefer issues, on = prefer incidents
#define TS_FLDMASK_FOLDERS             0x000004
#define TS_FLDMASK_NOJAVA              0x000008
#define TS_FLDMASK_BROWSER_GENERIC     0x000010
#define TS_FLDMASK_MASSTRANS           0x000020    // indicates whether to show inactive issues on mass transitions
#define TS_FLDMASK_BROWSER_NETSCAPE		0x000040
#define TS_FLDMASK_BROWSER_EXPLORER		0x000080
#define TS_FLDMASK_ATTACHMENTS         0x001000
#define TS_FLDMASK_EMAIL_OWNER         0x002000
#define TS_FLDMASK_EMAIL_STATE         0x004000
#define TS_FLDMASK_EMAIL_CLOSED        0x008000
#define TS_FLDMASK_EMAIL_ALLSUBMIT     0x010000
#define TS_FLDMASK_EMAIL_ALLOWNER      0x020000
#define TS_FLDMASK_EMAIL_ALLSTATE      0x040000
#define TS_FLDMASK_EMAIL_ALLCLOSED     0x080000
#define TS_FLDMASK_EMAIL_LINK					0x100000
#define TS_FLDMASK_NOTES								0x200000
#define TS_FLDMASK_VCACTIONS           0x400000
#define TS_FLDMASK_SHOWFOLDERITEMS     0x800000

    // Define a mask for html types supported
#define TS_FLDMASK_NOTREQUIRED         0x0001
#define TS_FLDMASK_HTML_2              0x0002
#define TS_FLDMASK_HTML_3              0x0004
#define TS_FLDMASK_HTML_4              0x0008


// Max size for memo fields.
const int MAX_MEMO	= 65535;

// Field Property Constants 
const int TS_FLDPROP_DEFAULT        = 0; // Should be renamed to FLDSECTION
const int TS_FLDPROP_STANDARD       = 1;
const int TS_FLDPROP_USER           = 2;
const int TS_FLDPROP_ADVANCED       = 3;
const int TS_FLDPROP_MANAGER        = 4;
const int TS_FLDPROP_SYSTEM         = 5;
const int TS_FLDPROP_NOTUSED	      = 6;
const int TS_FLDPROP_NOTES          = 7;
const int TS_FLDPROP_CHANGEHISTORY  = 8;
const int TS_FLDPROP_VERSIONCONTROL = 9;
const int TS_FLDPROP_ATTACHMENTS    = 10;
const int TS_FLDPROP_DELETED        = 11;
const int TS_FLDPROP_MAX            = 12;

const int TS_FLDPROP_HIDDEN    = 32767;

const int TS_FLDPROP_NONE        = 0;
const int TS_FLDPROP_NONEDITABLE = 1;

const int TS_FLDREQ_NOTREQUIRED = 0;
const int TS_FLDREQ_REQUIRED    = 1;
const int TS_FLDREQ_DEFAULT     = 2;

const int TS_FLDACTION_DEFAULT  = 0;
const int TS_FLDACTION_SETTO    = 1;
const int TS_FLDACTION_CLEAR    = 2;

const int TS_FLDMASS_DISALLOW   = 0;
const int TS_FLDMASS_ALLOW      = 1;

const int TS_FLDQUERY_NONE         = 0x00;
const int TS_FLDQUERY_ALLOWQUERY   = 0x01;
const int TS_FLDQUERY_SHOWGO       = 0x02;
const int TS_QUERYMASK             = 0x01;
const int TS_SHOWGOMASK            = 0x02;

const int TS_FLDOPTION_SELECT_DEFAULT   =  0x00; // default field selection options
const int TS_FLDOPTION_SELECT_MULTIPLE  =  0x01; // allow multiple selections if set (otherwise allow only one selection)
const int TS_FLDOPTION_CHECKBOXES       =  0x02; // show a multi-selection field as checkboxes if set (otherwise use multi-selection list)

// Permission Masks
#define TS_PERMMASK_NORMAL   1
#define TS_PERMMASK_FOLDERS  1
#define TS_PERMMASK_REPORTS  2
#define TS_PERMMASK_ATTACH   3
#define TS_PERMMASK_NOTES    3
#define TS_PERMMASK_SECTIONS 4
#define TS_PERMMASK_SUPPORT  5

// Miscellaneous TS_PRIVileges (mask1 for privileges)
#define TS_PRIV_CREATENEWCASES    0x00000001
#define TS_PRIV_RELAXREQUIRED     0x00000002
#define TS_PRIV_VIEWUSER          0x00000004
#define TS_PRIV_VIEWADVANCED      0x00000008
#define TS_PRIV_VIEWMANAGER       0x00000010
#define TS_PRIV_ALLTRANS          0x00000020
#define TS_PRIV_VIEWSYSTEM        0x00000040
#define TS_PRIV_EDITUSER          0x00000080
#define TS_PRIV_EDITADVANCED      0x00000100
#define TS_PRIV_EDITMANAGER       0x00000200
#define TS_PRIV_EDITSYSTEM        0x00000400
#define TS_PRIV_EDITROUSER        0x00000800
#define TS_PRIV_EDITROADVANCED    0x00001000
#define TS_PRIV_EDITROMANAGER     0x00002000
#define TS_PRIV_EDITROSYSTEM      0x00004000
#define TS_PRIV_EDITPROFILE       0x00008000
#define TS_PRIV_VIEWALLISSUES     0x00010000
#define TS_PRIV_UPDATEALL         0x00020000
#define TS_PRIV_UPDATEIFOWNER     0x00040000
#define TS_PRIV_UPDATEIFSUBMITTER 0x00080000
#define TS_PRIV_VIEWIFOWNER       0x00100000
#define TS_PRIV_VIEWIFSUBMITTER   0x00200000
#define TS_PRIV_TRANSIFOWNER      0x00400000
#define TS_PRIV_TRANSIFSUBMITTER  0x00800000
#define TS_PRIV_OWN               0x01000000
#define TS_PRIV_DELETE            0x02000000
#define TS_PRIV_LOGONASUSER			  0x04000000
#define TS_PRIV_REMOTEADMIN       0x08000000
#define TS_PRIV_SOURCEBRIDGE      0x10000000
#define TS_PRIV_VIEWATTACHMENTS   0x20000000
#define TS_PRIV_VIEWNOTES         0x40000000
#define TS_PRIV_VIEWFOLDERS       0x80000000

// Folder TS_PRIVileges (mask1 for privileges when the record is a folder)
#define TS_PRIV_VIEWFOLDERITEMS   0x00000001
#define TS_PRIV_ADDTOFOLDER       0x00000002
#define TS_PRIV_REMOVEFROMFOLDER  0x00000004

// Report Permissions (mask2 for privileges)
#define TS_RPTPERM_CREATEPRIVATE 0x00000001
#define TS_RPTPERM_CREATEGUEST   0x00000002
#define TS_RPTPERM_CREATEUSER    0x00000004
#define TS_RPTPERM_CREATEMANAGER 0x00000008
#define TS_RPTPERM_EDITGUEST     0x00000010
#define TS_RPTPERM_EDITUSER      0x00000020
#define TS_RPTPERM_EDITMANAGER   0x00000040
#define TS_RPTPERM_EXECGUEST     0x00000080
#define TS_RPTPERM_EXECUSER      0x00000100
#define TS_RPTPERM_EXECMANAGER   0x00000200
#define TS_RPTPERM_DELGUEST      0x00000400
#define TS_RPTPERM_DELUSER       0x00000800
#define TS_RPTPERM_DELMANAGER    0x00001000

// Attachment & Notes TS_PRIVileges (mask3 for privileges)
#define TS_PRIV_ADDATTACHANY          0x00000001
#define TS_PRIV_ADDATTACHIFOWNER      0x00000002
#define TS_PRIV_ADDATTACHIFSUBMITTER  0x00000004
#define TS_PRIV_DELATTACHANY          0x00000008
#define TS_PRIV_DELATTACHIFOWNER      0x00000010
#define TS_PRIV_DELATTACHIFSUBMITTER  0x00000020
#define TS_PRIV_DELATTACHIFAUTHOR     0x00000040
#define TS_PRIV_ADDNOTEANY            0x00000080
#define TS_PRIV_ADDNOTEIFOWNER        0x00000100
#define TS_PRIV_ADDNOTEIFSUBMITTER    0x00000200
#define TS_PRIV_EDITNOTEANY           0x00000400
#define TS_PRIV_EDITNOTEIFOWNER       0x00000800
#define TS_PRIV_EDITNOTEIFSUBMITTER   0x00001000
#define TS_PRIV_EDITNOTEIFAUTHOR      0x00002000
#define TS_PRIV_DELNOTEANY            0x00004000
#define TS_PRIV_DELNOTEIFOWNER        0x00008000
#define TS_PRIV_DELNOTEIFSUBMITTER    0x00010000
#define TS_PRIV_DELNOTEIFAUTHOR       0x00020000
#define TS_PRIV_EDITATTACHANY         0x00040000
#define TS_PRIV_EDITATTACHIFOWNER     0x00080000
#define TS_PRIV_EDITATTACHIFSUBMITTER 0x00100000
#define TS_PRIV_EDITATTACHIFAUTHOR    0x00200000
#define TS_PRIV_ADDATTACHIFCONTACT    0x00400000
#define TS_PRIV_ADDNOTEIFCONTACT      0x00800000

// Field Section TS_PRIVileges (mask4 for privileges)
#define TS_PRIV_VIEWUSERONSUBMIT         0x00000001
#define TS_PRIV_VIEWADVANCEDONSUBMIT     0x00000002
#define TS_PRIV_VIEWMANAGERONSUBMIT      0x00000004
#define TS_PRIV_VIEWSYSTEMONSUBMIT       0x00000008
#define TS_PRIV_VIEWUSERONTRANSITION     0x00000010
#define TS_PRIV_VIEWADVANCEDONTRANSITION 0x00000020
#define TS_PRIV_VIEWMANAGERONTRANSITION  0x00000040
#define TS_PRIV_VIEWSYSTEMONTRANSITION   0x00000080
#define TS_PRIV_VIEWUSERONUPDATE         0x00000100
#define TS_PRIV_VIEWADVANCEDONUPDATE     0x00000200
#define TS_PRIV_VIEWMANAGERONUPDATE      0x00000400
#define TS_PRIV_VIEWSYSTEMONUPDATE       0x00000800
#define TS_PRIV_VIEWHIDDEN               0x00001000
#define TS_PRIV_APIACCESS                0x00002000
#define TS_PRIV_VIEWIFCONTACT            0x00004000

// tSupport TS_PRIVileges (mask 5 for TeamShare tables)
#define TS_PRIV_SUBMITCONTACTS           0x00000001
#define TS_PRIV_UPDATECONTACTS           0x00000002
#define TS_PRIV_DELETECONTACTS           0x00000004
#define TS_PRIV_VIEWCONTACTS             0x00000008
#define TS_PRIV_SUBMITCOMPANIES          0x00000010
#define TS_PRIV_UPDATECOMPANIES          0x00000020
#define TS_PRIV_DELETECOMPANIES          0x00000040
#define TS_PRIV_VIEWCOMPANIES            0x00000080
#define TS_PRIV_SUBMITMERCHANDISE        0x00000100
#define TS_PRIV_UPDATEMERCHANDISE        0x00000200
#define TS_PRIV_DELETEMERCHANDISE        0x00000400
#define TS_PRIV_VIEWMERCHANDISE          0x00000800
#define TS_PRIV_SUBMITPRODUCTS           0x00001000
#define TS_PRIV_UPDATEPRODUCTS           0x00002000
#define TS_PRIV_DELETEPRODUCTS           0x00004000
#define TS_PRIV_VIEWPRODUCTS             0x00008000
#define TS_PRIV_SUBMITPROBLEMS           0x00010000
#define TS_PRIV_UPDATEPROBLEMS           0x00020000
#define TS_PRIV_DELETEPROBLEMS           0x00040000
#define TS_PRIV_VIEWPROBLEMS             0x00080000
#define TS_PRIV_SUBMITRESOLUTIONS        0x00100000
#define TS_PRIV_UPDATERESOLUTIONS        0x00200000
#define TS_PRIV_DELETERESOLUTIONS        0x00400000
#define TS_PRIV_VIEWRESOLUTIONS          0x00800000
#define TS_PRIV_SUBMITSERVICEAGREEMENTS  0x01000000
#define TS_PRIV_UPDATESERVICEAGREEMENTS  0x02000000
#define TS_PRIV_DELETESERVICEAGREEMENTS  0x04000000
#define TS_PRIV_VIEWSERVICEAGREEMENTS    0x08000000
#define TS_PRIV_ASSIGNCONTACTLICENSE     0x10000000
#define TS_PRIV_VIEWCONTACTIFYOU         0x20000000
#define TS_PRIV_VIEWPUBLICPROBLEMS       0x40000000

// Enumeration type for HasRecordPrivilege
enum recPriv_e
{
  TS_RECPRIV_ERROR = 0,
  TS_RECPRIV_SUBMIT,
  TS_RECPRIV_VIEW,
  TS_RECPRIV_UPDATE,
  TS_RECPRIV_TRANSITION,
  TS_RECPRIV_DELETE,
  TS_RECPRIV_NOTEADD,
  TS_RECPRIV_NOTEEDIT,
  TS_RECPRIV_NOTEDELETE,
  TS_RECPRIV_ATTACHMENTADD,
  TS_RECPRIV_ATTACHMENTEDIT,
  TS_RECPRIV_ATTACHMENTDELETE,

  TS_RECPRIV_END  // Use for end
};

// Report types
const int TS_RPTTYPE_SUMMARY					= 1;
const int TS_RPTTYPE_DISTRIBUTION			= 2;
const int TS_RPTTYPE_TREND						= 4;
const int TS_RPTTYPE_QUERY_BY_EXAMPLE	= 16;
const int TS_RPTTYPE_QUERY_BY_SQL			= 32;
const int TS_RPTTYPE_DETAILS          = 64;

// Date Attributes
const int TS_DATEATTRIB_DATEONLY = 0;
const int TS_DATEATTRIB_DATETIME = 1;
const int TS_DATEATTRIB_TIMEONLY = 2;
const int TS_DATEATTRIB_ELAPSED  = 3;

// Change History Constants
const int TS_CHGACTION_SUBMIT = 0;
const int TS_CHGACTION_UPDATE = 1;
const int TS_CHGACTION_DELETE = 2;
const int TS_CHGACTION_ATTACHMENT_ADD = 3;
const int TS_CHGACTION_ATTACHMENT_UPDATE = 4;
const int TS_CHGACTION_ATTACHMENT_DELETE = 5;
const int TS_CHGACTION_VC_UPDATE = 7;

const int TS_CHGTYPE_INT   =    0;
const int TS_CHGTYPE_REAL  =    1;
const int TS_CHGTYPE_CHAR  =    2;

// Special DateTime Values
const int TS_NOW_DATETIME      =  -10;
const int TS_STARTOF_TODAY     =  -11;
const int TS_ENDOF_TODAY       =  -12;
const int TS_STARTOF_TOMORROW  =  -13;
const int TS_ENDOF_TOMORROW    =  -14;
const int TS_STARTOF_YESTERDAY =  -15;
const int TS_ENDOF_YESTERDAY   =  -16;
const int TS_STARTOF_THISMONTH =  -17;
const int TS_ENDOF_THISMONTH   =  -18;
const int TS_STARTOF_LASTMONTH =  -19;
const int TS_ENDOF_LASTMONTH   =  -20;
const int TS_STARTOF_NEXTMONTH =  -21;
const int TS_ENDOF_NEXTMONTH   =  -22;
const int TS_STARTOF_THISYEAR  =  -23;
const int TS_ENDOF_THISYEAR    =  -24;
const int TS_STARTOF_LASTYEAR  =  -25;
const int TS_ENDOF_LASTYEAR    =  -26;
const int TS_STARTOF_NEXTYEAR  =  -27;
const int TS_ENDOF_NEXTYEAR    =  -28;
const int TS_STARTOF_THISWEEK  =  -29;
const int TS_ENDOF_THISWEEK    =  -30;
const int TS_STARTOF_NEXTWEEK  =  -31;
const int TS_ENDOF_NEXTWEEK    =  -32;
const int TS_STARTOF_LASTWEEK  =  -33;
const int TS_ENDOF_LASTWEEK    =  -34;

const int TS_SECONDS_PER_DAY   = 86400;
const int TS_SECONDS_PER_WEEK  = TS_SECONDS_PER_DAY * 7;

// Reserve special DateTime Values from the range -1000 to -7000
//  plus -400 maps to -1600, plus 1000 maps to -3000
const int TS_DATETIME_BASE_PLUS = -2000;

// VC Action Constants
const int TS_VCACTION_NONE         = 0;
const int TS_VCACTION_CHECKOUT     = 1;
const int TS_VCACTION_CHECKIN      = 2;
const int TS_VCACTION_UNDOCHECKOUT = 3;

// consts for Transition types
const int TS_TRANSITION_REGULAR       = 0x00000000;
const int TS_TRANSITION_COPY          = 0x00000001;
const int TS_TRANSITION_SUBMITISSUE   = 0x00000002;
const int TS_TRANSITION_SUBMITPROBLEM = 0x00000004;
const int TS_TRANSITION_MOBILE        = 0x00000008;

// Constants to determine how a folder or project
// should be moved.
const int TS_CHILD         = 0;
const int TS_PRIOR_SIBLING = 1;
const int TS_NEXT_SIBLING  = 2;

// consts for date formats used in user preferences

const int TS_DATE_FORMAT_MM_DD_YYYY = 1;
const int TS_DATE_FORMAT_DD_MM_YYYY = 2;

// consts  for transition trigger types

const int TS_TRANS_FLG_TRIGGER         = 0x00000001;
const int TS_TRANS_FLG_TRIGGER_SRC     = 0x00000002;
const int TS_TRANS_FLG_TRIGGER_DEST    = 0x00000004;
const int TS_TRANS_FLG_SHOW_NEWNOTE    = 0x00000010;
const int TS_TRANS_FLG_REQUIRE_NEWNOTE = 0x00000020;

// consts for built in reports
const int TS_QUERY_UNKNOWN            = -1;
const int TS_QUERY_ALL                =  1;
const int TS_QUERY_ALLACTIVE          =  2;
const int TS_QUERY_ALLINACTIVE        =  3;
const int TS_QUERY_FOLDER             =  4;
const int TS_QUERY_MYALL              =  5;
const int TS_QUERY_MYACTIVE           =  6;
const int TS_QUERY_MYINACTIVE         =  7;
const int TS_QUERY_UNASSIGNED         =  8;
const int TS_QUERY_UNASSIGNEDACTIVE   =  9;
const int TS_QUERY_UNASSIGNEDINACTIVE = 10;
const int TS_QUERY_SUBMITALL          = 11;
const int TS_QUERY_SUBMITACTIVE       = 12;
const int TS_QUERY_SUBMITINACTIVE     = 13;
const int TS_QUERY_MASSTRANSITION     = 14;
const int TS_QUERY_CONTACTLIST        = 15;
const int TS_QUERY_KEYWORDS           = 16;
const int TS_QUERY_SEARCHID           = 17;
const int TS_QUERY_MAIL               = 18;
const int TS_QUERY_CONTACTALL         = 19;
const int TS_QUERY_CONTACTACTIVE      = 20;
const int TS_QUERY_CONTACTINACTIVE    = 21;

// Blank Values
#define TS_BLANK_BINARY            0
#define TS_BLANK_COMPANY           0
#define TS_BLANK_CONTACT           0
#define TS_BLANK_DATETIME          -2
#define TS_BLANK_FOLDER            0
#define TS_BLANK_INCIDENT          0
#define TS_BLANK_INT               (0x7fffffff)
#define TS_BLANK_MULTISELECT       ","
#define TS_BLANK_PRODUCT           0
#define TS_BLANK_PROJECT           0
#define TS_BLANK_REAL              ((double) 0xffffffff)
#define TS_BLANK_SELECT            0
#define TS_BLANK_SERVICEAGREEMENT  0
#define TS_BLANK_STATE             0
#define TS_BLANK_TEXT              ""
#define TS_BLANK_USER              0
#define TS_BLANK_PROBLEM           0
#define TS_BLANK_RESOLUTION        0
#define TS_BLANK_MERCHANDISE       0

// Empty Values (For Query By Example Reports)
#define TS_EMPTY_BINARY            -2
#define TS_EMPTY_COMPANY           -1
#define TS_EMPTY_CONTACT           -1
#define TS_EMPTY_DATETIME          -3
#define TS_EMPTY_FOLDER            -1
#define TS_EMPTY_INCIDENT          -1
#define TS_EMPTY_INT               (0x7ffffffe)
#define TS_EMPTY_MULTISELECT       ","
#define TS_EMPTY_PRODUCT           -1
#define TS_EMPTY_PROJECT           -1
#define TS_EMPTY_REAL              ((double) 0xfffffffe)
#define TS_EMPTY_SELECT            -2
#define TS_EMPTY_SERVICEAGREEMENT  -1
#define TS_EMPTY_STATE             -1
#define TS_EMPTY_TEXT              ""
#define TS_EMPTY_USER              -1
#define TS_EMPTY_PROBLEM           -1
#define TS_EMPTY_RESOLUTION        -1
#define TS_EMPTY_MERCHANDISE       -1

// other random values
#define TS_TREND_START_DATE_FIELDID -128
#define TS_TREND_END_DATE_FIELDID   -256

// Attachment Attributes
const int TS_ATTACHATTRIB_LINK  =  1;
const int TS_ATTACHATTRIB_HTTP  =  2;
const int TS_ATTACHATTRIB_HTTPS =  3;
const int TS_ATTACHATTRIB_FTP   =  4;
const int TS_ATTACHATTRIB_IMAGE = 10;

// New Attachment Attributes
const int TS_ATTACHATTRIB_FILE      =		0x0010;
const int TS_ATTACHATTRIB_URL		    =		0x0020;
const int TS_ATTACHATTRIB_ISSUE	    =		0x0040;
const int TS_ATTACHATTRIB_NOTE	    =		0x0080;
const int TS_ATTACHATTRIB_SHOWIMAGE =   0x1000;

// System Field Constants
const int TS_SYSFLD_ID                   =  1;
const int TS_SYSFLD_PARENTID             =  2;
const int TS_SYSFLD_PROJECTID            =  3;
const int TS_SYSFLD_TITLE                =  4;
const int TS_SYSFLD_DESC                 =  5;
const int TS_SYSFLD_STATE                =  6;
const int TS_SYSFLD_DT_CREATE            =  7;
const int TS_SYSFLD_DT_LASTMODIFIED      =  8;
const int TS_SYSFLD_DT_LASTSTATECHANGE   =  9;
const int TS_SYSFLD_DT_CLOSE             = 10;
const int TS_SYSFLD_DT_REOPEN            = 11;
const int TS_SYSFLD_USER_OWNER           = 12;
const int TS_SYSFLD_USER_SUBMITTER       = 13;
const int TS_SYSFLD_USER_LASTMODIFIER    = 14;
const int TS_SYSFLD_USER_LASTSTATECHANGER= 15;
const int TS_SYSFLD_TEXT_DISPLAYID       = 16;
const int TS_SYSFLD_SEL_CASETYPE         = 17;
const int TS_SYSFLD_BIN_ACTIVEINACTIVE   = 18;
const int TS_SYSFLD_FOLDERID             = 19;
const int TS_SYSFLD_LASTINCIDENT         = 20;
// sys fields for Incidents
const int TS_SYSFLD_COMPANY              = 100;
const int TS_SYSFLD_CONTACT              = 101;
const int TS_SYSFLD_MERCHANDISE          = 102;
const int TS_SYSFLD_SERVICEAGREEMENT     = 103;
const int TS_SYSFLD_PROBLEM              = 104;
const int TS_SYSFLD_RESOLUTION           = 105;
const int TS_SYSFLD_RESOLUTIONTITLE      = 106;
const int TS_SYSFLD_RESOLUTIONDESC       = 107;
// sys fields for Contacts
const int TS_SYSFLD_CONTACT_COMPID       = 200;
const int TS_SYSFLD_CONTACT_FNAME        = 201;
const int TS_SYSFLD_CONTACT_MNAME        = 202;
const int TS_SYSFLD_CONTACT_LNAME        = 203;
const int TS_SYSFLD_CONTACT_USERID       = 204;
const int TS_SYSFLD_CONTACT_EMAIL        = 206;
// sys fields for Companies
const int TS_SYSFLD_COMPANY_NUMBER       = 300;
// sys fields for Service Agreements
const int TS_SYSFLD_DT_EXPIRATION        = 400;
// sys fields for Problem/Resolutions
const int TS_SYSFLD_VISIBILITY           = 500;
const int TS_SYSFLD_PRODUCTS             = 501;


#endif