#include "stdafx.h"

#include "TSString.h"
#include "TSSocket.h"
#include "TSDisplayField.h"

TSDisplayField::TSDisplayField() :
  fieldName( "" ),
  displayValue( "" ),
  defaultValue( "" ),
  fieldType( "" ),
  fieldProperties( "" ),
  fieldId( 0 )
{
}
TSDisplayField::TSDisplayField(const TSDisplayField& displayField)
{
  Copy((TSDisplayField*)&displayField);
}
TSDisplayField::~TSDisplayField()
{
}
TSObject *TSDisplayField::NewObject()
{
  return new TSDisplayField;
}
void TSDisplayField::Copy(TSObject *obj)
{
  TSDisplayField *displayField = (TSDisplayField*)obj;
  fieldName = displayField->fieldName;
  displayValue = displayField->displayValue;
  defaultValue = displayField->defaultValue;
  fieldType = displayField->fieldType;
  fieldId = displayField->fieldId;
  fieldProperties = displayField->fieldProperties;
}
TSObject *TSDisplayField::Duplicate()
{
  TSDisplayField *field = new TSDisplayField;
  field->Copy( this );
  return field;
}
TSString TSDisplayField::StringDump(int recursive, TSString indentation)
{
  TSString s = indentation + "Field:\n";
  indentation += "  ";
  s += indentation + "FieldName: " + fieldName + "\r\n";
  s += indentation + "Value:     " + displayValue + "\r\n";
  s += indentation + "Default:   " + defaultValue + "\r\n";
  s += "\r\n";
  return s;
}
int TSDisplayField::Receive(TSSocket *socket)
{
  socket->ReceiveString( &fieldName );
  socket->ReceiveString( &displayValue );
  socket->ReceiveString( &defaultValue );
  socket->ReceiveString( &fieldType );
  socket->ReceiveString( &fieldProperties );
  socket->ReceiveInt( &fieldId );
  return TS_OK;
}
int TSDisplayField::SocketString(TSString& str)
{
  TSString encoded;
  TSEncodeString( fieldName, encoded );
  str += encoded;
  TSEncodeString( displayValue, encoded );
  str += encoded;
  TSEncodeString( defaultValue, encoded );
  str += encoded;
  TSEncodeString( fieldType, encoded );
  str += encoded;
  TSEncodeString( fieldProperties, encoded );
  str += encoded;
  TSEncodeInt( fieldId, encoded );
  str += encoded;

  return TS_OK;
}