#ifndef TSFIELD_H_
#define TSFIELD_H_

#include "TSList.h"
#include "TSSocket.h"

class AFX_EXT_CLASS TSField : public TSObject
{
  public:

    TSField();
    TSField( const TSField& field );
    virtual ~TSField();

    int Receive( TSSocket* socket, TSServer* server );
    int ReceiveSchema( TSSocket* socket );

    // Redefined from TSObject
    virtual TSObject* NewObject();
    virtual TSObject* Duplicate();
    virtual void Copy( TSObject * );
    virtual TSString StringDump( int recursive, TSString indentation );

    // Field Utility Functions
    TSString DumpSchema( TSString indentation );
    static TSString FieldTypeToName( int fieldType );
    int SocketString( TSString& out );

    // Field description information
    int  schemaType;
    char fieldName[64];
    int  dataType;
    int  fieldType;  // For use if this is a field of the Fields table.

    // Field data, one of these will have data, the rest will be 0 or NULL.
    char*         charValue;
    int           charValueMax;
    int           intValue;
    double        doubleValue;
    TSRecordList* recordList;

};

#endif