// TSRecord.h: interface for the TSRecord class.
//
/////////////////////////////////////////////////////////////////////////

#ifndef TSRECORD_H_
#define TSRECORD_H_

#include "TSList.h"
#include "TSObject.h"
#include "TSString.h"

class TSServer;
class TSSocket;

class AFX_EXT_CLASS TSRecord : public TSObject
{

  public:

    TSRecord( int tableId, TSServer* server, int fieldType=0 );
    TSRecord();
    virtual ~TSRecord();

    void Initialize( int tableId, TSServer* server, int fieldType );

    int SetInt   ( const char* fieldName, int value );
    int SetDouble( const char* fieldName, double value );
    int SetString( const char* fieldName, const char* value );

    int    GetInt   ( const char* fieldName, int* value );
    int    GetInt   ( const char* fieldName );
    int    GetDouble( const char* fieldName, double* value );
    double GetDouble( const char* fieldName );
    int    GetString( const char* fieldName, TSString* value );
    char*  GetString( const char* fieldName );
    int    GetString( const char* fieldName, char** value );
    int    GetString( const char* fieldName, char* value, int bufferSize );

    int           GetRecordList ( const char* fieldName, TSRecordList** value );
    TSRecordList* GetRecordList ( const char* fieldName );
    TSTreeList*   GetSubTreeList();

    int Receive                  ( TSSocket* socket );
    int ReceiveUserDefinedFields ( TSSocket* socket );
    int ReceiveFieldsBySchemaType( TSSocket* socket, int schemaType );

    virtual int SocketString( TSString& str );
    int MembersToStringBySchemaType( TSString& out, int schemaType );
    int UserDefinedFieldsToSocketString( TSString& out );

    virtual TSObject* NewObject();
    virtual TSObject* Duplicate();
    virtual void Copy( TSObject* );
    virtual TSString StringDump( int recursive, TSString indentation );


    TSFieldList fieldList;
    TSServer*   serverRef;
    int         tableId;
    TSString    tableName;

    // For records from the Fields table.
    int fieldType;
    int sqlDataType;

    // Functions used to set the Database action to take when record is
    // processed by a function like Update. Along with accessors.
    void SetNewRecord()       { recordState |= RecordNew; }
    void SetNewRecordWithID() { recordState |= RecordNewWithID; }
    void SetUpdatedRecord()   { recordState |= RecordUpdated; }
    void SetDeletedRecord()   { recordState |= RecordDeleted; }

    void ClearNewRecord()       { recordState &= ~RecordNew; }
    void ClearNewRecordWithID() { recordState &= ~RecordNewWithID; }
    void ClearUpdatedRecord()   { recordState &= ~RecordUpdated; }
    void ClearDeletedRecord()   { recordState &= ~RecordDeleted; }

  private:

    // Values or'ed into recordState in order to flag the record for later update.
    static const int RecordNew;
    static const int RecordNewWithID;
    static const int RecordUpdated;
    static const int RecordDeleted;

    BOOL recordState;
    BOOL fromPos;

    TSRecordList userDefinedFields;

    void CopyUserDefFieldsFrom();
    void CopyUserDefFieldsTo();

};

#endif
