
#ifndef TSSERVER_H_
#define TSSERVER_H_

#include "TSDef.h"
#include "TSList.h"
#include "TSString.h"
#include "TSSocket.h"
#include "TSRecord.h"

// disable the obnoxious warnings that stem from overly long symbol
// names when using STL classes.
#pragma warning( disable : 4786 )
#include <vector>

class AFX_EXT_CLASS TSSchema : public TSObject
{
  public:
    virtual ~TSSchema();
    virtual TSObject* NewObject();
    virtual TSObject* Duplicate();
    virtual void Copy( TSObject* obj );
    virtual TSString StringDump( int recursive, TSString indentation );
    virtual int SocketString( TSString& str );

    int tableId;
    int userDefinedFields;
    TSString name;
    TSFieldList fieldList;
};

class AFX_EXT_CLASS TSServer
{

  public:
	  int Transition( TSString& sLoginid,
                    TSRecord* pRec,
                    int nProjectId,
                    int nTableId,
                    int nRecordId,
                    int nTransition );
	  int Submit( int* nIssueId,
                TSString& sLoginid,
                TSRecord* pRec,
                int nTableId,
                int nProjectId,
                int nFolderId = 0,
                int nType = 0 );

    TSServer();
    ~TSServer();

    /*
     * Connect to the TeamTrack  server.
     */
    int Connect( const char* userName,
                 const char* password,
                 const char* serverAddress,
                 const char* proxyAddress = NULL );

    /*
     * Retrieve the schema for a table.
     * This is the schema pointer cached in the server so please don't modify
     * it or delete it.
     */
    TSSchema* GetSchema( int tableId );

    /*
     * Allocates a field list of all of the fields for this table.
     */
    int BuildFieldList( int tableId, TSFieldList &fieldList );

    /*
     * Database access functions.  You *MUST* call Connect() before you can call any of these functions.
     */
    int AddRecord( TSRecord* rec, TSRecord* newRec = NULL );
    int AddField( TSRecord* field, int tableId, int fieldType, int& fieldId );
    int CreateIndex( int tableId, TSList *columnNames, const char* indexName );
    int DeleteIndex( int tableId, const char* indexName );
    int DeleteRecord( int tableId, int id );
    int GetConnectionInfo( char* dsn, char* databaseName, char* serverName );
    int GetConnectionInfo( char** dsn, char** databaseName, char** serverName );
    int GetDbInfo( int infotype, void* out );
    int GetInt( int tblid, const char* columnName, int recId, int* result );
    int GetString( int tblid, const char* columnName, int recId, char* result, int size );
    int GetString( int tblid, const char* columnName, int recId, char** result );
    int GetSubmitTransition( int projectId, int* id );
    int HasPrivilege( int userId, int projectId, int maskNumber, int mask );
    int HasRecordPrivilege( enum recPriv_e recPriv, int userId, int tableId, int recId );
    int HasValidLicense( const char* solutionIdent );
    int MoveFolder( int folderId, int newParentId, int position );
    int MoveProject( int projectId, int newParentId, int position );
    int ReadAllRecords( TSRecordList* list, int tableId );
    int ReadFieldsByProject( TSRecordList* list, int projectId );
    int ReadAttachmentList( TSRecordList* list, int tableId, int recId );
    int ReadAvailableTransitionList( TSRecordList* list, int tableId, int recId );
    int ReadChangeList( TSRecordList* list, int caseId, BOOL newFirst = FALSE );
    int ReadFolderItems( TSRecordList* list, int folderId );
    int ReadFolderList( TSRecordList* list, int owner, int parentId );
    int ReadProjectSelectionList( TSRecordList* list, int selectId );
    int ReadProjectTransitionList( TSRecordList* list, int transitionId );
    int ReadPropertyList( TSRecordList* list, int transId );
    int ReadRecord( TSRecord* record, int id );
  	int ReadRecordWithWhere( TSRecord* record, const char* whereClause );

    // Reads a record, filtering by the where clause and returning 
    // only the desired fields
    int ReadRecordWithWhere( TSRecord* record, const char* whereClause,
                             const std::vector <int> & fields );

    // Reads a record list, filtering by the where clause and returning 
    // only the desired fields
   	int ReadRecordListWithWhere( TSRecordList* recordList, int tableId, const char* whereClause );
   	int ReadRecordListWithWhere( TSRecordList* recordList, int tableId, const char* whereClause,
                                 const std::vector <int> & fields );

    int ReadRecordForId( TSRecord* record, const char* searchId );
    int ReadReport( TSRecord* report, const char* name );
    int ReadReportList( TSRecordList* list, long userId, int perm );
    int ReadSelectionList( TSRecordList* list, int fieldId, int projectId );
    int ReadStateList( TSRecordList* list, int projectId, BOOL incParent = FALSE );
    int ReadTransitionList( TSRecordList* list, int projectId );
    int ReadUserDefinedFields( TSRecordList* list, int tableId );
    int ReadUserListForPrivilege( TSRecordList* list, int userid, TSRecordList* fieldList, int mask );
    int ReadUserSelectionList( TSRecordList* list, int fieldId, int projectId, BOOL incDeleted = FALSE );
    int ReadVCActionsForModule( TSRecordList* list, const char* filename, int userid, int action2 = 0 );
    int ReadVCActions( TSRecordList* list, int caseId );
    int SetExitUrl( const char* exitUrl );
  	int UpdateList( TSRecordList* list, int tableId, int recid1 = 0, int recid2 = 0 );
    int UpdateRecord( TSRecord* rec, TSRecord* newRec = NULL );
    int ValidateUser( const char* loginId, const char* pwd, BOOL validatePwd=TRUE, int* userId = NULL );
    int ValidateVersion();
    const char* GetLastErrorMessage();
    const char* GetDllWebAddress();
    int RefreshCache( const int tableId );

  private:
    // Member variables set by ::Connect used for communications
    TSString protocolString;  // protocol used to connect with (http or https)
    TSString serverName;      // name of the server connected to
    TSString directoryName;   // usually tmtrack
    TSString dllName;         // usually tmtrack.dll?
    int      portNumber;      // port number to connect to (80 or 443)

    TSString proxyString;     // proxy to be used to connect to the web server
    
    TSString authString;      // Basic Authentication string with encoded user:password
    TSString dllWebAddress;   // serverName/directoryName/dllName

    // Other member variables
    TSString errorMsg;
    TSList schemaCache;

    TSSocket* OpenSocket();
    int  Send( TSSocket* socket, const char* s );

    TSString EncodePassword( const char* password );

};

void TSSetLastError( int errorCode );
void TSClearLastError();
int TSGetLastError();

#endif