
#ifndef TSSOCKET_H_
#define TSSOCKET_H_


/*
 * If we aren't using MFC then let's define our own base socket
 * class.  If we are using MFC then we want to use the MFC CSocket
 * class so that we can pump messages while waiting on the socket.
 */

#ifdef TS_USE_MFC
  #include "afxsock.h"
  #ifdef TS_USE_WININET
    #include <wtypes.h>
    #include <wininet.h>
  #else
    #define TS_USE_WINSOCK
  #endif
#else
  #ifdef WIN32
    #ifdef TS_USE_WININET
      #include <wtypes.h>
      #include <wininet.h>
    #else
      #define TS_USE_WINSOCK
      #include <winsock.h>
    #endif
  #else
    #include <sys/socket.h>
    typedef struct sockaddr SOCKADDR;
    typedef struct sockaddr_in SOCKADDR_IN;
    typedef struct hostent *LPHOSTENT;
    typedef struct in_addr *LPIN_ADDR;
    #define SOCKET_ERROR -1
    #define INVALID_SOCKET -1
  #endif
  class CSocket
  {

    public:

      BOOL Create ( unsigned int socketPort = 0,
                    int socketType = SOCK_STREAM,
                    const char* socketAddress = NULL );
      BOOL Connect( const char* hostAddress,
                    unsigned int portNumber );
      BOOL Connect( const SOCKADDR* lpSockAddr, int sockAddrLen );
      BOOL Bind   ( unsigned int socketPort, const char* socketAddress );
      BOOL Bind   ( const SOCKADDR* lpSockAddr, int nSockAddrLen );
      BOOL Socket ( int nSocketType=SOCK_STREAM, int nProtocolType=0, int addressFormat=PF_INET );

      virtual void Close();
      virtual int  Send( const void* lpBuf, int nBufLen, int nFlags = 0 );
      virtual int  Receive( void* lpBuf, int nBufLen, int nFlags = 0 );

      int GetLastError();

    private:
      
      int m_hSocket;

  };
#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Convenience function to initialize Winsock if you're using windows.
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
#if defined( TS_USE_WINSOCK ) || defined( TS_USE_WININET )
int AFX_EXT_CLASS TSInitializeWinsock();
#endif

class TSSocket : public CSocket
{

  public:

    TSSocket();
    virtual ~TSSocket();

    int  Read( char* buffer, int size );
    int  ReadLine( char* buffer, int size );
    char ReadChar();

    void ClearBuffer() { bufferStart = bufferEnd = 0; }
    BOOL Create(  const char* protocol,
                  const char* directory,
                  const char* dll,
                  const char* auth,
                  const char* proxy );

    BOOL Connect( const char *hostAddress, unsigned int portNumber);
    int IsConnected() { return connected; }
    virtual void Close();

    virtual int Send( const void* lpBuf, int nBufLen, int nFlags = 0 );
    BOOL GetHttpStatusCode( int& code );

    int ReceiveInt(int *val);
    int ReceiveString(TSString *str);
    int ReceiveString(char *str, int size);
    int ReceiveDouble(double *val);



  private:

    void Initialize();
    int  FillBuffer();

    char *socketBuffer;
    int socketBufferSize;
    int bufferStart;
    int bufferEnd;

    int connected;

#ifdef TS_USE_WININET
    HINTERNET hOpen;
    HINTERNET hConnect;
    HINTERNET hRequest;
#endif

    const char* protocolString;  // protocol used to connect with (http or https)
    const char* directoryName;   // usually tmtrack
    const char* dllName;         // usually tmtrack.dll?    
    const char* authString;      // Basic Authentication string with encoded user:password
    const char* proxyString;     // proxy host machine

};

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Global Utility functions to encode data values to a string to be sent
 * accross the socket to the TeamTrack server.
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
void TSEncodeDouble( double      in, TSString& out );
void TSEncodeInt   ( int         in, TSString& out );
void TSEncodeString( TSString&   in, TSString& out );
void TSEncodeString( const char* in, TSString& out );
void TSEncodeText  ( TSString&   in, TSString& out );
void TSEncodeText  ( const char* in, TSString& out );


#endif
