
#ifndef TSSTRING_H_
#define TSSTRING_H_

#include <string.h>

#include "TSDef.h"
#include "TSObject.h"

class AFX_EXT_CLASS TSString : public TSObject
{
  public:

    TSString(const char *str);
    TSString();
    TSString(const TSString & str);
    ~TSString();

    TSString& operator += (char *str);
    TSString& operator += (TSString str);
    TSString& operator += (char c);
    TSString& operator = (const char *str);
    TSString& operator = (TSString str);
    BOOL operator == (TSString str);
    BOOL operator == (const char *str);
    char operator [] (int idx);
    TSString operator + (TSString second);
    TSString operator + (char *str);
    operator const char*();

    int Length() { return length; }

    void TrimRight( const char* str=NULL );
    void TrimRight( const char c );
    void TrimRight( const TSString str );
    void TrimLeft( const char* str=NULL );
    void TrimLeft( const char c );
    void TrimLeft( const TSString str );


    char *GetBuffer() { return buffer; }
    char *GetBuffer(size_t minsize);

    int CompareNoCase( const char *str );

    // Inherited from TSObject
    virtual TSObject *NewObject();
    virtual void Copy(TSObject *);
    virtual TSObject *Duplicate();
    virtual TSString StringDump(int recursive, TSString indentation);
    virtual int SocketString(TSString &str);

  private:

    char *buffer;
    unsigned int bufsize;
    static int BUFFER_EXCESS;
    size_t length;
};

#endif
