// TSAttachment.cpp: implementation of the TSAttachment class.
//
/////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include <stdio.h>
#include "TSAttachment.h"
#include "TSServer.h"


TSAttachment::TSAttachment( TSServer& server, int nItemId /*=0*/ )
  : m_nFileLength     ( 0 ),
    m_nType           ( 0 ),
    m_pFileData       ( NULL ),
    m_sAuthor         ( "" ),
    m_sDateTimeCreated( "" ),
    m_sText           ( "" ),
    TSRecordRef       ( server, TS_TBLID_ATTACHMENTS, nItemId )
{
}

TSAttachment::TSAttachment( const TSAttachment& that )
  : m_nFileLength     ( that.m_nFileLength ),
    m_nType           ( that.m_nType ),
    m_pFileData       ( that.m_pFileData ),
    m_sAuthor         ( that.m_sAuthor ),
    m_sDateTimeCreated( that.m_sDateTimeCreated ),
    m_sText           ( that.m_sText ),
    TSRecordRef       ( that )
{
  m_pFileData = new char[ m_nFileLength ];
  memcpy( m_pFileData, that.m_pFileData, that.m_nFileLength );
}

TSAttachment::~TSAttachment()
{
  delete [] m_pFileData;
}

TSAttachment& TSAttachment::operator = ( const TSAttachment& that )
{
  TSRecordRef::operator = ( that );
  m_nFileLength      = that.m_nFileLength;
  m_nType            = that.m_nType;
  m_pFileData        = that.m_pFileData;
  m_sAuthor          = that.m_sAuthor;
  m_sDateTimeCreated = that.m_sDateTimeCreated;
  m_sText            = that.m_sText;
  return *this;
}

int TSAttachment::Read()
{
  TSSetLastError( TS_ERROR );
  return TSGetLastError();
}

int TSAttachment::Receive( TSSocket* socket )
{
  if ( socket->ReceiveInt( &m_nItemId ) != TS_OK )
  {
    return TSGetLastError();
  }
  if ( socket->ReceiveInt( &m_nTableId ) != TS_OK )
  {
    return TSGetLastError();
  }
  if ( socket->ReceiveString( &m_sItemName ) != TS_OK )
  {
    return TSGetLastError();
  }
  if ( socket->ReceiveInt( &m_nFileLength ) != TS_OK )
  {
    return TSGetLastError();
  }
  if ( socket->ReceiveInt( &m_nType ) != TS_OK )
  {
    return TSGetLastError();
  }
  if ( socket->ReceiveString( &m_sAuthor ) != TS_OK )
  {
    return TSGetLastError();
  }
  if ( socket->ReceiveString( &m_sDateTimeCreated ) != TS_OK )
  {
    return TSGetLastError();
  }
  if ( socket->ReceiveString( &m_sText ) != TS_OK )
  {
    return TSGetLastError();
  }
  if ( socket->ReceiveBinary( &m_pFileData, m_nFileLength ) != TS_OK )
  {
    return TSGetLastError();
  }
  return TS_OK;
}

int TSAttachment::SetItemId( int nNewItemId )
{
  nNewItemId;
  TSSetLastError( TS_ERROR );
  return TSGetLastError();
}

int TSAttachment::SetTableId( int nNewTableId )
{ 
  nNewTableId;
  TSSetLastError( TS_ERROR );
  return TSGetLastError();
}

TSString TSAttachment::StringDump( TSString sIndentation )
{
  char tmpBuf[64];
  TSString sSpacer = sIndentation + "  ";
  TSString s = sIndentation + "Attachment:\n";
  
  s += sSpacer + "Item Name = ";
  s += m_sItemName + "\n";

  s += sSpacer + "Item Id = ";
  sprintf( tmpBuf, "%ld", m_nItemId );
  s += tmpBuf;
  s += "\n";

  s += sSpacer + "Table Id = ";
  sprintf( tmpBuf, "%ld", m_nTableId );
  s += tmpBuf;
  s += "\n";

  s += sSpacer + "File Length = ";
  sprintf( tmpBuf, "%ld", m_nFileLength );
  s += tmpBuf;
  s += "\n";

  s += sSpacer + "Type = ";
  sprintf( tmpBuf, "%ld", m_nType );
  s += tmpBuf;
  s += "\n";

  s += sSpacer + "Author = ";
  s += m_sAuthor + "\n";

  s += sSpacer + "DateTime Created = ";
  s += m_sDateTimeCreated + "\n";

  s += sSpacer + "Text = ";
  s += m_sText + "\n";

  // If the file is binary then it might contain embedded nulls.
  if ( m_nType & TS_ATTACHATTRIB_FILE )
  {
    int charsToShow = min( m_nFileLength, 40 );
    memcpy( tmpBuf, m_pFileData, min( m_nFileLength, charsToShow ) );
    tmpBuf[charsToShow] = '\0';
    s += sSpacer + "First 40 chars (max) of file = ";
    s += tmpBuf;
    s += "\n";
  }
  s +="\n";
  return s;
}