// TSAttachment.h: interface for the TSAttachment class.
//
/////////////////////////////////////////////////////////////////////////

#ifndef TSATTACHMENT_H_
#define TSATTACHMENT_H_

#pragma warning( push, 1 )
#include "DisableSTLWarnings.h"
#include <list>
#pragma warning( pop )

#include "TSRecordRef.h"
#include "TSString.h"


// This class describes a file, URL, or a note attachment.

class AFX_EXT_CLASS TSAttachment : public TSRecordRef
{
  friend class TSServer;
  public:
    // The constructor will automatically set the table id member
    TSAttachment( TSServer& server, int nItemId = 0 );
    TSAttachment( const TSAttachment& that );
    virtual ~TSAttachment();
    TSAttachment& operator = ( const TSAttachment& that );

    // Accessor methods
    const TSString& GetAuthor() const          { return m_sAuthor; }
    const TSString& GetDateTimeCreated() const { return m_sDateTimeCreated; }
    const char*     GetFileData() const        { return m_pFileData; }
    int             GetFileLength() const      { return m_nFileLength; }
    const TSString& GetText() const            { return m_sText; }
    int             GetType() const            { return m_nType; }

    // For debugging
    TSString StringDump( TSString sIndentation );

  protected:
    // Only intended to be called by member methods of TSServer.
    int Receive( TSSocket* socket );

    int      m_nFileLength;      // Specifies the length of the file
    int      m_nType;            // The type of attachment (see TS_ATTACHATTRIB_ in TSDef.h)
    char*    m_pFileData;        // Points to the file contents if the attachment is
                                 //  a file and the contents were requested
    TSString m_sAuthor;          // The user name of the author of the attachment
    TSString m_sDateTimeCreated; // When the attachment was created
    TSString m_sText;            // The attachment content: the text of a note (when requested),
                                 //  the URL string of an URL, or the path to the server's copy of a file.

  private:
    virtual int Read();
    int         ReadById( int nItemId );
    virtual int SetItemId( int nNewItemId );
    virtual int SetTableId( int nNewTableId );

};

typedef std::list< TSAttachment* >  TSAttachmentList;

#endif
