// TSAuxiliaryItem.cpp: implementation of the TSAuxiliaryItem class.
//
/////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include <stdio.h>
#include "TSAuxiliaryItem.h"
#include "TSServer.h"

// This class defines the interface for an item that has variable fields
//  and is not a Primary Item. Contacts, Companies, and other auxiliary
//  table items will use this class. Incidents, Issues, and other primary
//  table items will use the TSPrimaryItem class.

TSAuxiliaryItem::TSAuxiliaryItem( TSServer& server, int nTableId /*=0*/, int nItemId /*=0*/ )
  : TSItem( server, nTableId, nItemId )
{
}

TSAuxiliaryItem::TSAuxiliaryItem( const TSAuxiliaryItem& that )
  : TSItem( that )
{
}

TSAuxiliaryItem::~TSAuxiliaryItem()
{
}

TSAuxiliaryItem& TSAuxiliaryItem::operator = ( const TSAuxiliaryItem& that )
{
  TSItem::operator = ( that );
  return *this;
}

int TSAuxiliaryItem::CancelUpdate()
{
  if ( !IsValid() )
  {
    TSSetLastError( TS_INVALID_PARAMETERS );
    return TSGetLastError();
  }
  int nResult = m_server.TSAuxiliaryItemCancelUpdate( *this );
  if ( nResult == TS_OK )
  {
    m_nMode = NOT_IN_TRANSITION;
    m_nItemId = 0;
  }
  return nResult;
}

int TSAuxiliaryItem::FinishUpdate( bool bStealLockFlag /*=false*/ )
{
  if ( m_nMode == TRANSITION_STARTED )
  {
    if ( !IsValid() )
    {
      TSSetLastError( TS_INVALID_PARAMETERS );
      return TSGetLastError();
    }
    int nResult = m_server.TSAuxiliaryItemFinishUpdate( *this, bStealLockFlag );
    if ( nResult == TS_OK ) // TO DO: Which return values release the lock?
    {
      m_nMode = NOT_IN_TRANSITION;
    }
    return nResult;
  }
  else
  {
    return TS_INCORRECT_MODE;
  }
}

int TSAuxiliaryItem::Read()
{
  if ( !IsValid() )
  {
    TSSetLastError( TS_INVALID_PARAMETERS );
    return TSGetLastError();
  }
  if ( m_nMode == TRANSITION_STARTED )
  {
    TSSetLastError( TS_INCORRECT_MODE );
    return TSGetLastError();
  }
  else
  {
    return m_server.TSAuxiliaryItemRead( *this );
  }
}

int TSAuxiliaryItem::StartUpdate( bool bLockFlag /*=true*/ )
{
  if ( m_nMode == NOT_IN_TRANSITION )
  {
    if ( !IsValid() )
    {
      TSSetLastError( TS_INVALID_PARAMETERS );
      return TSGetLastError();
    }
    int nResult = m_server.TSAuxiliaryItemStartUpdate( *this, bLockFlag );
    if ( nResult == TS_OK )
    {
      m_nMode = TRANSITION_STARTED;
    }
    return nResult;
  }
  else
  {
    return TS_INCORRECT_MODE;
  }
}

TSString TSAuxiliaryItem::StringDump( TSString sIndentation )
{
  char tmpBuf[64];
  TSString sSpacer = sIndentation + "  ";
  TSString s = sIndentation + "AuxiliaryItem:\n";

  s += sSpacer + "Item Name = ";
  s += m_sItemName + "\n";

  s += sSpacer + "Item Id = ";
  sprintf( tmpBuf, "%ld", m_nItemId );
  s += tmpBuf;
  s += "\n";

  s += sSpacer + "Table Id = ";
  sprintf( tmpBuf, "%ld", m_nTableId );
  s += tmpBuf;
  s += "\n";

  s += sSpacer + "Section Mask = ";
  sprintf( tmpBuf, "%ld", m_nSectionMask );
  s += tmpBuf;
  s += "\n";

  s += sSpacer + "Transition Id = ";
  sprintf( tmpBuf, "%ld", m_nTransitionId );
  s += tmpBuf;
  s += "\n\n";

  // Spit out Attachment List
  TSAttachmentList::iterator itAttach = m_attachmentList.begin();
  for ( ; itAttach != m_attachmentList.end(); itAttach++ )
  {
    s += (*itAttach)->StringDump( sIndentation );
  }

  // Spit out Change History
  TSChangeList::iterator itChange = m_changeList.begin();
  for ( ; itChange != m_changeList.end(); itChange++ )
  {
    s += (*itChange)->StringDump( sIndentation );
  }

  // Spit out Display Fields
  TSDisplayFieldList::iterator itField = m_fieldList.begin();
  for ( ; itField != m_fieldList.end(); itField++ )
  {
    s += (*itField)->StringDump( sIndentation );
  }

  // Spit out Item Links
  TSItemLinkList::iterator itLink = m_linkList.begin();
  for ( ; itLink != m_linkList.end(); itLink++ )
  {
    s += (*itLink)->StringDump( sIndentation );
  }
  return s;
}
