// TSAuxiliaryItem.h: interface for the TSAuxiliaryItem class.
//
/////////////////////////////////////////////////////////////////////////

#ifndef TSAUXILIARYITEM_H_
#define TSAUXILIARYITEM_H_

#pragma warning( push, 1 )
#include "DisableSTLWarnings.h"
#include <list>
#pragma warning( pop )

#include "TSItem.h"


// This class defines the interface for an item that has variable fields
//  and is not a Primary Item. Contacts, Companies, and other auxiliary
//  table items will use this class. Incidents, Issues, and other primary
//  table items will use the TSPrimaryItem class.

class AFX_EXT_CLASS TSAuxiliaryItem : public TSItem
{
  friend class TSServer;
  public: 
    // Constructors/destructors/operator =
    TSAuxiliaryItem( TSServer& server, int nTableId = 0, int nItemId = 0 );
    TSAuxiliaryItem( const TSAuxiliaryItem& that );
    virtual ~TSAuxiliaryItem();
    TSAuxiliaryItem& operator = ( const TSAuxiliaryItem& that );

    // The CancelUpdate method clears the lock on this record. It is for
    //  use after a call to StartUpdate, but when FinishUpdate will not be
    //  called.
    // This requires a roundtrip to the server.
    virtual int CancelUpdate();

    // The FinishUpdate method is used to update the item in the database
    //  after field values in the field list (obtained from StartUpdate)
    //  have been set. This method will only send fields that have been
    //  modified back to the server. After a successful database update,
    //  the lock (if it exists) will be removed. This method can return
    //  TS_LOCK_UNAVAILABLE if the lock has expired and another user has
    //  taken the lock.
    // This requires a roundtrip to the server.
    virtual int FinishUpdate( bool bStealLockFlag = false );

    // This Read method will populate the item as specified by m_nSectionMask,
    //  taking into consideration the privileges of user (or alternate user 
    //  if set) and ordering fields as they would be when viewed in the browser.
    //  The table and item ids must already be set (or TS_INVALID_PARAMETERS
    //  will be returned), such as by constructing this class with the nTableId
    //  parameter and then calling the ReadById method of the base class.
    // This requires a roundtrip to the server.
    virtual int Read();

    // The StartUpdate method should be used to fill in this item as
    //  appropriate for an update. StartUpdate populates the item and
    //  orders fields as they would be for an update, including filling
    //  out field selection lists. The three other member lists of a TSItem:
    //  changeList, attachmentList and linkList, will not be updated. The
    //  bLockFlag is defaulted to lock this record. While the record is
    //  locked, any other user (via API or browser interface) will receive
    //  an error (TS_LOCK_UNAVAILABLE for API) if they attempt to update
    //  the same record. The time a lock is held is set by the TeamTrack
    //  administrator. The table id and item id must be preset.
    // This requires a roundtrip to the server.
    virtual int StartUpdate( bool bLockFlag = true );

    // For debugging
    TSString StringDump( TSString sIndentation );

  protected:
    // No additional data members are needed for this class.

};

typedef std::list< TSAuxiliaryItem* > TSAuxiliaryItemList;

#endif
