// TSChangeHistory.cpp: implementation of the TSChangeHistory class.
//
/////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include <stdio.h>
#include "TSChangeHistory.h"
#include "TSServer.h"


TSChangeHistory::TSChangeHistory( TSServer& server, int nItemId /*=0*/ )
  : m_nActionType       ( 0 ),
    m_nFieldAttribute   ( 0 ),
    m_nFieldId          ( 0 ),
    m_nFieldType        ( 0 ),
    m_nNewInt           ( 0 ),
    m_nPriorInt         ( 0 ),
    m_nType             ( 0 ),
    m_sAuthor           ( "" ),
    m_sDateTime         ( "" ),
    m_sFieldName        ( "" ),
    m_sNewDisplayValue  ( "" ),
    m_sPriorDisplayValue( "" ),
    TSRecordRef         ( server, TS_TBLID_CHANGES, nItemId )
{
}

TSChangeHistory::TSChangeHistory( const TSChangeHistory& that )
  : m_nActionType       ( that.m_nActionType ),
    m_nFieldAttribute   ( that.m_nFieldAttribute ),
    m_nFieldId          ( that.m_nFieldId ),
    m_nFieldType        ( that.m_nFieldType ),
    m_nNewInt           ( that.m_nNewInt ),
    m_nPriorInt         ( that.m_nPriorInt ),
    m_nType             ( that.m_nType ),
    m_sAuthor           ( that.m_sAuthor ),
    m_sDateTime         ( that.m_sDateTime ),
    m_sFieldName        ( that.m_sFieldName ),
    m_sNewDisplayValue  ( that.m_sNewDisplayValue ),
    m_sPriorDisplayValue( that.m_sPriorDisplayValue ),
    TSRecordRef         ( that )
{
}

TSChangeHistory::~TSChangeHistory()
{
}

TSChangeHistory& TSChangeHistory::operator = ( const TSChangeHistory& that )
{
  TSRecordRef::operator = ( that );
  m_nActionType        = that.m_nActionType;
  m_nFieldAttribute    = that.m_nFieldAttribute;
  m_nFieldId           = that.m_nFieldId;
  m_nFieldType         = that.m_nFieldType;
  m_nNewInt            = that.m_nNewInt;
  m_nPriorInt          = that.m_nPriorInt;
  m_nType              = that.m_nType;
  m_sAuthor            = that.m_sAuthor;
  m_sDateTime          = that.m_sDateTime;
  m_sFieldName         = that.m_sFieldName;
  m_sNewDisplayValue   = that.m_sNewDisplayValue;
  m_sPriorDisplayValue = that.m_sPriorDisplayValue;
  return *this;
}

int TSChangeHistory::Read()
{
  TSSetLastError( TS_ERROR );
  return TSGetLastError();
}

int TSChangeHistory::Receive( TSSocket* socket )
{
  if ( socket->ReceiveInt( &m_nItemId ) != TS_OK )
  {
    return TSGetLastError();
  }
  if ( socket->ReceiveInt( &m_nTableId ) != TS_OK )
  {
    return TSGetLastError();
  }
  if ( socket->ReceiveString( &m_sItemName ) != TS_OK )
  {
    return TSGetLastError();
  }
  if ( socket->ReceiveInt( &m_nActionType ) != TS_OK )
  {
    return TSGetLastError();
  }
  if ( socket->ReceiveInt( &m_nFieldAttribute ) != TS_OK )
  {
    return TSGetLastError();
  }
  if ( socket->ReceiveInt( &m_nFieldId ) != TS_OK )
  {
    return TSGetLastError();
  }
  if ( socket->ReceiveInt( &m_nFieldType ) != TS_OK )
  {
    return TSGetLastError();
  }
  if ( socket->ReceiveInt( &m_nNewInt ) != TS_OK )
  {
    return TSGetLastError();
  }
  if ( socket->ReceiveInt( &m_nPriorInt ) != TS_OK )
  {
    return TSGetLastError();
  }
  if ( socket->ReceiveInt( &m_nType ) != TS_OK )
  {
    return TSGetLastError();
  }
  if ( socket->ReceiveString( &m_sAuthor ) != TS_OK )
  {
    return TSGetLastError();
  }
  if ( socket->ReceiveString( &m_sDateTime ) != TS_OK )
  {
    return TSGetLastError();
  }
  if ( socket->ReceiveString( &m_sFieldName ) != TS_OK )
  {
    return TSGetLastError();
  }
  if ( socket->ReceiveString( &m_sNewDisplayValue ) != TS_OK )
  {
    return TSGetLastError();
  }
  if ( socket->ReceiveString( &m_sPriorDisplayValue ) != TS_OK )
  {
    return TSGetLastError();
  }
  return TS_OK;
}

int TSChangeHistory::SetItemId( int nNewItemId )
{
  nNewItemId;
  TSSetLastError( TS_ERROR );
  return TSGetLastError();
}

int TSChangeHistory::SetTableId( int nNewTableId )
{ 
  nNewTableId;
  TSSetLastError( TS_ERROR );
  return TSGetLastError();
}

TSString TSChangeHistory::StringDump( TSString sIndentation )
{
  char tmpBuf[64];
  TSString sSpacer = sIndentation + "  ";
  TSString s = sIndentation + "Change History:\n";

  s += sSpacer + "Item Name = ";
  s += m_sItemName + "\n";

  s += sSpacer + "Item Id = ";
  sprintf( tmpBuf, "%ld", m_nItemId );
  s += tmpBuf;
  s += "\n";

  s += sSpacer + "Table Id = ";
  sprintf( tmpBuf, "%ld", m_nTableId );
  s += tmpBuf;
  s += "\n";

  s += sSpacer + "Action Type = ";
  sprintf( tmpBuf, "%ld", m_nActionType );
  s += tmpBuf;
  s += "\n";

  s += sSpacer + "Field Attribute = ";
  sprintf( tmpBuf, "%ld", m_nFieldAttribute );
  s += tmpBuf;
  s += "\n";

  s += sSpacer + "Field Id = ";
  sprintf( tmpBuf, "%ld", m_nFieldId );
  s += tmpBuf;
  s += "\n";

  s += sSpacer + "Field Type = ";
  sprintf( tmpBuf, "%ld", m_nFieldType );
  s += tmpBuf;
  s += "\n";

  s += sSpacer + "New Int = ";
  sprintf( tmpBuf, "%ld", m_nNewInt );
  s += tmpBuf;
  s += "\n";

  s += sSpacer + "Prior Int = ";
  sprintf( tmpBuf, "%ld", m_nPriorInt );
  s += tmpBuf;
  s += "\n";

  s += sSpacer + "Type = ";
  sprintf( tmpBuf, "%ld", m_nType  );
  s += tmpBuf;
  s += "\n";

  s += sSpacer + "Author = ";
  s += m_sAuthor + "\n";

  s += sSpacer + "DateTime Created = ";
  s += m_sDateTime + "\n";

  s += sSpacer + "Field Name = ";
  s += m_sFieldName + "\n";

  s += sSpacer + "New Display Value = ";
  s += m_sNewDisplayValue + "\n";

  s += sSpacer + "Prior Display Value = ";
  s += m_sPriorDisplayValue + "\n\n";

  return s;
}

