// TSChangeHistory.h: interface for the TSChangeHistory class.
//
/////////////////////////////////////////////////////////////////////////

#ifndef TSCHANGEHISTORY_H_
#define TSCHANGEHISTORY_H_

#pragma warning( push, 1 )
#include "DisableSTLWarnings.h"
#include <list>
#pragma warning( pop )

#include "TSRecordRef.h"
#include "TSString.h"


// This class describes the change history for a record.

class AFX_EXT_CLASS TSChangeHistory : public TSRecordRef
{
  // The inherited member, m_sItemName, will be blank for a TSChangeHistory.
  friend class TSServer;
  public:
    // Constructors/destructors/operator =
    TSChangeHistory( TSServer& server, int nItemId = 0  );
    TSChangeHistory( const TSChangeHistory& that );
    virtual ~TSChangeHistory();
    TSChangeHistory& operator = ( const TSChangeHistory& that );

    // Accessor methods:
    const TSString& GetAuthor() const            { return m_sAuthor; }
    int             GetActionType() const        { return m_nActionType; }
    const TSString& GetDateTime() const          { return m_sDateTime; }
    int             GetFieldAttribute() const    { return m_nFieldAttribute; }
    int             GetFieldId() const           { return m_nFieldId; }
    const TSString& GetFieldName() const         { return m_sFieldName; }
    int             GetFieldType() const         { return m_nFieldType; }
    const TSString& GetNewDisplayValue() const   { return m_sNewDisplayValue; }
    int             GetNewInt() const            { return m_nNewInt; }
    const TSString& GetPriorDisplayValue() const { return m_sPriorDisplayValue; }
    int             GetPriorInt() const          { return m_nPriorInt; }
    int             GetType() const              { return m_nType; }

    // For debugging
    TSString StringDump( TSString sIndentation );

  protected:
    // Only intended to be called by member methods of TSServer.
    int Receive( TSSocket* socket );

    int      m_nActionType;	      // Indicates how the record was created (see TS_CHGACTION_ in TSDef.h)
    int      m_nFieldAttribute;	  // The attribute of field being modified (see TS_FLDATTRIB_ in TSDef.h)
    int      m_nFieldId;          // The field id this change record refers to (0 for attachment changes)
    int      m_nFieldType;	      // The type of field being modified (see TS_FLDTYPE_ in TSDef.h)
    int      m_nNewInt;           // Only set when the m_nFieldType is not text, memo or floating-point type
    int      m_nPriorInt;         // Only set when the m_nFieldType is not text, memo or floating-point type
    int      m_nType;             // The raw storage type of the field being modified (see TS_CHGTYPE_ in TSDef.h)
    TSString m_sAuthor;           // The user that made the change
    TSString m_sDateTime;         // The date and time of the change
    TSString m_sFieldName;	      // The name of the field being modified
    TSString m_sNewDisplayValue;  // The new value for the field
    TSString m_sPriorDisplayValue;// The value the field held prior to the change

  private:
    virtual int Read();
    int         ReadById( int nItemId );
    virtual int SetItemId( int nNewItemId );
    virtual int SetTableId( int nNewTableId );

};

typedef std::list< TSChangeHistory* > TSChangeList;

#endif
