#ifndef TS_DEF_H_
#define TS_DEF_H_

/*
 * Make sure BOOL is typedefed.  If your system already
 * defined BOOL to something other than an int, you can
 * remove this.
 */

typedef int BOOL;
#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

/*
 * API Version.  If you upgrade to a newer version of
 * TeamTrack, it is possible, however unlikely that it
 * will be incompatible with the older version of the
 * API and this number won't match the number used in
 * the new version of TeamTrack and your API program
 * will have to be recompiled.  Also, it's worth noting
 * that this number does NOT match the version number
 * of TeamTrack, it's the version number for the API
 * which hopefully won't need to change when a newer
 * version of TeamTrack is installed.
 */

/*  TS_APIVERSION set to 3 on 03-08-2001, 
    build 5013, dbversion 510, object version 509 */
#define TS_APIVERSION 3

/*
 * API Revision.  This minor version number is incremented
 * each time functionality is added or bugs are fixed.
 * Unlike the TS_APIVERSION number, new revisions of the
 * API will continue to be compatible with your version
 * of TeamTrack.
 */

/*  TS_APIREVISION reset to 1 on 1-26-2001, TS_APIVERSION = 2 */
#define TS_APIREVISION 1

/*
 * If we aren't using MFC define AFX_EXT_CLASS to be
 * nothing.  If you get an AFX_EXT_CLASS is redefined
 * and this is the first definition, then you need to
 * make sure "stdafx.h" is included before this file.
 */
#ifndef AFX_EXT_CLASS
#define AFX_EXT_CLASS
#endif

// Unique names/prefixes of existing TeamShare solutions.
// These are keys to TS_SOLUTIONS to obtain the id.
const char* const TS_SOLPREFIX_TTRACK         = "TTT";
const char* const TS_SOLPREFIX_TSUPPORT       = "TTS";
const char* const TS_SOLPREFIX_PROJECTBRIDGE  = "TPB";

// Error status codes for the TeamTrack API
const int TS_OK                               =  1;
const int TS_ERROR                            = -1;
const int TS_MISSING_PARAMETER                = -2;
const int TS_NO_PERMISSION                    = -3;
const int TS_NO_SUCH_FIELD                    = -4;
const int TS_MEMORY_ERROR                     = -5;
const int TS_SOCKET_READ_ERROR                = -6;
const int TS_SOCKET_WRITE_ERROR               = -7;
const int TS_SOCKET_CONNECT_FAILED            = -8;
const int TS_SOCKET_CREATE_FAILED             = -9;
const int TS_INVALID_DATATYPE                 = -10;
const int TS_INVALID_USER                     = -11;
const int TS_NO_RESULTS                       = -12;
const int TS_SERVER_ERROR                     = -13;
const int TS_INVALID_VERSION                  = -14;
const int TS_INVALID_PARAMETERS               = -15;
const int TS_RECORD_LOCKED                    = -16;
const int TS_RECORD_LOCK_BROKEN               = -17;
const int TS_INVALID_FIELDS                   = -18;
const int TS_TRANSITION_INVALID               = -19;
const int TS_ITEM_NOT_FOUND                   = -20;
const int TS_NOT_UPDATEABLE                   = -21;
const int TS_INCORRECT_MODE                   = -22;
const int TS_FILE_NOT_FOUND                   = -23;
const int TS_FILE_SEEK_ERROR                  = -24;
const int TS_FILE_READ_ERROR                  = -25;
const int TS_ADD_TABLE_ERROR                  = -26;
const int TS_INVALID_PREFIX                   = -27;
const int TS_PARAMETER_NOT_UNIQUE             = -28;
const int TS_STRING_TOO_LONG                  = -29;

// Error status codes returned from CAppDb::ValidateUser.
// (set these up so that they work w/in API) -- note that
// a > 0 return will be the user's id
// const int TS_INVALID_USER (defined above)                 
const int TS_NO_IP_ADDRESS                    = -100;
const int TS_LICENSING_VIOLATION              = -101;
const int TS_CONCURRENT_LICENSE_UNAVAILABLE   = -102;

// SQL data type codes for Microsoft ODBC.
#define	  SQL_EMPTY                           0
#define   SQL_CHAR                            1
#define   SQL_INTEGER                         4
#define   SQL_DOUBLE                          8
#define   SQL_VARCHAR                         12
#define   SQL_LONGVARCHAR                     (-1)
#define   SQL_LONGVARCHAR1                    (1000)
#define   SQL_LONGVARCHAR2                    (1001)

const int TS_SCHEMATYPE_DBCOL                 = 1;
const int TS_SCHEMATYPE_DBXCOL                = 2;
const int TS_SCHEMATYPE_NONDB                 = 3;
const int TS_SCHEMATYPE_LIST                  = 4;
const int TS_SCHEMATYPE_TREELIST              = 5;
const int TS_SCHEMATYPE_NONDBLOCAL            = 6;
const int TS_SCHEMATYPE_UNBOUNDDBCOL          = 7;

const int TS_DATATYPE_INTEGER                 = 1;
const int TS_DATATYPE_DOUBLE                  = 2;
const int TS_DATATYPE_BOOL                    = 3;
const int TS_DATATYPE_STRING                  = 4;
const int TS_DATATYPE_RECORDLIST              = 5;
const int TS_DATATYPE_INTLIST                 = 6;
const int TS_DATATYPE_UNKNOWN                 = 7;

// Constants for GetDbInfo()
const int TS_DBINFO_VERSION                   = 1;
const int TS_DBINFO_EXITURL                   = 2;
const int TS_DBINFO_EXPIRATIONDATE            = 3;
const int TS_DBINFO_ROOTPROJECTID             = 4;
const int TS_DBINFO_ROOTPROJECTNAME           = 5;
const int TS_DBINFO_DBMSNAME                  = 6;
const int TS_DBINFO_DBMSVER                   = 7;
const int TS_DBINFO_ROOTFOLDERID              = 8;
const int TS_DBINFO_OBJECTVERSION             = 9;
const int TS_DBINFO_VARCHARLENGTH             = 10;
const int TS_DBINFO_LONGVARCHARLENGTH         = 11;
const int TS_DBINFO_ALLOWANONYMOUS            = 12;

// Table Id Values (used in Tables table)
// Note: Deprecated definitions are located at the end of this file.
// Their constant values are: 1, 36, 39, 40, and 43.
const int TS_TBLID_NONE                       = -1; // default
const int TS_TBLID_CHANGES                    = 2;
const int TS_TBLID_FIELDS                     = 3;
const int TS_TBLID_GROUPS                     = 4;
const int TS_TBLID_LICENSES                   = 5;
const int TS_TBLID_MEMBERS                    = 6;
const int TS_TBLID_PRIVILEGES                 = 7;
const int TS_TBLID_PROJECTS                   = 8;
const int TS_TBLID_PROJECTSELECTIONS          = 9;
const int TS_TBLID_PROPERTIES                 = 10;
const int TS_TBLID_REPORTS                    = 11;
const int TS_TBLID_SELECTIONS                 = 12;
const int TS_TBLID_STATES                     = 13;
const int TS_TBLID_TRANSISSUETYPES            = 14;
const int TS_TBLID_SYSTEMINFO                 = 15;
const int TS_TBLID_TRANSITIONS                = 16;
const int TS_TBLID_USERS                      = 17;
const int TS_TBLID_TABLES                     = 18;
const int TS_TBLID_ATTACHMENTS                = 19;
const int TS_TBLID_FOLDERS                    = 20;
const int TS_TBLID_FOLDERITEMS                = 21;
const int TS_TBLID_FOLDERCOLUMNS              = 22;
const int TS_TBLID_VCACTIONS                  = 23;
const int TS_TBLID_PROJECTTRANSITIONS         = 24;
const int TS_TBLID_NOTIFICATIONS              = 25;
const int TS_TBLID_NOTIFICATIONRULES          = 26;
const int TS_TBLID_NOTIFICATIONCONDITIONS     = 27;
const int TS_TBLID_NOTIFICATIONEVENTS         = 28;
const int TS_TBLID_NOTIFICATIONFIELDS         = 29;
const int TS_TBLID_NOTIFICATIONMESSAGES       = 30;
const int TS_TBLID_NOTIFICATIONPERMISSIONS    = 31;
const int TS_TBLID_NOTIFICATIONSUBSCRIPTIONS  = 32;
const int TS_TBLID_MACROS                     = 33;
const int TS_TBLID_WORKFLOWS                  = 34;
const int TS_TBLID_FIELDORDERINGS             = 35;
const int TS_TBLID_COMPANIES                  = 37;
const int TS_TBLID_CONTACTS                   = 38;
const int TS_TBLID_PROBLEMS                   = 41;
const int TS_TBLID_RESOLUTIONS                = 42;
const int TS_TBLID_KEYWORDS                   = 44;
const int TS_TBLID_PRODUCTUSAGES              = 45;
const int TS_TBLID_KEYWORDUSAGES              = 46;
const int TS_TBLID_TRANSTRIGGERS              = 47;
const int TS_TBLID_TRANSTRIGGERSTATES         = 48;
const int TS_TBLID_TRANSTRIGGERTRANSITIONS    = 49;
const int TS_TBLID_ADMINGROUPS                = 50;
const int TS_TBLID_MAILHEADERFIELDS           = 51;
const int TS_TBLID_MAILBOX                    = 52;
const int TS_TBLID_MAILMAPPINGS               = 53;
const int TS_TBLID_SELFREGFIELDS              = 54;
const int TS_TBLID_MSSELECTION                = 55;
const int TS_TBLID_SYSTEMSETTINGS             = 56;
const int TS_TBLID_GWESTATES                  = 57;
const int TS_TBLID_GWETRANSITIONS             = 58;
const int TS_TBLID_GWECOMMENTS                = 59;
const int TS_TBLID_SOLUTIONS                  = 60;
const int TS_TBLID_SUBTASKS                   = 61;
const int TS_TBLID_SECTIONS                   = 62;
const int TS_TBLID_BROWSERS                   = 63;
const int TS_TBLID_RESOURCES                  = 64;
const int TS_TBLID_BLOBS                      = 65;
const int TS_TBLID_RECORDLOCKS                = 66;
const int TS_TBLID_ITEMNOTIFICATIONS          = 67;
const int TS_TBLID_USAGES                     = 68;
const int TS_TBLID_ADMINTABLES                = 69;


// Solution Type Enumeration
const int TS_SOLTYPE_TSS                      = 0;
const int TS_SOLTYPE_USR                      = 1;
const int TS_SOLTYPE_EXT                      = 2;

// Table Type Enumeration
const int TS_TBLTYPE_SYS                      = 0;
const int TS_TBLTYPE_PRI                      = 1;
const int TS_TBLTYPE_AUX                      = 2;
const int TS_TBLTYPE_SYSAUX                   = 3;
const int TS_TBLTYPE_ARCHIVE                  = 4;

// Table Flags bit masks
const int TS_TBLFLG_DELETE                    = 0x00000001;
const int TS_TBLFLG_ARCHIVE                   = 0x00000002;
const int TS_TBLFLG_IMPORT                    = 0x00000004;

// Field Type Constants
// Note: Deprecated definitions are located at the end of this file.
// Their constant values are: 112, 114, 115, 119, 120 and 121.
const int TS_FLDTYPE_NUMERIC                  = 100;
const int TS_FLDTYPE_TEXT                     = 101;
const int TS_FLDTYPE_MEMO                     = 102;
const int TS_FLDTYPE_DATETIME                 = 103;
const int TS_FLDTYPE_SELECTION                = 104;
const int TS_FLDTYPE_BINARY                   = 105;
const int TS_FLDTYPE_STATE                    = 106;
const int TS_FLDTYPE_USER                     = 107;
const int TS_FLDTYPE_PROJECT                  = 108;
const int TS_FLDTYPE_SUMMATION                = 109;
const int TS_FLDTYPE_MULTIPLE_SELECTION       = 110;
const int TS_FLDTYPE_CONTACT                  = 111;
const int TS_FLDTYPE_INCIDENT                 = 113;
const int TS_FLDTYPE_FOLDER                   = 116;
const int TS_FLDTYPE_KEYWORDLIST              = 117;
const int TS_FLDTYPE_PRODUCTLIST              = 118;
const int TS_FLDTYPE_RELATIONAL               = 122;
const int TS_FLDTYPE_SUBRELATIONAL            = 123;
const int TS_FLDTYPE_SYSTEM                   = 124;
const int TS_FLDTYPE_MULTIPLE_RELATIONAL      = 125;

// Field Attribute Constants
const int TS_FLDATTRIB_MEMO                   = 0;
const int TS_FLDATTRIB_FIXEDTEXT              = 1;
const int TS_FLDATTRIB_JOURNAL                = 2;
const int TS_FLDATTRIB_JOURNAL_RO             = 3;
const int TS_FLDATTRIB_INT                    = 0;
const int TS_FLDATTRIB_FLOAT                  = 1;
const int TS_FLDATTRIB_FIXED_PRECISION        = 2;
const int TS_FLDATTRIB_DT_DATEONLY            = 0;
const int TS_FLDATTRIB_DT_DATETIME            = 1;
const int TS_FLDATTRIB_DT_TIMEOFDAY           = 2;
const int TS_FLDATTRIB_DT_ELAPSEDTIME         = 3;
const int TS_FLDATTRIB_BIN_LISTBOX            = 0;
const int TS_FLDATTRIB_BIN_RADIOBUTTON        = 1;
const int TS_FLDATTRIB_BIN_CHECKBOX           = 2;

// Field Mask Constants -- Define generic field masks
const int TS_FLDMASK_USER                     = 0x0001;
const int TS_FLDMASK_ADVANCED                 = 0x0002;
const int TS_FLDMASK_MANAGER                  = 0x0004;
const int TS_FLDMASK_SYSTEM                   = 0x0008;
const int TS_FLDMASK_HIDDEN                   = 0x0010;

// Field Mask Constants -- Define masks for m_chgmask and m_notesmask in TS_USERS table 
const int TS_FLDMASK_NONE                     = 0x0001;
const int TS_FLDMASK_ALL                      = 0x0002;
const int TS_FLDMASK_LAST                     = 0x0004;
const int TS_FLDMASK_NEWEST_FIRST             = 0x0008;

// Field Mask Constants -- Define masks for m_browser
const int TS_FLDMASK_AUTOREFRESH              = 0x000001; // Refresh reports and trees when item is transitioned
const int TS_FLDMASK_FOLDERS                  = 0x000004;
const int TS_FLDMASK_NOJAVA                   = 0x000008;
const int TS_FLDMASK_BROWSER_GENERIC          = 0x000010;
const int TS_FLDMASK_BROWSER_NETSCAPE         = 0x000040;
const int TS_FLDMASK_BROWSER_EXPLORER         = 0x000080;
const int TS_FLDMASK_ATTACHMENTS              = 0x001000;
const int TS_FLDMASK_EMAIL_OWNER              = 0x002000;
const int TS_FLDMASK_EMAIL_STATE              = 0x004000;
const int TS_FLDMASK_EMAIL_CLOSED             = 0x008000;
const int TS_FLDMASK_EMAIL_ALLSUBMIT          = 0x010000;
const int TS_FLDMASK_EMAIL_ALLOWNER           = 0x020000;
const int TS_FLDMASK_EMAIL_ALLSTATE           = 0x040000;
const int TS_FLDMASK_EMAIL_ALLCLOSED          = 0x080000;
const int TS_FLDMASK_EMAIL_LINK               = 0x100000;
//const int TS_FLDMASK_NOTES                    = 0x200000; was used with old notes checkbox  
const int TS_FLDMASK_VCACTIONS                = 0x400000;
const int TS_FLDMASK_SHOWFOLDERITEMS          = 0x800000;

// Mask Constants - Define masks for m_generalmask in TS_USERS table
const int TS_GENMASK_PWSPECIALCHAR            = 0x000001; // indicates if special characters are allowed in the password

// Field Mask Constants -- Define a mask for html types supported
const int TS_FLDMASK_NOTREQUIRED              = 0x0001;
const int TS_FLDMASK_HTML_2                   = 0x0002;
const int TS_FLDMASK_HTML_3                   = 0x0004;
const int TS_FLDMASK_HTML_4                   = 0x0008;

// Max size for memo fields.
const int MAX_MEMO	                          = 65535;

// Field Section Constants
const int TS_FLDSECT_DEFAULT                  = 0;
const int TS_FLDSECT_STANDARD                 = 1;
const int TS_FLDSECT_USER                     = 2;
const int TS_FLDSECT_ADVANCED                 = 3;
const int TS_FLDSECT_MANAGER                  = 4;
const int TS_FLDSECT_SYSTEM                   = 5;
const int TS_FLDSECT_NOTUSED                  = 6;
const int TS_FLDSECT_NOTES                    = 7;
const int TS_FLDSECT_CHANGEHISTORY            = 8;
const int TS_FLDSECT_VERSIONCONTROL           = 9;
const int TS_FLDSECT_ATTACHMENTS              = 10;
const int TS_FLDSECT_DELETED                  = 11;
const int TS_FLDSECT_MAX                      = 12;
const int TS_FLDSECT_STATECHANGEHISTORY       = 13;
const int TS_FLDSECT_ITEMNOTIFICATION         = 14;

const int TS_FLDSECT_HIDDEN                   = 32767;

// Field Property Constants
const int TS_FLDPROP_NONE                     = 0;
const int TS_FLDPROP_NONEDITABLE              = 0x1;
const int TS_FLDPROP_CALC_BEFORE              = 0x2;
const int TS_FLDPROP_CALC_AFTER               = 0x4;

const int TS_FLDREQ_NOTREQUIRED               = 0;
const int TS_FLDREQ_REQUIRED                  = 1;
const int TS_FLDREQ_DEFAULT                   = 2;

const int TS_FLDACTION_DEFAULT                = 0;
const int TS_FLDACTION_SETTO                  = 1;
const int TS_FLDACTION_CLEAR                  = 2;
const int TS_FLDACTION_CALCULATION            = 3;

const int TS_CALC_OP1_CONST                   = 0x1;
const int TS_CALC_OP2_CONST                   = 0x2;
const int TS_CALC_OP1_FLOAT                   = 0x4;
const int TS_CALC_OP2_FLOAT                   = 0x8;

const int TS_FLDOPER_NONE                     = 0;
const int TS_FLDOPER_PLUS                     = 1;
const int TS_FLDOPER_MINUS                    = 2;
const int TS_FLDOPER_MULT                     = 3;
const int TS_FLDOPER_DIVIDE                   = 4;
const int TS_FLDOPER_TRUNC_PLUS               = 5;
const int TS_FLDOPER_TRUNC_MINUS              = 6;
const int TS_FLDOPER_TRUNC_MULT               = 7;
const int TS_FLDOPER_TRUNC_DIVIDE             = 8;
const int TS_FLDOPER_ROUND_PLUS               = 9;
const int TS_FLDOPER_ROUND_MINUS              = 10;
const int TS_FLDOPER_ROUND_MULT               = 11;
const int TS_FLDOPER_ROUND_DIVIDE             = 12;

const char* const TS_FLDOPERNAME_NONE         = "None";
const char* const TS_FLDOPERNAME_PLUS         = "  +  (plus)";
const char* const TS_FLDOPERNAME_MINUS        = "  -  (minus)";
const char* const TS_FLDOPERNAME_MULT         = "    (times)";
const char* const TS_FLDOPERNAME_DIVIDE       = "    (divide by)";
const char* const TS_FLDOPERNAME_TRUNC_PLUS   = "Truncating +";
const char* const TS_FLDOPERNAME_TRUNC_MINUS  = "Truncating -";
const char* const TS_FLDOPERNAME_TRUNC_MULT   = "Truncating ";
const char* const TS_FLDOPERNAME_TRUNC_DIVIDE = "Truncating ";
const char* const TS_FLDOPERNAME_ROUND_PLUS   = "Rounding +";
const char* const TS_FLDOPERNAME_ROUND_MINUS  = "Rounding -";
const char* const TS_FLDOPERNAME_ROUND_MULT   = "Rounding ";
const char* const TS_FLDOPERNAME_ROUND_DIVIDE = "Rounding ";

const int TS_FLDMASS_DISALLOW                 = 0;
const int TS_FLDMASS_ALLOW                    = 1;

const int TS_FLDQUERY_NONE                    = 0x00;
const int TS_FLDQUERY_ALLOWQUERY              = 0x01;
const int TS_FLDQUERY_SHOWGO                  = 0x02;
const int TS_QUERYMASK                        = 0x01;
const int TS_SHOWGOMASK                       = 0x02;

const int TS_FLDOPTION_SELECT_DEFAULT         = 0x00;   // default field selection options
const int TS_FLDOPTION_SELECT_MULTIPLE        = 0x01;   // allow multiple selections if set (otherwise allow only one selection)
const int TS_FLDOPTION_CHECKBOXES             = 0x02;   // show a multi-selection field as checkboxes if set (otherwise use multi-selection list)
const int TS_FLDOPTION_FINDFIELD              = 0x04;   // allow field to be searched during a find
const int TS_FLDOPTION_PREFORMATTED_HTML      = 0x08;   // used to preserve text format on a cut and paste
const int TS_FLDOPTION_STOPWATCH              = 0x10;   // indicates elapsed time field should viewed as a stop watch
const int TS_FLDOPTION_PRECISION_MASK         = 0x0F00; // For fixed-precision numeric fields, bits 8-11 of m_options specify number of
                                                        // digits after decimal to display.
const int TS_FLDOPTION_PASSWORD               = 0x20;   // Fixed length text field only.  Indicates the field is a password field.
const int TS_FLDOPTION_NODELETE               = 0x40;   // This field cannot be deleted once it has been created.
const int TS_FLDOPTION_RADIOBUTTONS           = 0x80;   // show a single-selection field as radio buttons if set
const int TS_FLDOPTION_GROUPING               = 0x1000; // Show thousands separators: e.g. 10,000 vs 10000
const int TS_FLDOPTION_BACKFILL               = 0x2000; // Temporary flag to indicate that new column should be set to default value upon create

// Privilege type enumeration/mask
// Normal user privilege: SYStem, PRoJect, WorKFlow, FoLDer
const int TS_PRIVTYPE_USERSYS                 = 0x00000010;
const int TS_PRIVTYPE_USERPRJ                 = 0x00000011;
const int TS_PRIVTYPE_USERWKF                 = 0x00000012;
const int TS_PRIVTYPE_USERFLD                 = 0x00000013;
const int TS_PRIVTYPE_USERTBL                 = 0x00000014;

// Administrative privilege: SYStem, PRoJect, WorKFlow
const int TS_PRIVTYPE_ADMSYS                  = 0x00000020;
const int TS_PRIVTYPE_ADMPRJ                  = 0x00000021;
const int TS_PRIVTYPE_ADMWKF                  = 0x00000022;

// Flags an invalid privilege record upon upgrade (ASSERTs for DEBUG)
const int TS_PRIVTYPE_UNKNOWN                 = 0x1000000f;

// ((type & TS_PRIVTYPE_SYSMASK) == 0) demotes SYStem privilege type
const int TS_PRIVTYPE_SYSMASK                 = 0x0000000f;

// (type & TS_PRIVTYPE_ADMMASK) denotes ADMin privilege type
const int TS_PRIVTYPE_ADMMASK                 = 0x00000020;

// ((type & TS_PRIVTYPE_SYSMASK) == TS_PRIVTYPE_TBLMASK) denotes TaBLe privilege type
const int TS_PRIVTYPE_TBLMASK                 = 0x00000004;

// Helper macros for determining if a privilege type is a member of a set
#define IsSystemPrivilege( type )   (((type) & TS_PRIVTYPE_SYSMASK) == 0)
#define IsAdminPrivilege( type )    (((type) & TS_PRIVTYPE_ADMMASK) != 0)
#define IsTablePrivilege( type )    (((type) & TS_PRIVTYPE_SYSMASK) == TS_PRIVTYPE_TBLMASK)
  
// Constants for ProjectMask used in GetProjectList
const int TS_PROJMASK_VIEW                    = 0x00000001;
const int TS_PROJMASK_UPDATE                  = 0x00000002;
const int TS_PROJMASK_SUBMIT                  = 0x00000004;
const int TS_PROJMASK_TRANSITION              = 0x00000008;
const int TS_PROJMASK_ALL                     = 0x0000000F;

// Enumeration type for HasRecordPrivilege
enum recPriv_e
{
  TS_RECPRIV_ERROR = 0,
  TS_RECPRIV_SUBMIT,
  TS_RECPRIV_VIEW,
  TS_RECPRIV_UPDATE,
  TS_RECPRIV_TRANSITION,
  TS_RECPRIV_DELETE,
  TS_RECPRIV_NOTEADD,
  TS_RECPRIV_NOTEEDIT,
  TS_RECPRIV_NOTEDELETE,
  TS_RECPRIV_ATTACHMENTADD,
  TS_RECPRIV_ATTACHMENTEDIT,
  TS_RECPRIV_ATTACHMENTDELETE,

  TS_RECPRIV_END  // Use for end
};

// Enumeration ids for all privileges
enum privId_e
{
  TS_PRIV_NONE = 0,

  TS_USRSYSPRIV_EDITPROFILE,
  TS_USRSYSPRIV_LOGONASUSER,
  TS_USRSYSPRIV_REMOTEADMIN,
  TS_USRSYSPRIV_HANDHELD,
  TS_USRSYSPRIV_SOURCEBRIDGE,
  TS_USRSYSPRIV_VIEWFOLDERS,
  TS_USRSYSPRIV_VIEWATTACHMENTS,
  TS_USRSYSPRIV_VIEWNOTES,
  TS_USRSYSPRIV_VIEWPUBLICPROBLEMS,
  TS_USRSYSPRIV_VIEWCONTACTIFYOU,
  TS_USRSYSPRIV_ASSIGNCONTACTLICENSE,
  TS_USRSYSPRIV_EXECSYSTEM,
  TS_USRSYSPRIV_APIACCESS,

  TS_USRFLDPRIV_VIEWFOLDERITEMS,
  TS_USRFLDPRIV_ADDTOFOLDER,
  TS_USRFLDPRIV_REMOVEFROMFOLDER,

  TS_USRPRJPRIV_SUBMITITEMS,
  TS_USRPRJPRIV_OWN,
  TS_USRPRJPRIV_DELETE,
  TS_USRPRJPRIV_VIEWALLITEMS,
  TS_USRPRJPRIV_VIEWIFOWNER,
  TS_USRPRJPRIV_VIEWIFSUBMITTER,
  TS_USRPRJPRIV_UPDATEALL,
  TS_USRPRJPRIV_UPDATEIFOWNER,
  TS_USRPRJPRIV_UPDATEIFSUBMITTER,
  TS_USRPRJPRIV_ALLTRANS,
  TS_USRPRJPRIV_TRANSIFOWNER,
  TS_USRPRJPRIV_TRANSIFSUBMITTER,
  TS_USRPRJPRIV_MASSTRANS,
  TS_USRPRJPRIV_VIEWIFCONTACT,
  TS_USRPRJPRIV_VIEWIFCONTACTCOMPANY,
  TS_USRPRJPRIV_VIEWWORKFLOWS,

  TS_USRPRJPRIV_VIEWUSER,
  TS_USRPRJPRIV_VIEWADVANCED,
  TS_USRPRJPRIV_VIEWMANAGER,
  TS_USRPRJPRIV_VIEWSYSTEM,
  TS_USRPRJPRIV_EDITUSER,
  TS_USRPRJPRIV_EDITADVANCED,
  TS_USRPRJPRIV_EDITMANAGER,
  TS_USRPRJPRIV_EDITSYSTEM,
  TS_USRPRJPRIV_VIEWHIDDEN,
  TS_USRPRJPRIV_VIEWUSERONSUBMIT,
  TS_USRPRJPRIV_VIEWADVANCEDONSUBMIT,
  TS_USRPRJPRIV_VIEWMANAGERONSUBMIT,
  TS_USRPRJPRIV_VIEWSYSTEMONSUBMIT,
  TS_USRPRJPRIV_VIEWUSERONTRANSITION,
  TS_USRPRJPRIV_VIEWADVANCEDONTRANSITION,
  TS_USRPRJPRIV_VIEWMANAGERONTRANSITION,
  TS_USRPRJPRIV_VIEWSYSTEMONTRANSITION,
  TS_USRPRJPRIV_VIEWUSERONUPDATE,
  TS_USRPRJPRIV_VIEWADVANCEDONUPDATE,
  TS_USRPRJPRIV_VIEWMANAGERONUPDATE,
  TS_USRPRJPRIV_VIEWSYSTEMONUPDATE,

  TS_USRPRJPRIV_ADDATTACHANY,
  TS_USRPRJPRIV_ADDATTACHIFOWNER,
  TS_USRPRJPRIV_ADDATTACHIFSUBMITTER,
  TS_USRPRJPRIV_ADDATTACHIFCONTACT,
  TS_USRPRJPRIV_EDITATTACHANY,
  TS_USRPRJPRIV_EDITATTACHIFOWNER,
  TS_USRPRJPRIV_EDITATTACHIFSUBMITTER,
  TS_USRPRJPRIV_EDITATTACHIFAUTHOR,
  TS_USRPRJPRIV_DELATTACHANY,
  TS_USRPRJPRIV_DELATTACHIFOWNER,
  TS_USRPRJPRIV_DELATTACHIFSUBMITTER,
  TS_USRPRJPRIV_DELATTACHIFAUTHOR,

  TS_USRPRJPRIV_ADDNOTEANY,
  TS_USRPRJPRIV_ADDNOTEIFOWNER,
  TS_USRPRJPRIV_ADDNOTEIFSUBMITTER,
  TS_USRPRJPRIV_ADDNOTEIFCONTACT,
  TS_USRPRJPRIV_EDITNOTEANY,
  TS_USRPRJPRIV_EDITNOTEIFOWNER,
  TS_USRPRJPRIV_EDITNOTEIFSUBMITTER,
  TS_USRPRJPRIV_EDITNOTEIFAUTHOR,
  TS_USRPRJPRIV_DELNOTEANY,
  TS_USRPRJPRIV_DELNOTEIFOWNER,
  TS_USRPRJPRIV_DELNOTEIFSUBMITTER,
  TS_USRPRJPRIV_DELNOTEIFAUTHOR,

  TS_USRPRJPRIV_ACCESSPRIVATERPT,
  TS_USRPRJPRIV_CREATEGUESTRPT,
  TS_USRPRJPRIV_CREATEUSERRPT,
  TS_USRPRJPRIV_CREATEMANAGERRPT,
  TS_USRPRJPRIV_EDITGUESTRPT,
  TS_USRPRJPRIV_EDITUSERRPT,
  TS_USRPRJPRIV_EDITMANAGERRPT,
  TS_USRPRJPRIV_EXECGUESTRPT,
  TS_USRPRJPRIV_EXECUSERRPT,
  TS_USRPRJPRIV_EXECMANAGERRPT,
  TS_USRPRJPRIV_DELGUESTRPT,
  TS_USRPRJPRIV_DELUSERRPT,
  TS_USRPRJPRIV_DELMANAGERRPT,

  TS_USRTBLPRIV_SUBMIT,
  TS_USRTBLPRIV_UPDATE,
  TS_USRTBLPRIV_DELETE,
  TS_USRTBLPRIV_VIEW,
  TS_USRTBLPRIV_ACCESSPRIVATERPT,
  TS_USRTBLPRIV_CREATEGUESTRPT,
  TS_USRTBLPRIV_CREATEUSERRPT,
  TS_USRTBLPRIV_CREATEMANAGERRPT,
  TS_USRTBLPRIV_EDITGUESTRPT,
  TS_USRTBLPRIV_EDITUSERRPT,
  TS_USRTBLPRIV_EDITMANAGERRPT,
  TS_USRTBLPRIV_EXECGUESTRPT,
  TS_USRTBLPRIV_EXECUSERRPT,
  TS_USRTBLPRIV_EXECMANAGERRPT,
  TS_USRTBLPRIV_DELGUESTRPT,
  TS_USRTBLPRIV_DELUSERRPT,
  TS_USRTBLPRIV_DELMANAGERRPT,

  // These enums are still defined to provide backward compatibility
  // for the API. They are not associated with a valid privilege
  // definition. Special code in the API handler translates these
  // into valid calls.
  TS_USRSYSPRIV_SUBMITCONTACTS,
  TS_USRSYSPRIV_UPDATECONTACTS,
  TS_USRSYSPRIV_DELETECONTACTS,
  TS_USRSYSPRIV_VIEWCONTACTS,
  TS_USRSYSPRIV_SUBMITCOMPANIES,
  TS_USRSYSPRIV_UPDATECOMPANIES,
  TS_USRSYSPRIV_DELETECOMPANIES,
  TS_USRSYSPRIV_VIEWCOMPANIES,
  TS_USRSYSPRIV_SUBMITMERCHANDISE,
  TS_USRSYSPRIV_UPDATEMERCHANDISE,
  TS_USRSYSPRIV_DELETEMERCHANDISE,
  TS_USRSYSPRIV_VIEWMERCHANDISE,
  TS_USRSYSPRIV_SUBMITPRODUCTS,
  TS_USRSYSPRIV_UPDATEPRODUCTS,
  TS_USRSYSPRIV_DELETEPRODUCTS,
  TS_USRSYSPRIV_VIEWPRODUCTS,
  TS_USRSYSPRIV_SUBMITPROBLEMS,
  TS_USRSYSPRIV_UPDATEPROBLEMS,
  TS_USRSYSPRIV_DELETEPROBLEMS,
  TS_USRSYSPRIV_VIEWPROBLEMS,
  TS_USRSYSPRIV_SUBMITRESOLUTIONS,
  TS_USRSYSPRIV_UPDATERESOLUTIONS,
  TS_USRSYSPRIV_DELETERESOLUTIONS,
  TS_USRSYSPRIV_VIEWRESOLUTIONS,
  TS_USRSYSPRIV_SUBMITSERVICEAGREEMENTS,
  TS_USRSYSPRIV_UPDATESERVICEAGREEMENTS,
  TS_USRSYSPRIV_DELETESERVICEAGREEMENTS,
  TS_USRSYSPRIV_VIEWSERVICEAGREEMENTS,

  TS_ADMSYSPRIV_GLOBALADMIN,
  TS_ADMSYSPRIV_ADDUSER,
  TS_ADMSYSPRIV_EDITUSER,
  TS_ADMSYSPRIV_DELETEUSER,
  TS_ADMSYSPRIV_ADDGROUP,
  TS_ADMSYSPRIV_EDITGROUP,
  TS_ADMSYSPRIV_DELETEGROUP,
  TS_ADMSYSPRIV_SETLOGONASUSER,
  TS_ADMSYSPRIV_SETHANDHELD,
  TS_ADMSYSPRIV_SETSOURCEBRIDGE,
  TS_ADMSYSPRIV_SETAPIACCESS,
  TS_ADMSYSPRIV_ADDFOLDER,
  TS_ADMSYSPRIV_EDITFOLDER,
  TS_ADMSYSPRIV_DELETEFOLDER,
  TS_ADMSYSPRIV_ASSIGNFOLDERPRIVS,
  TS_ADMSYSPRIV_ADDNOTIFICATION,
  TS_ADMSYSPRIV_EDITNOTIFICATION,
  TS_ADMSYSPRIV_DELETENOTIFICATION,
  TS_ADMSYSPRIV_ADDTRIGGER,
  TS_ADMSYSPRIV_EDITTRIGGER,
  TS_ADMSYSPRIV_DELETETRIGGER,
  TS_ADMSYSPRIV_ADDTABLE,
  TS_ADMSYSPRIV_EDITTABLE,
  TS_ADMSYSPRIV_DELETETABLE,
  TS_ADMSYSPRIV_ADDLICENSE,
  TS_ADMSYSPRIV_DELETELICENSE,
  TS_ADMSYSPRIV_IMPORTDB,
  TS_ADMSYSPRIV_STARTSTOPMAILCLIENT,
  TS_ADMSYSPRIV_EDITMAILCLIENT,
  TS_ADMSYSPRIV_STARTSTOPNOTESRV,
  TS_ADMSYSPRIV_EDITNOTESRV,
  TS_ADMSYSPRIV_ALTERDBSETTINGS,
  TS_ADMSYSPRIV_ALTERSERVERSETTINGS,
  TS_ADMSYSPRIV_CREATESCRIPT,
  TS_ADMSYSPRIV_MODIFYSCRIPT,
  TS_ADMSYSPRIV_DELETESCRIPT,
  TS_ADMSYSPRIV_NOTIFICATIONSCRIPT,
  TS_ADMSYSPRIV_SELFREGSCRIPT,

  TS_ADMPRJPRIV_ADDPROJECT,
  TS_ADMPRJPRIV_EDITPROJECT,
  TS_ADMPRJPRIV_DELETEPROJECT,
  TS_ADMPRJPRIV_ASSIGNPROJECTPRIVS,

  TS_ADMWKFPRIV_ADDWORKFLOW,
  TS_ADMWKFPRIV_EDITWORKFLOW,
  TS_ADMWKFPRIV_DELETEWORKFLOW,
  TS_ADMWKFPRIV_ADDFIELD,
  TS_ADMWKFPRIV_EDITFIELD,
  TS_ADMWKFPRIV_DELETEFIELD,
  TS_ADMWKFPRIV_ADDDISSELECTION,
  TS_ADMWKFPRIV_ADDSTATE,
  TS_ADMWKFPRIV_EDITSTATE,
  TS_ADMWKFPRIV_DELETESTATE,
  TS_ADMWKFPRIV_ADDTRANSITION,
  TS_ADMWKFPRIV_EDITTRANSITION,
  TS_ADMWKFPRIV_DELETETRANSITION,
  TS_ADMWKFPRIV_TRANSITIONSCRIPT
};

// Report types
const int TS_RPTTYPE_LISTING                  = 1;
const int TS_RPTTYPE_DISTRIBUTION             = 2;
const int TS_RPTTYPE_TREND                    = 4;
const int TS_RPTTYPE_QUERY_BY_EXAMPLE         = 16;
const int TS_RPTTYPE_QUERY_BY_SQL             = 32;
const int TS_RPTTYPE_DETAILS                  = 64;
const int TS_RPTTYPE_SUMMARY                  = 128;
const int TS_RPTTYPE_MULTIVIEW                = 256;
const int TS_RPTTYPE_CHANGEHISTORY            = 512;
const int TS_RPTTYPE_DELETEDITEMS             = 1024;
const int TS_RPTTYPE_MASSTRANSITION           = 2048;
const int TS_RPTTYPE_STATECHANGE              = 4096;
const int TS_RPTTYPE_SYSTEM                   = 8192;

// Date Attributes
const int TS_DATEATTRIB_DATEONLY              = 0;
const int TS_DATEATTRIB_DATETIME              = 1;
const int TS_DATEATTRIB_TIMEONLY              = 2;
const int TS_DATEATTRIB_ELAPSED               = 3;

// Change History Constants
const int TS_CHGACTION_SUBMIT                 = 0;
const int TS_CHGACTION_UPDATE                 = 1;
const int TS_CHGACTION_DELETE                 = 2;
const int TS_CHGACTION_ATTACHMENT_ADD         = 3;
const int TS_CHGACTION_ATTACHMENT_UPDATE      = 4;
const int TS_CHGACTION_ATTACHMENT_DELETE      = 5;
const int TS_CHGACTION_VC_UPDATE              = 7;

const int TS_CHGTYPE_INT                      = 0;
const int TS_CHGTYPE_REAL                     = 1;
const int TS_CHGTYPE_CHAR                     = 2;

// Notes Constants
const int TS_NACTION_SUBMIT                 = 0;
const int TS_NACTION_UPDATE                 = 1;
const int TS_NACTION_DELETE                 = 2;
const int TS_NACTION_ATTACHMENT_ADD         = 3;
const int TS_NACTION_ATTACHMENT_UPDATE      = 4;
const int TS_NACTION_ATTACHMENT_DELETE      = 5;

const int TS_NTYPE_INT                      = 0;
const int TS_NTYPE_REAL                     = 1;
const int TS_NTYPE_CHAR                     = 2;

// Special DateTime Values
const int TS_NOW_DATETIME                     = -10;
const int TS_STARTOF_TODAY                    = -11;
const int TS_ENDOF_TODAY                      = -12;
const int TS_STARTOF_TOMORROW                 = -13;
const int TS_ENDOF_TOMORROW                   = -14;
const int TS_STARTOF_YESTERDAY                = -15;
const int TS_ENDOF_YESTERDAY                  = -16;
const int TS_STARTOF_THISMONTH                = -17;
const int TS_ENDOF_THISMONTH                  = -18;
const int TS_STARTOF_LASTMONTH                = -19;
const int TS_ENDOF_LASTMONTH                  = -20;
const int TS_STARTOF_NEXTMONTH                = -21;
const int TS_ENDOF_NEXTMONTH                  = -22;
const int TS_STARTOF_THISYEAR                 = -23;
const int TS_ENDOF_THISYEAR                   = -24;
const int TS_STARTOF_LASTYEAR                 = -25;
const int TS_ENDOF_LASTYEAR                   = -26;
const int TS_STARTOF_NEXTYEAR                 = -27;
const int TS_ENDOF_NEXTYEAR                   = -28;
const int TS_STARTOF_THISWEEK                 = -29;
const int TS_ENDOF_THISWEEK                   = -30;
const int TS_STARTOF_NEXTWEEK                 = -31;
const int TS_ENDOF_NEXTWEEK                   = -32;
const int TS_STARTOF_LASTWEEK                 = -33;
const int TS_ENDOF_LASTWEEK                   = -34;

const int TS_SECONDS_PER_HOUR                 = 3600;
const int TS_SECONDS_PER_DAY                  = 86400;
const int TS_SECONDS_PER_WEEK                 = TS_SECONDS_PER_DAY * 7;

// Reserve special DateTime Values from the range -1000 to -7000
// plus -400 maps to -1600, plus 1000 maps to -3000.
const int TS_DATETIME_BASE_PLUS               = -2000;

// VC Action Constants
const int TS_VCACTION_NONE                    = 0;
const int TS_VCACTION_CHECKOUT                = 1;
const int TS_VCACTION_CHECKIN                 = 2;
const int TS_VCACTION_UNDOCHECKOUT            = 3;

// Constants for Transition types
const int TS_TRANSITION_REGULAR               = 0x00000000;
const int TS_TRANSITION_COPY                  = 0x00000001;
const int TS_TRANSITION_POST                  = 0x00000002;
const int TS_TRANSITION_SUBMITPROBLEM         = 0x00000004;
const int TS_TRANSITION_MOBILE                = 0x00000008;
const int TS_TRANSITION_SUBTASK               = 0x00000010;
const int TS_TRANSITION_UPDATE                = 0x00000020;
const int TS_TRANSITION_DELETE                = 0x00000040;

// Constants to determine how a folder or project should be moved.
const int TS_CHILD                            = 0;
const int TS_PRIOR_SIBLING                    = 1;
const int TS_NEXT_SIBLING                     = 2;

// Constants for date formats used in user preferences
const int TS_DATE_FORMAT_MM_DD_YYYY           = 1;
const int TS_DATE_FORMAT_DD_MM_YYYY           = 2;

// Constants for Item Lookup Results
const int TS_MANAGE_INACTIVE_ITEMS            = 1; 
const int TS_MANAGE_ACTIVE_ITEMS              = 2; 
const int TS_MANAGE_ALL_ITEMS                 = 3;

// Constants for Password Privilege
const int TS_PASSWORD_EXPIRES                 =  0;
const int TS_PASSWORD_CANNOTCHANGE            = -1;
const int TS_PASSWORD_USESYSTEMSETTINGS       = -2; //Default 
const int TS_PASSWORD_DOESNOTEXPIRE           = -3;

// Constants for Password Minimum Length
const int TS_PASSWORD_NOMINLENGTH             = -1; //Default
const int TS_PASSWORD_MINLENGTH               =  0;

// Constants for Password Special Characters
const int TS_PASSWORD_REQUIRESPCHAR           =  1;  
const int TS_PASSWORD_NOSPECIALCHAR           =  0; //Default

// Constants  for transition trigger types
const int TS_TRANS_FLG_TRIGGER                = 0x00000001;
const int TS_TRANS_FLG_TRIGGER_SRC            = 0x00000002;
const int TS_TRANS_FLG_TRIGGER_DEST           = 0x00000004;
const int TS_TRANS_FLG_QUICK_TRANSITION       = 0x00000008;
const int TS_TRANS_FLG_SHOW_NEWNOTE           = 0x00000010;
const int TS_TRANS_FLG_REQUIRE_NEWNOTE        = 0x00000020;
const int TS_TRANS_FLG_ATTACH_URL             = 0x00000100;
const int TS_TRANS_FLG_ATTACH_FILE            = 0x00000200;
const int TS_TRANS_FLG_ATTACH_ITEM            = 0x00000400;
const int TS_TRANS_FLG_ATTACH_NOTE            = 0x00000800;
const int TS_TRANS_FLG_ATTACH_ANY             = 0x00001000;
const int TS_TRANS_FLG_ATTACH_ALL             = 0x00001f00; // TS_TRANS_FLG_ATTACH_NOTE | TS_TRANS_FLG_ATTACH_URL | TS_TRANS_FLG_ATTACH_FILE | TS_TRANS_FLG_ATTACH_ITEM
const int TS_TRANS_FLG_LINK_SRC               = 0x00010000;
const int TS_TRANS_FLG_LINK_DEST              = 0x00020000;
const int TS_TRANS_FLG_LINK_TWOWAY            = 0x00030000; // TS_TRANS_FLG_LINK_SRC | TS_TRANS_FLG_LINK_DEST

// Constants for built in reports
const int TS_QUERY_UNKNOWN                    = -1;
const int TS_QUERY_ALL                        =  1;
const int TS_QUERY_ALLACTIVE                  =  2;
const int TS_QUERY_ALLINACTIVE                =  3;
const int TS_QUERY_FOLDER                     =  4;
const int TS_QUERY_MYALL                      =  5;
const int TS_QUERY_MYACTIVE                   =  6;
const int TS_QUERY_MYINACTIVE                 =  7;
const int TS_QUERY_UNASSIGNED                 =  8;
const int TS_QUERY_UNASSIGNEDACTIVE           =  9;
const int TS_QUERY_UNASSIGNEDINACTIVE         = 10;
const int TS_QUERY_SUBMITALL                  = 11;
const int TS_QUERY_SUBMITACTIVE               = 12;
const int TS_QUERY_SUBMITINACTIVE             = 13;
const int TS_QUERY_MASSTRANSITION             = 14;
const int TS_QUERY_KEYWORDS                   = 16; // NOT a home page built-in
const int TS_QUERY_SEARCHID                   = 17; // NOT a home page built-in
const int TS_QUERY_MAIL                       = 18;
const int TS_QUERY_CONTACTALL                 = 19;
const int TS_QUERY_CONTACTACTIVE              = 20;
const int TS_QUERY_CONTACTINACTIVE            = 21;
const int TS_QUERY_DRILLDOWN                  = 22; // NOT a home page built-in
const int TS_QUERY_DRILLDOWNCHANGES           = 23; // NOT a home page built-in
const int TS_QUERY_GROUP_MEMBERSHIP           = 24;
const int TS_QUERY_WORKFLOW_FIELDS            = 25;
const int TS_QUERY_PROJECT_FIELDS             = 26;
const int TS_QUERY_PRIVILEGES                 = 27;
const int TS_QUERY_USERS                      = 28;
const int TS_QUERY_LOOKUPACTION               = 29; // NOT a home page built-in

// Constants for Reports options
const int TS_TREND_PLOTTOTAL                  = 0x00000001;
const int TS_TREND_PLOTSUBMIT                 = 0x00000002;
const int TS_TREND_DIST_SHOWZERO              = 0x00000004;

// Blank Values
const int TS_BLANK_BINARY                     = 0;
const int TS_BLANK_COMPANY                    = 0;
const int TS_BLANK_CONTACT                    = 0;
const int TS_BLANK_DATETIME                   = -2;
const int TS_BLANK_FOLDER                     = 0;
const int TS_BLANK_INCIDENT                   = 0;
const int TS_BLANK_INT                        = (0x7fffffff);
#define   TS_BLANK_MULTISELECT                  ","
const int TS_BLANK_PRODUCT                    = 0;
const int TS_BLANK_PROJECT                    = 0;
const double TS_BLANK_REAL                    = ((double) 0xffffffff);
const int TS_BLANK_SELECT                     = 0;
const int TS_BLANK_SERVICEAGREEMENT           = 0;
const int TS_BLANK_STATE                      = 0;
#define   TS_BLANK_TEXT                         ""
const int TS_BLANK_USER                       = 0;
const int TS_BLANK_PROBLEM                    = 0;
const int TS_BLANK_RESOLUTION                 = 0;
const int TS_BLANK_MERCHANDISE                = 0;
#define   TS_BLANK_RELATIONAL                   ",,"

// Empty Values (For Query By Example Reports)
const int TS_EMPTY_BINARY                     = -2;
const int TS_EMPTY_COMPANY                    = -1;
const int TS_EMPTY_CONTACT                    = -1;
const int TS_EMPTY_DATETIME                   = -3;
const int TS_EMPTY_FOLDER                     = -1;
const int TS_EMPTY_INCIDENT                   = -1;
const int TS_EMPTY_INT                        = (0x7ffffffe);
#define   TS_EMPTY_MULTISELECT                  ","
const int TS_EMPTY_PRODUCT                    = -1;
const int TS_EMPTY_PROJECT                    = -1;
const double TS_EMPTY_REAL                    = ((double) 0xfffffffe);
const int TS_EMPTY_SELECT                     = -2;
const int TS_EMPTY_SERVICEAGREEMENT           = -1;
const int TS_EMPTY_STATE                      = -1;
#define   TS_EMPTY_TEXT                         ""
const int TS_EMPTY_USER                       = -1;
const int TS_EMPTY_PROBLEM                    = -1;
const int TS_EMPTY_RESOLUTION                 = -1;
const int TS_EMPTY_MERCHANDISE                = -1;
#define   TS_EMPTY_RELATIONAL                   ""

// Auto Values
const int TS_AUTO_BINARY                      = -1;
const int TS_AUTO_COMPANY                     = -2;
const int TS_AUTO_CONTACT                     = -2;
const int TS_AUTO_DATETIME                    = -1;
const int TS_AUTO_FOLDER                      = -2;
const int TS_AUTO_INCIDENT                    = -2;
const int TS_AUTO_INT                         = 0x7ffffffd;
const int TS_AUTO_PRODUCT                     = -2;
const int TS_AUTO_PROJECT                     = -2;
const double TS_AUTO_REAL                     = ((double) 0xfffffffd);
const int TS_AUTO_SELECT                      = -1;
const int TS_AUTO_SERVICEAGREEMENT            = -2;
const int TS_AUTO_STATE                       = -2;
const int TS_AUTO_USER                        = -2;
const int TS_AUTO_PROBLEM                     = -2;
const int TS_AUTO_RESOLUTION                  = -2;
const int TS_AUTO_MERCHANDISE                 = -2;

// other random values
const int TS_TREND_START_DATE_FIELDID         = -128;
const int TS_TREND_END_DATE_FIELDID           = -256;

// Attachment Attributes
const int TS_ATTACHATTRIB_FILE                = 0x0010;
const int TS_ATTACHATTRIB_URL                 = 0x0020;
const int TS_ATTACHATTRIB_ITEM                = 0x0040;
const int TS_ATTACHATTRIB_NOTE                = 0x0080;
const int TS_ATTACHATTRIB_SHOWIMAGE           = 0x1000;

// System Field Constants
const int TS_SYSFLD_ID                        = 1;
const int TS_SYSFLD_PARENTID                  = 2;
const int TS_SYSFLD_PROJECTID                 = 3;
const int TS_SYSFLD_TITLE                     = 4;
const int TS_SYSFLD_DESC                      = 5;
const int TS_SYSFLD_STATE                     = 6;
const int TS_SYSFLD_DT_CREATE                 = 7;
const int TS_SYSFLD_DT_LASTMODIFIED           = 8;
const int TS_SYSFLD_DT_LASTSTATECHANGE        = 9;
const int TS_SYSFLD_DT_CLOSE                  = 10;
const int TS_SYSFLD_DT_REOPEN                 = 11;
const int TS_SYSFLD_USER_OWNER                = 12;
const int TS_SYSFLD_USER_SUBMITTER            = 13;
const int TS_SYSFLD_USER_LASTMODIFIER         = 14;
const int TS_SYSFLD_USER_LASTSTATECHANGER     = 15;
const int TS_SYSFLD_TEXT_DISPLAYID            = 16;
const int TS_SYSFLD_SEL_CASETYPE              = 17;
const int TS_SYSFLD_BIN_ACTIVEINACTIVE        = 18;
const int TS_SYSFLD_FOLDERID                  = 19;
const int TS_SYSFLD_LASTINCIDENT              = 20;

// System Field Constants for Incidents
const int TS_SYSFLD_COMPANY                   = 100;
const int TS_SYSFLD_CONTACT                   = 101;
const int TS_SYSFLD_MERCHANDISE               = 102;
const int TS_SYSFLD_SERVICEAGREEMENT          = 103;
const int TS_SYSFLD_PROBLEM                   = 104;
const int TS_SYSFLD_RESOLUTION                = 105;
const int TS_SYSFLD_RESOLUTIONTITLE           = 106;
const int TS_SYSFLD_RESOLUTIONDESC            = 107;

// System Field Constants for Contacts
const int TS_SYSFLD_CONTACT_COMPID            = 200;
const int TS_SYSFLD_CONTACT_FNAME             = 201;
const int TS_SYSFLD_CONTACT_MNAME             = 202;
const int TS_SYSFLD_CONTACT_LNAME             = 203;
const int TS_SYSFLD_CONTACT_USERID            = 204;
const int TS_SYSFLD_CONTACT_PHONE             = 205;
const int TS_SYSFLD_CONTACT_EMAIL             = 206;

// System Field Constants for Companies
const int TS_SYSFLD_COMPANY_NUMBER            = 300;

// System Field Constants for Service Agreements
const int TS_SYSFLD_DT_EXPIRATION             = 400;

// System Field Constants for Problem/Resolutions
const int TS_SYSFLD_VISIBILITY                = 500;
const int TS_SYSFLD_PRODUCTS                  = 501;

// Email Header Field Type Information ( CMailHeaderField m_types )
#define TS_MAILHDR_TEXT       0x00000001
#define TS_MAILHDR_DATE       0x00000002
#define TS_MAILHDR_EMAIL      0x00000004
#define TS_MAILHDR_IPADDRESS  0x00000008
#define TS_MAILHDR_NAME       0x00000010
#define TS_MAILHDR_GROUPNAME  0x00000020 

// Self-Registration definitions
const int TS_SELFREG_MANUAL                   = 0;
const int TS_SELFREG_AUTOMATIC                = 1;
#define   TS_SELFREG_DEFAULT_TEMPLATE           "extregconfirm.txt" // default email template.

// Password-Request definitions
#define   TS_PASSREQUEST_DEFAULT_TEMPLATE       "passrequest.txt" // default email template.

// Database resource types (for stuff stored in TS_RESOURCES)
const int TS_RESTYPE_TEMPLATE               = 1;
const int TS_RESTYPE_STYLE                  = 2;
const int TS_RESTYPE_IMAGE                  = 3;
const int TS_RESTYPE_ATTACHMENT             = 4;
const int TS_RESTYPE_JAVA                   = 5;
const int TS_RESTYPE_HELP                   = 6;
const int TS_RESTYPE_NOTIFICATION_TEMPLATE  = 7;
const int TS_RESTYPE_MAIL_CLIENT_TEMPLATE   = 8;
const int TS_RESTYPE_SELF_REG_TEMPLATE      = 9;

// Bit mask for API describing the sections
const int TS_SECTMASK_STANDARD                  = 0x0001; // Standard Fields
const int TS_SECTMASK_USER                      = 0x0002; // User Fields
const int TS_SECTMASK_ADVANCED                  = 0x0004; // Advanced Fields
const int TS_SECTMASK_MANAGER                   = 0x0008; // Manager Fields
const int TS_SECTMASK_SYSTEM                    = 0x0010; // System Fields
const int TS_SECTMASK_NOTES                     = 0x0020; // Notes
const int TS_SECTMASK_FILES                     = 0x0040; // File Attachments
const int TS_SECTMASK_URLS                      = 0x0080; // URL Attachments
const int TS_SECTMASK_LINKS                     = 0x0100; // Item Links 
const int TS_SECTMASK_CHANGES                   = 0x0200; // Change History
const int TS_SECTMASK_NOTE_CONTENTS             = 0x0400; // Include contents of notes with notes
const int TS_SECTMASK_FILE_CONTENTS             = 0x0800; // Include contents of files with files
const int TS_SECTMASK_ALL_EXCEPT_FILE_CONTENTS  = 0x07ff; // All sections except the file contents

// Bit mask for API two-way or one-way link and trigger properties.
const int TS_STORE_ACTION_TWOWAYLINK    = 0x0100;
const int TS_STORE_ACTION_SOURCETRIGGER = 0x0200;
const int TS_STORE_ACTION_DESTTRIGGER   = 0x0400;

// Db replication constants - used to determine what method of
// replication is being used
const long TS_DB_REPLICATOR_NONE               = 0;
const long TS_DB_REPLICATOR_TEAMTRACK          = 1;
const long TS_DB_REPLICATOR_PEERDIRECT         = 2;

// Notification Object - Basic Object strings
#define TSN_STR_BLANK               ""

// Notification Object - Object Strings
#define TSN_STR_ANYITEM             "Any %s"
#define TSN_STR_TRANSITION          "Current Transition"
#define TSN_STR_ATTACHMENT          "Attachment"

// Notification Object - Comparitor strings
#define TSN_STR_CONTAINS            "Contains"
#define TSN_STR_ISEQUAL             "Is Equal To"
#define TSN_STR_CHANGESTO           "Changes To"
#define TSN_STR_CHANGESFROM         "Changes From"
#define TSN_STR_ISGREATER           "Is Greater Than"
#define TSN_STR_ISLESS              "Is Less Than"
#define TSN_STR_ISLESS_EQUAL        "Is Less or Equal"
#define TSN_STR_ISGREATER_EQUAL     "Is Greater or Equal"
#define TSN_STR_CHANGES             "Changes"
#define TSN_STR_IS                  "Is"
#define TSN_STR_HASSELECTION        "Has Selection"

// Notification Object - Value Strings
#define TSN_STR_USER                "<Current User>"
#define TSN_STR_USER_NONE           "<None>"
#define TSN_STR_SUBMITTER           "Submitter"
#define TSN_STR_OWNER               "Owner"
#define TSN_STR_PREVOWNER           "Previous Owner"
#define TSN_STR_PREVMANAGER         "Previous Manager"
#define TSN_STR_PREVSTATECHANGER    "Previous State Changer"
#define TSN_STR_MANAGER             "Manager"
#define TSN_STR_STATECHANGER        "State Changer"
#define TSN_STR_STATE               "State"
#define TSN_STR_CLOSED              "Closed"
#define TSN_STR_OPENED              "Opened"
#define TSN_STR_SUBMITTED           "Submitted"
#define TSN_STR_CHANGED             "Changed"
#define TSN_STR_ADDED               "Added"
#define TSN_STR_DELETED             "Deleted"

// Notification Object - Operator strings
#define TSN_STR_AND                 "And"
#define TSN_STR_ANDNOT              "And Not"
#define TSN_STR_OR                  "Or"
#define TSN_STR_ORNOT               "Or Not"
#define TSN_STR_NOT                 "Not"

// Notification Object - Date strings
#define TSN_STR_NOW                 "Now"
#define TSN_STR_STARTOFTODAY        "Startof_today"
#define TSN_STR_ENDOFTODAY          "Endof_today"
#define TSN_STR_STARTOFTOMORROW     "Startof_tomorrow"
#define TSN_STR_ENDOFTOMORROW       "Endof_tomorrow"
#define TSN_STR_STARTOFYESTERDAY    "Startof_yesterday"
#define TSN_STR_ENDOFYESTERDAY      "Endof_yesterday"
#define TSN_STR_STARTOFTHISWEEK     "Startof_thisweek"
#define TSN_STR_ENDOFTHISWEEK       "Endof_thisweek"
#define TSN_STR_STARTOFLASTWEEK     "Startof_lastweek"
#define TSN_STR_ENDOFLASTWEEK       "Endof_lastweek"
#define TSN_STR_STARTOFNEXTWEEK     "Startof_nextweek"
#define TSN_STR_ENDOFNEXTWEEK       "Endof_nextweek"
#define TSN_STR_STARTOFTHISMONTH    "Startof_thismonth"
#define TSN_STR_ENDOFTHISMONTH      "Endof_thismonth"
#define TSN_STR_STARTOFLASTMONTH    "Startof_lastmonth"
#define TSN_STR_ENDOFLASTMONTH      "Endof_lastmonth"
#define TSN_STR_STARTOFNEXTMONTH    "Startof_nextmonth"
#define TSN_STR_ENDOFNEXTMONTH      "Endof_nextmonth"
#define TSN_STR_STARTOFTHISYEAR     "Startof_thisyear"
#define TSN_STR_ENDOFTHISYEAR       "Endof_thisyear"
#define TSN_STR_STARTOFLASTYEAR     "Startof_lastyear"
#define TSN_STR_ENDOFLASTYEAR       "Endof_lastyear"
#define TSN_STR_STARTOFNEXTYEAR     "Startof_nextyear"
#define TSN_STR_ENDOFNEXTYEAR       "Endof_nextyear"
#define TSN_STR_DATETIMEBASEPLUS    "Plus"

// Notification Object - Basic objects
#define TSN_TYPE_NONE               0x00000000
#define TSN_TYPE_BLANK              0x00000001

// Notification Object - Objects
#define TSN_TYPE_ANYITEM            0x00000010
#define TSN_TYPE_TRANSITION         0x00000011
#define TSN_TYPE_ANYINCIDENT        0x00000012
#define TSN_TYPE_ATTACHMENT         0x00000013

// Notification Object - Comparitors
#define TSN_TYPE_CONTAINS           0x00000020
#define TSN_TYPE_ISEQUAL            0x00000022
#define TSN_TYPE_CHANGESTO          0x00000024
#define TSN_TYPE_CHANGESFROM        0x00000025
#define TSN_TYPE_ISGREATER          0x00000026
#define TSN_TYPE_ISLESS             0x00000027
#define TSN_TYPE_CHANGES            0x00000028
#define TSN_TYPE_IS                 0x00000029
#define TSN_TYPE_ISLESS_EQUAL       0x0000002A
#define TSN_TYPE_ISGREATER_EQUAL    0x0000002B
#define TSN_TYPE_HASSELECTION       0x0000002C

// Notification Object - Values
#define TSN_TYPE_CLOSED             0x00000040
#define TSN_TYPE_OPENED             0x00000041
#define TSN_TYPE_STATE              0x00000042
#define TSN_TYPE_SUBMITTED          0x00000043
#define TSN_TYPE_ADDED              0x00000044
#define TSN_TYPE_DELETED            0x00000045

// Notification Object - Users
#define TSN_TYPE_USER               0x00000050
#define TSN_TYPE_OWNER              0x00000051
#define TSN_TYPE_MANAGER            0x00000052
#define TSN_TYPE_SUBMITTER          0x00000053
#define TSN_TYPE_STATECHANGER       0x00000054
#define TSN_TYPE_PREVOWNER          0x00000055
#define TSN_TYPE_PREVMANAGER        0x00000056
#define TSN_TYPE_PREVSTATECHANGER   0x00000057
#define TSN_TYPE_USERNONE           0x00000058

// Notification Object - Fields
#define TSN_TYPE_FIELD              0x00000060
#define TSN_TYPE_SELECTION          0x00000061
#define TSN_TYPE_ISSUEID            0x00000062
#define TSN_TYPE_CASETYPE           0x00000063
#define TSN_TYPE_BINARY             0x00000064
#define TSN_TYPE_PROJECT            0x00000065
#define TSN_TYPE_TEXT               0x00000066
#define TSN_TYPE_DATE               0x00000067
#define TSN_TYPE_ELAPSED_TIME       0x00000068
#define TSN_TYPE_FOLDER             0x00000069

// Notification Object - Operators
#define TSN_TYPE_AND                0x000000A0
#define TSN_TYPE_OR                 0x000000A1
#define TSN_TYPE_ANDNOT             0x000000A2
#define TSN_TYPE_ORNOT              0x000000A3
#define TSN_TYPE_NOT                0x000000A4

// Notification Object - Open Parenthesis types
#define TSN_TYPE_OPEN_PAREN_0       0x000000B0
#define TSN_TYPE_OPEN_PAREN_1       0x000000B1
#define TSN_TYPE_OPEN_PAREN_2       0x000000B2
#define TSN_TYPE_OPEN_PAREN_3       0x000000B3
#define TSN_TYPE_OPEN_PAREN_4       0x000000B4
#define TSN_TYPE_OPEN_PAREN_5       0x000000B5

// Notification Object - Close Parenthesis types
#define TSN_TYPE_CLOSE_PAREN_0      0x000000C0
#define TSN_TYPE_CLOSE_PAREN_1      0x000000C1
#define TSN_TYPE_CLOSE_PAREN_2      0x000000C2
#define TSN_TYPE_CLOSE_PAREN_3      0x000000C3
#define TSN_TYPE_CLOSE_PAREN_4      0x000000C4
#define TSN_TYPE_CLOSE_PAREN_5      0x000000C5

// Notification Object - Operations
#define TSN_OPS_NONE                0x00000000
#define TSN_OPS_PROJECT             0x00000001
#define TSN_OPS_STATE               0x00000002
#define TSN_OPS_STATE_BASE          0x00000004 // State ops at base workflow level are different.
#define TSN_OPS_USER                0x00000008
#define TSN_OPS_FIELD               0x00000010
#define TSN_OPS_CASETYPE            0x00000020
#define TSN_OPS_DATE                0x00000040
#define TSN_OPS_SELECTION           0x00000080
#define TSN_OPS_BINARY              0x00000100
#define TSN_OPS_TEXT                0x00000400

#define TSN_OPS_SUBMITTED           0x00004000
#define TSN_OPS_CHANGED             0x00008000
#define TSN_OPS_ELAPSED_TIME        0x00010000
#define TSN_OPS_ITEMCHANGES         0x00020000
#define TSN_OPS_ITEMIS              0x00040000
#define TSN_OPS_ANYITEM             0x00080000
#define TSN_OPS_NUMERIC             0x00100000
#define TSN_OPS_MULTISELECTION      0x00200000
#define TSN_OPS_ATTACHMENT          0x00400000
#define TSN_OPS_FOLDER              0x00800000

#define TSN_OPS_ALLITEMS            ( TSN_OPS_ITEMCHANGES|TSN_OPS_ITEMIS )
#define TSN_OPS_ALL                 0xFFFFFFFF













//************************************************************************************************
//
//
//   The remaining definitions are obsolete and not used by TeamTrack.
//   They remain defined so that old API calls that use them still
//   compile (backward compatible). New API programs should use the
//   constants defined above.
//
//
//************************************************************************************************

// Deprecated permission masks
const int TS_PERMMASK_NORMAL                  = 1;
const int TS_PERMMASK_FOLDERS                 = 1;
const int TS_PERMMASK_REPORTS                 = 2;
const int TS_PERMMASK_ATTACH                  = 3;
const int TS_PERMMASK_NOTES                   = 3;
const int TS_PERMMASK_SECTIONS                = 4;
const int TS_PERMMASK_SUPPORT                 = 5;
const int TS_PERMMASK_ADMSYS                  = 1;
const int TS_PERMMASK_ADMSYSEX                = 2;
const int TS_PERMMASK_ADMPRJ                  = 1;
const int TS_PERMMASK_ADMWKF                  = 1;

// Deprecated definitions maintained for backward compatibility
const privId_e TS_PRIV_CREATENEWCASES              = TS_USRPRJPRIV_SUBMITITEMS;
const privId_e TS_PRIV_VIEWUSER                    = TS_USRPRJPRIV_VIEWUSER;
const privId_e TS_PRIV_VIEWADVANCED                = TS_USRPRJPRIV_VIEWADVANCED;
const privId_e TS_PRIV_VIEWMANAGER                 = TS_USRPRJPRIV_VIEWMANAGER;
const privId_e TS_PRIV_ALLTRANS                    = TS_USRPRJPRIV_ALLTRANS;
const privId_e TS_PRIV_VIEWSYSTEM                  = TS_USRPRJPRIV_VIEWSYSTEM;
const privId_e TS_PRIV_EDITUSER                    = TS_USRPRJPRIV_EDITUSER;
const privId_e TS_PRIV_EDITADVANCED                = TS_USRPRJPRIV_EDITADVANCED;
const privId_e TS_PRIV_EDITMANAGER                 = TS_USRPRJPRIV_EDITMANAGER;
const privId_e TS_PRIV_EDITSYSTEM                  = TS_USRPRJPRIV_EDITSYSTEM;
const privId_e TS_PRIV_EDITPROFILE                 = TS_USRSYSPRIV_EDITPROFILE;
const privId_e TS_PRIV_VIEWALLISSUES               = TS_USRPRJPRIV_VIEWALLITEMS;
const privId_e TS_PRIV_UPDATEALL                   = TS_USRPRJPRIV_UPDATEALL;
const privId_e TS_PRIV_UPDATEIFOWNER               = TS_USRPRJPRIV_UPDATEIFOWNER;
const privId_e TS_PRIV_UPDATEIFSUBMITTER           = TS_USRPRJPRIV_UPDATEIFSUBMITTER;
const privId_e TS_PRIV_VIEWIFOWNER                 = TS_USRPRJPRIV_VIEWIFOWNER;
const privId_e TS_PRIV_VIEWIFSUBMITTER             = TS_USRPRJPRIV_VIEWIFSUBMITTER;
const privId_e TS_PRIV_TRANSIFOWNER                = TS_USRPRJPRIV_TRANSIFOWNER;
const privId_e TS_PRIV_TRANSIFSUBMITTER            = TS_USRPRJPRIV_TRANSIFSUBMITTER;
const privId_e TS_PRIV_OWN                         = TS_USRPRJPRIV_OWN;
const privId_e TS_PRIV_DELETE                      = TS_USRPRJPRIV_DELETE;
const privId_e TS_PRIV_LOGONASUSER                 = TS_USRSYSPRIV_LOGONASUSER;
const privId_e TS_PRIV_REMOTEADMIN                 = TS_USRSYSPRIV_REMOTEADMIN;
const privId_e TS_PRIV_SOURCEBRIDGE                = TS_USRSYSPRIV_SOURCEBRIDGE;
const privId_e TS_PRIV_VIEWATTACHMENTS             = TS_USRSYSPRIV_VIEWATTACHMENTS;
const privId_e TS_PRIV_VIEWNOTES                   = TS_USRSYSPRIV_VIEWNOTES;
const privId_e TS_PRIV_VIEWFOLDERS                 = TS_USRSYSPRIV_VIEWFOLDERS;
const privId_e TS_PRIV_VIEWFOLDERITEMS             = TS_USRFLDPRIV_VIEWFOLDERITEMS;
const privId_e TS_PRIV_ADDTOFOLDER                 = TS_USRFLDPRIV_ADDTOFOLDER;
const privId_e TS_PRIV_REMOVEFROMFOLDER            = TS_USRFLDPRIV_REMOVEFROMFOLDER;
const privId_e TS_RPTPERM_CREATEPRIVATE            = TS_USRPRJPRIV_ACCESSPRIVATERPT;
const privId_e TS_RPTPERM_CREATEGUEST              = TS_USRPRJPRIV_CREATEGUESTRPT;
const privId_e TS_RPTPERM_CREATEUSER               = TS_USRPRJPRIV_CREATEUSERRPT;
const privId_e TS_RPTPERM_CREATEMANAGER            = TS_USRPRJPRIV_CREATEMANAGERRPT;
const privId_e TS_RPTPERM_EDITGUEST                = TS_USRPRJPRIV_EDITGUESTRPT;
const privId_e TS_RPTPERM_EDITUSER                 = TS_USRPRJPRIV_EDITUSERRPT;
const privId_e TS_RPTPERM_EDITMANAGER              = TS_USRPRJPRIV_EDITMANAGERRPT;
const privId_e TS_RPTPERM_EXECGUEST                = TS_USRPRJPRIV_EXECGUESTRPT;
const privId_e TS_RPTPERM_EXECUSER                 = TS_USRPRJPRIV_EXECUSERRPT;
const privId_e TS_RPTPERM_EXECMANAGER              = TS_USRPRJPRIV_EXECMANAGERRPT;
const privId_e TS_RPTPERM_DELGUEST                 = TS_USRPRJPRIV_DELGUESTRPT;
const privId_e TS_RPTPERM_DELUSER                  = TS_USRPRJPRIV_DELUSERRPT;
const privId_e TS_RPTPERM_DELMANAGER               = TS_USRPRJPRIV_DELMANAGERRPT;
const privId_e TS_RPTPERM_EXECSYSTEM               = TS_USRSYSPRIV_EXECSYSTEM;
const privId_e TS_PRIV_ADDATTACHANY                = TS_USRPRJPRIV_ADDATTACHANY;
const privId_e TS_PRIV_ADDATTACHIFOWNER            = TS_USRPRJPRIV_ADDATTACHIFOWNER;
const privId_e TS_PRIV_ADDATTACHIFSUBMITTER        = TS_USRPRJPRIV_ADDATTACHIFSUBMITTER;
const privId_e TS_PRIV_DELATTACHANY                = TS_USRPRJPRIV_DELATTACHANY;
const privId_e TS_PRIV_DELATTACHIFOWNER            = TS_USRPRJPRIV_DELATTACHIFOWNER;
const privId_e TS_PRIV_DELATTACHIFSUBMITTER        = TS_USRPRJPRIV_DELATTACHIFSUBMITTER;
const privId_e TS_PRIV_DELATTACHIFAUTHOR           = TS_USRPRJPRIV_DELATTACHIFAUTHOR;
const privId_e TS_PRIV_ADDNOTEANY                  = TS_USRPRJPRIV_ADDNOTEANY;
const privId_e TS_PRIV_ADDNOTEIFOWNER              = TS_USRPRJPRIV_ADDNOTEIFOWNER;
const privId_e TS_PRIV_ADDNOTEIFSUBMITTER          = TS_USRPRJPRIV_ADDNOTEIFSUBMITTER;
const privId_e TS_PRIV_EDITNOTEANY                 = TS_USRPRJPRIV_EDITNOTEANY;
const privId_e TS_PRIV_EDITNOTEIFOWNER             = TS_USRPRJPRIV_EDITNOTEIFOWNER;
const privId_e TS_PRIV_EDITNOTEIFSUBMITTER         = TS_USRPRJPRIV_EDITNOTEIFSUBMITTER;
const privId_e TS_PRIV_EDITNOTEIFAUTHOR            = TS_USRPRJPRIV_EDITNOTEIFAUTHOR;
const privId_e TS_PRIV_DELNOTEANY                  = TS_USRPRJPRIV_DELNOTEANY;
const privId_e TS_PRIV_DELNOTEIFOWNER              = TS_USRPRJPRIV_DELNOTEIFOWNER;
const privId_e TS_PRIV_DELNOTEIFSUBMITTER          = TS_USRPRJPRIV_DELNOTEIFSUBMITTER;
const privId_e TS_PRIV_DELNOTEIFAUTHOR             = TS_USRPRJPRIV_DELNOTEIFAUTHOR;
const privId_e TS_PRIV_EDITATTACHANY               = TS_USRPRJPRIV_EDITATTACHANY;
const privId_e TS_PRIV_EDITATTACHIFOWNER           = TS_USRPRJPRIV_EDITATTACHIFOWNER;
const privId_e TS_PRIV_EDITATTACHIFSUBMITTER       = TS_USRPRJPRIV_EDITATTACHIFSUBMITTER;
const privId_e TS_PRIV_EDITATTACHIFAUTHOR          = TS_USRPRJPRIV_EDITATTACHIFAUTHOR;
const privId_e TS_PRIV_ADDATTACHIFCONTACT          = TS_USRPRJPRIV_ADDATTACHIFCONTACT;
const privId_e TS_PRIV_ADDNOTEIFCONTACT            = TS_USRPRJPRIV_ADDNOTEIFCONTACT;
const privId_e TS_PRIV_VIEWUSERONSUBMIT            = TS_USRPRJPRIV_VIEWUSERONSUBMIT;
const privId_e TS_PRIV_VIEWADVANCEDONSUBMIT        = TS_USRPRJPRIV_VIEWADVANCEDONSUBMIT;
const privId_e TS_PRIV_VIEWMANAGERONSUBMIT         = TS_USRPRJPRIV_VIEWMANAGERONSUBMIT;
const privId_e TS_PRIV_VIEWSYSTEMONSUBMIT          = TS_USRPRJPRIV_VIEWSYSTEMONSUBMIT;
const privId_e TS_PRIV_VIEWUSERONTRANSITION        = TS_USRPRJPRIV_VIEWUSERONTRANSITION;
const privId_e TS_PRIV_VIEWADVANCEDONTRANSITION    = TS_USRPRJPRIV_VIEWADVANCEDONTRANSITION;
const privId_e TS_PRIV_VIEWMANAGERONTRANSITION     = TS_USRPRJPRIV_VIEWMANAGERONTRANSITION;
const privId_e TS_PRIV_VIEWSYSTEMONTRANSITION      = TS_USRPRJPRIV_VIEWSYSTEMONTRANSITION;
const privId_e TS_PRIV_VIEWUSERONUPDATE            = TS_USRPRJPRIV_VIEWUSERONUPDATE;
const privId_e TS_PRIV_VIEWADVANCEDONUPDATE        = TS_USRPRJPRIV_VIEWADVANCEDONUPDATE;
const privId_e TS_PRIV_VIEWMANAGERONUPDATE         = TS_USRPRJPRIV_VIEWMANAGERONUPDATE;
const privId_e TS_PRIV_VIEWSYSTEMONUPDATE          = TS_USRPRJPRIV_VIEWSYSTEMONUPDATE;
const privId_e TS_PRIV_VIEWHIDDEN                  = TS_USRPRJPRIV_VIEWHIDDEN;
const privId_e TS_PRIV_APIACCESS                   = TS_USRSYSPRIV_APIACCESS;
const privId_e TS_PRIV_VIEWIFCONTACT               = TS_USRPRJPRIV_VIEWIFCONTACT;
const privId_e TS_PRIV_HANDHELD                    = TS_USRSYSPRIV_HANDHELD;
const privId_e TS_PRIV_SUBMITCONTACTS              = TS_USRSYSPRIV_SUBMITCONTACTS;
const privId_e TS_PRIV_UPDATECONTACTS              = TS_USRSYSPRIV_UPDATECONTACTS;
const privId_e TS_PRIV_DELETECONTACTS              = TS_USRSYSPRIV_DELETECONTACTS;
const privId_e TS_PRIV_VIEWCONTACTS                = TS_USRSYSPRIV_VIEWCONTACTS;
const privId_e TS_PRIV_SUBMITCOMPANIES             = TS_USRSYSPRIV_SUBMITCOMPANIES;
const privId_e TS_PRIV_UPDATECOMPANIES             = TS_USRSYSPRIV_UPDATECOMPANIES;
const privId_e TS_PRIV_DELETECOMPANIES             = TS_USRSYSPRIV_DELETECOMPANIES;
const privId_e TS_PRIV_VIEWCOMPANIES               = TS_USRSYSPRIV_VIEWCOMPANIES;
const privId_e TS_PRIV_SUBMITMERCHANDISE           = TS_USRSYSPRIV_SUBMITMERCHANDISE;
const privId_e TS_PRIV_UPDATEMERCHANDISE           = TS_USRSYSPRIV_UPDATEMERCHANDISE;
const privId_e TS_PRIV_DELETEMERCHANDISE           = TS_USRSYSPRIV_DELETEMERCHANDISE;
const privId_e TS_PRIV_VIEWMERCHANDISE             = TS_USRSYSPRIV_VIEWMERCHANDISE;
const privId_e TS_PRIV_SUBMITPRODUCTS              = TS_USRSYSPRIV_SUBMITPRODUCTS;
const privId_e TS_PRIV_UPDATEPRODUCTS              = TS_USRSYSPRIV_UPDATEPRODUCTS;
const privId_e TS_PRIV_DELETEPRODUCTS              = TS_USRSYSPRIV_DELETEPRODUCTS;
const privId_e TS_PRIV_VIEWPRODUCTS                = TS_USRSYSPRIV_VIEWPRODUCTS;
const privId_e TS_PRIV_SUBMITPROBLEMS              = TS_USRSYSPRIV_SUBMITPROBLEMS;
const privId_e TS_PRIV_UPDATEPROBLEMS              = TS_USRSYSPRIV_UPDATEPROBLEMS;
const privId_e TS_PRIV_DELETEPROBLEMS              = TS_USRSYSPRIV_DELETEPROBLEMS;
const privId_e TS_PRIV_VIEWPROBLEMS                = TS_USRSYSPRIV_VIEWPROBLEMS;
const privId_e TS_PRIV_SUBMITRESOLUTIONS           = TS_USRSYSPRIV_SUBMITRESOLUTIONS;
const privId_e TS_PRIV_UPDATERESOLUTIONS           = TS_USRSYSPRIV_UPDATERESOLUTIONS;
const privId_e TS_PRIV_DELETERESOLUTIONS           = TS_USRSYSPRIV_DELETERESOLUTIONS;
const privId_e TS_PRIV_VIEWRESOLUTIONS             = TS_USRSYSPRIV_VIEWRESOLUTIONS;
const privId_e TS_PRIV_SUBMITSERVICEAGREEMENTS     = TS_USRSYSPRIV_SUBMITSERVICEAGREEMENTS;
const privId_e TS_PRIV_UPDATESERVICEAGREEMENTS     = TS_USRSYSPRIV_UPDATESERVICEAGREEMENTS;
const privId_e TS_PRIV_DELETESERVICEAGREEMENTS     = TS_USRSYSPRIV_DELETESERVICEAGREEMENTS;
const privId_e TS_PRIV_VIEWSERVICEAGREEMENTS       = TS_USRSYSPRIV_VIEWSERVICEAGREEMENTS;
const privId_e TS_PRIV_ASSIGNCONTACTLICENSE        = TS_USRSYSPRIV_ASSIGNCONTACTLICENSE;
const privId_e TS_PRIV_VIEWCONTACTIFYOU            = TS_USRSYSPRIV_VIEWCONTACTIFYOU;
const privId_e TS_PRIV_VIEWPUBLICPROBLEMS          = TS_USRSYSPRIV_VIEWPUBLICPROBLEMS;

// Deprecated transition type (ref'd by upgrade)
const int TS_TRANSITION_SUBMITISSUE = 0x00000002;

// Deprecated Table Id Values (used in Tables table)
const int TS_TBLID_CASES                      = 1;
const int TS_TBLID_INCIDENTS                  = 36;
const int TS_TBLID_MERCHANDISE                = 39;
const int TS_TBLID_SERVICEAGREEMENTS          = 40;
const int TS_TBLID_PRODUCTS                   = 43;

// Attachment Attributes OBSOLETE!!! DO NOT USE!!!
const int TS_ATTACHATTRIB_LINK                = 1;
const int TS_ATTACHATTRIB_HTTP                = 2;
const int TS_ATTACHATTRIB_HTTPS               = 3;
const int TS_ATTACHATTRIB_FTP                 = 4;
const int TS_ATTACHATTRIB_IMAGE               = 10;
const int TS_ATTACHATTRIB_ISSUE               = TS_ATTACHATTRIB_ITEM;

// Deprecated Field Type Constants
const int TS_FLDTYPE_COMPANY                  = 112;
const int TS_FLDTYPE_PRODUCT                  = 114;
const int TS_FLDTYPE_SERVICEAGREEMENT         = 115;
const int TS_FLDTYPE_PROBLEM                  = 119;
const int TS_FLDTYPE_RESOLUTION               = 120;
const int TS_FLDTYPE_MERCHANDISE              = 121;

// Deprecated Field Property Constants - obsolete, use TS_FLDSECT constants
const int TS_FLDPROP_DEFAULT                  = TS_FLDSECT_DEFAULT;
const int TS_FLDPROP_STANDARD                 = TS_FLDSECT_STANDARD;
const int TS_FLDPROP_USER                     = TS_FLDSECT_USER;
const int TS_FLDPROP_ADVANCED                 = TS_FLDSECT_ADVANCED;
const int TS_FLDPROP_MANAGER                  = TS_FLDSECT_MANAGER;
const int TS_FLDPROP_SYSTEM                   = TS_FLDSECT_SYSTEM;
const int TS_FLDPROP_NOTUSED                  = TS_FLDSECT_NOTUSED;
const int TS_FLDPROP_NOTES                    = TS_FLDSECT_NOTES;
const int TS_FLDPROP_CHANGEHISTORY            = TS_FLDSECT_CHANGEHISTORY;
const int TS_FLDPROP_VERSIONCONTROL           = TS_FLDSECT_VERSIONCONTROL;
const int TS_FLDPROP_ATTACHMENTS              = TS_FLDSECT_ATTACHMENTS;
const int TS_FLDPROP_DELETED                  = TS_FLDSECT_DELETED;
const int TS_FLDPROP_MAX                      = TS_FLDSECT_MAX;
const int TS_FLDPROP_STATECHANGEHISTORY       = TS_FLDSECT_STATECHANGEHISTORY;
const int TS_FLDPROP_ITEMNOTIFICATION         = TS_FLDSECT_ITEMNOTIFICATION;
const int TS_FLDPROP_HIDDEN                   = TS_FLDSECT_HIDDEN;

// Deprecated Calculation field constants
const int TS_CALC_OP1_DATETIME                = TS_CALC_OP1_FLOAT;

// Deprecated API error code
const int TS_INVALID_DATA_TYPE                = TS_INVALID_DATATYPE;

#endif  // TS_DEF_H_
