// TSDisplayField.h: interface for the TSDisplayField class.
//
/////////////////////////////////////////////////////////////////////////

#ifndef TSDISPLAYFIELD_H_
#define TSDISPLAYFIELD_H_

#include "TSRecordRef.h"
#include "TSString.h"

#pragma warning( push, 1 )
#include "DisableSTLWarnings.h"
#include <list>
#pragma warning( pop )


class AFX_EXT_CLASS TSDisplayField : public TSRecordRef
{
  friend class TSServer;
  public:
    // Constructors/destructors/operator =
    TSDisplayField( TSServer& server, int nItemId = 0 ); // Will automatically set the table id member
    TSDisplayField( const TSDisplayField& that );
    virtual ~TSDisplayField();
    TSDisplayField& operator = ( const TSDisplayField& that );

    // Accessor methods:
    int                            GetAttribute() const    { return m_nAttribute; }
    const TSString&                GetPrefix() const       { return m_sPrefix; }
    const TSString&                GetDisplayValue() const { return m_sDisplayValue; }
    const TSString&                GetSuffix() const       { return m_sSuffix; }
    int                            GetProperty() const     { return m_nProperty; }
    int                            GetRequired() const     { return m_nRequired; }
    int                            GetSection() const      { return m_nSection; }
    const TSRecordRefList&         GetSelections() const   { return m_selections; }
    int                            GetType() const         { return m_nType; }

    bool IsModified() const   { return m_bModifiedFlag; }
    bool IsUpdateable() const { return m_bCanUpdate; }
    bool IsMultiSelect() const;

    int AddToDisplayValueForMultiSelect( const TSString& sAdditionalDisplayValue );
    int AddToDisplayValueForMultiSelect( const TSRecordRef* pAdditionalSelection );
    int ClearDisplayValue();
    int SetDisplayValue( const TSString& sNewDisplayValue );
    int SetDisplayValue( const TSRecordRef* pNewSelection );

    // For debugging
    TSString StringDump( TSString sIndentation );

  protected:
    // Only intended to be called by member methods of TSServer.
    int Receive( TSSocket* socket );

    bool     m_bCanUpdate;    // Set to true if the field value can be modified
    bool     m_bModifiedFlag; // Set to true if the field value was modified
    bool     m_bUseInternal;
    int      m_nAttribute;    // The attributes of this field (see TS_FLDATTRIB_ in TSDef.h)
    int	     m_nProperty;     // TS_FLDPROP_NONE or TS_FLDPROP_NONEDITABLE
    int	     m_nRequired;     // TS_FLDREQ_REQUIRED or TS_FLDREQ_NOTREQUIRED
    int	     m_nSection;      // The section the field is within (see TS_FLDSECT_ in TSDef.h)
    int      m_nType;         // The type of field (see TS_FLDTYPE_ in TSDef.h)
    TSString m_sDisplayValue; // The displayable form for this field's value
    TSString m_sInternalValue;
    TSString m_sPrefix;	      // The prefix for this field (displayed in front of value)
    TSString m_sSuffix;	      // The suffix for this field (displayed after value)
    TSRecordRefList m_selections; // If selection or binary field, this is a list
                                          //  of TSRecordRefs representing all valid selections
                                          //  (not populated on Reads)
    
  private:
    virtual int Read();
    int         ReadById( int nItemId );
    virtual int SetItemId( int nNewItemId );
    virtual int SetTableId( int nNewTableId );

};

typedef std::list< TSDisplayField* > TSDisplayFieldList;

#endif