// TSField.h: interface for the TSField class.
//
/////////////////////////////////////////////////////////////////////////

#ifndef TSFIELD_H_
#define TSFIELD_H_

#include "TSList.h"
#include "TSIntList.h"
#include "TSObject.h"
#include "TSSocket.h"

class AFX_EXT_CLASS TSField : public TSObject
{
  public:

    TSField();
    TSField( const TSField& field );
    virtual ~TSField();

    int Receive( TSSocket* socket, TSServer* server );
    int ReceiveSchema( TSSocket* socket );

    // Redefined from TSObject
    virtual TSObject* NewObject();
    virtual TSObject* Duplicate( int type = 0 );
    virtual void Copy( TSObject * );
    virtual TSString StringDump( int recursive, TSString indentation );

    // Field utility functions
    TSString DumpSchema( TSString indentation );
    static TSString FieldTypeToName( int fieldType );
    int SocketString( TSString& out );

    // Field description information
    int  schemaType;
    char fieldName[64];
    int  dataType;

    // Field data: one of these will have data, the rest will be 0 or NULL.
    char*         charValue;
    int           charValueMax;
    int           intValue;
    double        doubleValue;
    TSRecordList* recordList;
    TSIntList*    intList;

};

#endif