// TSIntList.C: implementation of the derived class: TSIntList.
//   derived from class: TSList.
//   associated class: TSPosition, TSIntObject.
//
/////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include <stdio.h>
#include "TSIntList.h"
#include "TSServer.h"
#include "TSSocket.h"

#pragma warning( disable: 4710 )  // inlined function not inlined

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Inherited class TSIntList methods
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

TSIntList::TSIntList() : TSList()
{
}

TSIntList::~TSIntList()
{
}

int TSIntList::Receive( TSServer*, TSSocket* socket )
{
  EmptyAndDestroyList();

  TSIntObject* intObject;
  int intValue;
  char ch;

  while ( socket->ReceiveInt( &intValue ) == TS_OK )
  {
    intObject = new TSIntObject( intValue );
    if ( AddTail( intObject ) != TS_OK )
    {
      // TSErrorCode is set in AddTail()
      return TSGetLastError();
    }
  }
  
  // There's always a \r\n at the end of the list, but usually the \r has
  // already been read so read up till the next \n.
  while (( ch = socket->ReadChar()) != 0 )
  {
    if ( ch == '\n' )
    {
      break;
    }
  }

  return TS_OK;
}

TSString TSIntList::CommaSeparatedList()
{
  TSString sOut = ",";
  TSPosition* pos;
  char tmpbuf[64];
  TSIntObject* intObject;

  for ( pos = GetFirst(); pos != NULL; pos = GetNext( pos ))
  {
    intObject = GetAt( pos );

    if ( intObject )
    {
      sprintf( tmpbuf, "%d,", intObject->intValue );
      sOut += tmpbuf;
    }
  }

  return sOut;
}

void TSIntList::PopulateByCommaSeparatedList( TSString sList )
{
  EmptyAndDestroyList();

  char* buf = sList.GetBuffer();
  char* bufptr = buf;
  int intValue;
  int numRead;
  TSIntObject* intObject;

  while ( *bufptr != '\0' )
  {
    if ( *bufptr == ',' )
    {
      bufptr++;
    }

    if ( sscanf( bufptr, "%d%n", &intValue, &numRead ) > 0 )
    { // Found a valid integer
      intObject = new TSIntObject( intValue );
      AddTail( intObject );
      bufptr += numRead;
    }
    else
    {
      bufptr++;
    }
  }
}
