// TSIntObject.cpp: implementation of the TSIntObject class.
//
/////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include <stdio.h>
#include "TSIntObject.h"
#include "TSServer.h"

TSIntObject::TSIntObject()
{
    intValue     = 0;
}

TSIntObject::TSIntObject( int newIntValue ) : intValue( newIntValue )
{
}

TSIntObject::TSIntObject( const TSIntObject& intObject )
{
  intValue = intObject.intValue;
}

TSIntObject::~TSIntObject()
{
}

int TSIntObject::Receive( TSSocket* socket, TSServer* )
{
  int nReturn = socket->ReceiveInt( &intValue );
  if ( nReturn != TS_OK )
  {
    // TSErrorCode is set in ReceiveInt
    return TSGetLastError();
  }
  return TS_OK;
}

TSObject* TSIntObject::NewObject()
{
  return new TSIntObject;
}

TSObject* TSIntObject::Duplicate( int /*type = 0*/ )
{
  TSIntObject* obj = new TSIntObject;
  obj->Copy( this );
  return obj;
}

void TSIntObject::Copy( TSObject* sourceIntObject )
{
  TSIntObject* newIntObject = static_cast<TSIntObject*>( sourceIntObject );
  intValue = newIntObject->intValue;
}

TSString TSIntObject::StringDump( int, TSString indentation )
{
  char tmpBuf[64];
  sprintf( tmpBuf, "%ld\n", intValue );
  TSString s = indentation + tmpBuf;
  return s;
}

int TSIntObject::SocketString( TSString& str )
{
  TSEncodeInt( intValue, str );
  return TS_OK;
}
