// TSIntObject.h: interface for the TSIntObject class.
//
/////////////////////////////////////////////////////////////////////////

#ifndef TSINTOBJECT_H_
#define TSINTOBJECT_H_

#include "TSDef.h"
#include "TSSocket.h"
#include "TSObject.h"

class TSServer;

class AFX_EXT_CLASS TSIntObject : public TSObject
{
  public:

    TSIntObject();
    TSIntObject( int newIntValue );
    TSIntObject( const TSIntObject& intObject );
    virtual ~TSIntObject();

    int Receive( TSSocket* socket, TSServer* server );

    // Redefined from TSObject
    virtual TSObject* NewObject();
    virtual TSObject* Duplicate( int type = 0 );
    virtual void Copy( TSObject * );
    virtual TSString StringDump( int recursive, TSString indentation );

    // IntObject utility functions
    int SocketString( TSString& out );

    // IntObject data.
    int           intValue;

};

#endif