// TSItemLink.cpp: implementation of the TSItemLink class.
//
/////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include <stdio.h>
#include "TSItemLink.h"
#include "TSServer.h"


TSItemLink::TSItemLink( TSServer& server, int nItemId /*=0*/ )
  : m_nDestItemId     ( 0 ),
    m_nDestItemNumber ( 0 ),
    m_nDestProjectId  ( 0 ),
    m_nDestTableId    ( 0 ),
    m_nLinkType       ( 0 ),
    m_sCreator        ( "" ),
    m_sDateTimeCreated( "" ),
    TSRecordRef       ( server, TS_TBLID_ATTACHMENTS, nItemId )
{
}

TSItemLink::TSItemLink( const TSItemLink& that )
  : m_nDestItemId     ( that.m_nDestItemId ),
    m_nDestItemNumber ( that.m_nDestItemNumber ),
    m_nDestProjectId  ( that.m_nDestProjectId ),
    m_nDestTableId    ( that.m_nDestTableId ),
    m_nLinkType       ( that.m_nLinkType ),
    m_sCreator        ( that.m_sCreator ),
    m_sDateTimeCreated( that.m_sDateTimeCreated ),
    TSRecordRef       ( that )
{
}

TSItemLink::~TSItemLink()
{
}

TSItemLink& TSItemLink::operator = ( const TSItemLink& that )
{
  TSRecordRef::operator = ( that );
  m_nDestItemId      = that.m_nDestItemId;
  m_nDestItemNumber  = that.m_nDestItemNumber;
  m_nDestProjectId   = that.m_nDestProjectId;
  m_nDestTableId     = that.m_nDestTableId;
  m_nLinkType        = that.m_nLinkType;
  m_sCreator         = that.m_sCreator;
  m_sDateTimeCreated = that.m_sDateTimeCreated;
  return *this;
}

int TSItemLink::Read()
{
  TSSetLastError( TS_ERROR );
  return TSGetLastError();
}

int TSItemLink::Receive( TSSocket* socket )
{
  if ( socket->ReceiveInt( &m_nItemId ) != TS_OK )
  {
    return TSGetLastError();
  }
  if ( socket->ReceiveInt( &m_nTableId ) != TS_OK )
  {
    return TSGetLastError();
  }
  if ( socket->ReceiveString( &m_sItemName ) != TS_OK )
  {
    return TSGetLastError();
  }
  if ( socket->ReceiveInt( &m_nDestItemId ) != TS_OK )
  {
    return TSGetLastError();
  }
  if ( socket->ReceiveInt( &m_nDestItemNumber ) != TS_OK )
  {
    return TSGetLastError();
  }
  if ( socket->ReceiveInt( &m_nDestProjectId ) != TS_OK )
  {
    return TSGetLastError();
  }
  if ( socket->ReceiveInt( &m_nDestTableId ) != TS_OK )
  {
    return TSGetLastError();
  }
  if ( socket->ReceiveInt( &m_nLinkType ) != TS_OK )
  {
    return TSGetLastError();
  }
  if ( socket->ReceiveString( &m_sCreator ) != TS_OK )
  {
    return TSGetLastError();
  }
  if ( socket->ReceiveString( &m_sDateTimeCreated ) != TS_OK )
  {
    return TSGetLastError();
  }
  return TS_OK;
}

int TSItemLink::SetItemId( int nNewItemId )
{
  nNewItemId;
  TSSetLastError( TS_ERROR );
  return TSGetLastError();
}

int TSItemLink::SetTableId( int nNewTableId )
{ 
  nNewTableId;
  TSSetLastError( TS_ERROR );
  return TSGetLastError();
}

TSString TSItemLink::StringDump( TSString sIndentation )
{
  char tmpBuf[64];
  TSString sSpacer = sIndentation + "  ";
  TSString s = sIndentation + "Item Link:\n";

  s += sSpacer + "Item Name = ";
  s += m_sItemName + "\n";

  s += sSpacer + "Item Id = ";
  sprintf( tmpBuf, "%ld", m_nItemId );
  s += tmpBuf;
  s += "\n";

  s += sSpacer + "Table Id = ";
  sprintf( tmpBuf, "%ld", m_nTableId );
  s += tmpBuf;
  s += "\n";

  s += sSpacer + "Destination Item Id = ";
  sprintf( tmpBuf, "%ld", m_nDestItemId );
  s += tmpBuf;
  s += "\n";

  s += sSpacer + "Destination Item Number = ";
  sprintf( tmpBuf, "%ld", m_nDestItemNumber );
  s += tmpBuf;
  s += "\n";

  s += sSpacer + "Destination Project Id = ";
  sprintf( tmpBuf, "%ld", m_nDestProjectId );
  s += tmpBuf;
  s += "\n";

  s += sSpacer + "Destination Table Id = ";
  sprintf( tmpBuf, "%ld", m_nDestTableId );
  s += tmpBuf;
  s += "\n";

  s += sSpacer + "Link Type = ";
  sprintf( tmpBuf, "%ld", m_nLinkType );
  s += tmpBuf;
  s += "\n";

  s += sSpacer + "Creator = ";
  s += m_sCreator + "\n";

  s += sSpacer + "DateTime Created = ";
  s += m_sDateTimeCreated + "\n\n";

  return s;
}
