// TSItemLink.h: interface for the TSItemLink class.
//
/////////////////////////////////////////////////////////////////////////

#ifndef TSITEMLINK_H_
#define TSITEMLINK_H_

#pragma warning( push, 1 )
#include "DisableSTLWarnings.h"
#include <list>
#pragma warning( pop )

#include "TSRecordRef.h"
#include "TSString.h"


// This class describes item links.

class AFX_EXT_CLASS TSItemLink : public TSRecordRef
{
  friend class TSServer;  
  public:
    // The constructor will automatically set the table id member.
    TSItemLink( TSServer& server, int nItemId = 0 );
    TSItemLink( const TSItemLink& that );
    virtual ~TSItemLink();
    TSItemLink& operator = ( const TSItemLink& that );

    // Accessor methods:
    const TSString& GetCreator() const         { return m_sCreator; }
    const TSString& GetDateTimeCreated() const { return m_sDateTimeCreated; }
    int             GetDestItemId() const      { return m_nDestItemId; }
    int             GetDestItemNumber() const  { return m_nDestItemNumber; }
    int             GetDestProjectId() const   { return m_nDestProjectId; }
    int             GetDestTableId() const     { return m_nTableId; }
    int             GetLinkType() const        { return m_nLinkType; }

    // For debugging
    TSString StringDump( TSString sIndentation );
    
   

  protected:
    // Only intended to be called by member methods of TSServer.
    int Receive( TSSocket* socket );

    int	     m_nDestItemId;	     // Item id of the item associated with the link
    int	     m_nDestItemNumber;	 // Item number of the item associated with the link
    int      m_nDestProjectId;	 // Project id of the item associated with the link
    int	     m_nDestTableId;     // Table id of the item associated with the link
    int	     m_nLinkType;        // Two-way or one-way link and trigger properties.
                                 // Use bit-wise 'OR' to create proper link type.
                                 //  Bit flag values are:
                                 //   TS_STORE_ACTION_TWOWAYLINK    = 0x0100,
                                 //   TS_STORE_ACTION_SOURCETRIGGER = 0x0200, and
                                 //   TS_STORE_ACTION_DESTTRIGGER   = 0x0400.
    TSString m_sCreator;         // The user that created the link
    TSString m_sDateTimeCreated; // The date and time the link was created (ignored on input)

  private:
    virtual int Read();
    int         ReadById( int nItemId );
    virtual int SetItemId( int nNewItemId );
    virtual int SetTableId( int nNewTableId );

};

typedef std::list< TSItemLink* > TSItemLinkList;

#endif
