// TSProject.cpp: implementation of the TSProject class.
//
/////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include <stdio.h>
#include "TSProject.h"
#include "TSServer.h"


// In this class, sFullProjectName contains a tab-delimited ( ^i ) string
//  representing the full project hierarchy, for example:
//     TeamShare Projects^iEngineering^iProducts^itSupport

TSProject::TSProject( TSServer& server, int nProjectId /*=0*/ )
  : m_nPrimaryTableId ( 0 ),
    m_sFullProjectName( "" ),
    TSRecordRef       ( server, TS_TBLID_PROJECTS, nProjectId )
{
}

TSProject::TSProject( TSServer& server, TSString sFullProjectName )
  : m_nPrimaryTableId ( 0 ),
    m_sFullProjectName( sFullProjectName ),
    TSRecordRef       ( server, TS_TBLID_PROJECTS, 0 )
{
}

TSProject::TSProject( const TSProject& that )
  : m_nPrimaryTableId ( that.m_nPrimaryTableId ),
    m_sFullProjectName( that.m_sFullProjectName ),
    TSRecordRef       ( that )
{
}

TSProject::~TSProject()
{
}

TSProject& TSProject::operator = ( const TSProject& that )
{
  TSRecordRef::operator = ( that );
  m_nPrimaryTableId  = that.m_nPrimaryTableId;
  m_sFullProjectName = that.m_sFullProjectName;
  return *this;
}

bool TSProject::IsValid() const
{
  if ( m_nItemId < 1 && !m_sFullProjectName.Length() )
  {
    return false;
  }
  return true;
}

int TSProject::Read()
{
	if ( !IsValid() )
	{
    TSSetLastError( TS_INVALID_PARAMETERS );
    return TSGetLastError();
	}
  return m_server.TSProjectRead( *this );
}

int TSProject::ReadByFullProjectName( TSString sFullProjectName )
{
	SetFullProjectName( sFullProjectName );
  return Read();
}

int TSProject::Receive( TSSocket* socket )
{
  if ( socket->ReceiveInt( &m_nItemId ) != TS_OK )
  {
    return TSGetLastError();
  }
  if ( socket->ReceiveInt( &m_nTableId ) != TS_OK )
  {
    return TSGetLastError();
  }
  if ( socket->ReceiveString( &m_sItemName ) != TS_OK )
  {
    return TSGetLastError();
  }
  if ( socket->ReceiveInt( &m_nPrimaryTableId ) != TS_OK )
  {
    return TSGetLastError();
  }
  if ( socket->ReceiveString( &m_sFullProjectName ) != TS_OK )
  {
    return TSGetLastError();
  }
  return TS_OK;
}

int TSProject::SetItemId( int nNewItemId )
{ 
  m_sFullProjectName = "";
  m_nItemId = nNewItemId;
  return TS_OK;
}

int TSProject::SetTableId( int nNewTableId )
{ 
  nNewTableId;
  TSSetLastError( TS_ERROR );
  return TSGetLastError();
}

TSString TSProject::StringDump( TSString sIndentation )
{
  char tmpBuf[64];
  TSString sSpacer = sIndentation + "  ";
  TSString s = sIndentation + "Project:\n";

  s += sSpacer + "Item Name = ";
  s += m_sItemName + "\n";

  s += sSpacer + "Item Id = ";
  sprintf( tmpBuf, "%ld", m_nItemId );
  s += tmpBuf;
  s += "\n";

  s += sSpacer + "Table Id = ";
  sprintf( tmpBuf, "%ld", m_nTableId );
  s += tmpBuf;
  s += "\n\n";

  s += sSpacer + "Primary Table Id = ";
  sprintf( tmpBuf, "%ld", m_nPrimaryTableId );
  s += tmpBuf;
  s += "\n";

  s += sSpacer + "Full Project Name = ";
  s += m_sFullProjectName + "\n\n";
  
  return s;
}