// TSProject.h: interface for the TSProject class.
//
/////////////////////////////////////////////////////////////////////////

#ifndef TSPROJECT_H_
#define TSPROJECT_H_

#pragma warning( push, 1 )
#include "DisableSTLWarnings.h"
#include <list>
#pragma warning( pop )

#include "TSRecordRef.h"
#include "TSString.h"


// In this class, sFullProjectName contains a tab-delimited ( ^i ) string
//  representing the full project hierarchy, for example:
//     TeamShare Projects^iEngineering^iProducts^itSupport

class AFX_EXT_CLASS TSProject : public TSRecordRef
{
  friend class TSServer;
  public:
    // Constructors/destructors/operator =
    TSProject( TSServer& server, int nProjectId = 0 );        // Will automatically set the table id member
    TSProject( TSServer& server, TSString sFullProjectName ); // Will automatically set table id
    TSProject( const TSProject& that );
    virtual ~TSProject();
    TSProject& operator = ( const TSProject& that );

    // Accessor methods:
    const TSString& GetFullProjectName() const { return m_sFullProjectName; }
    int             GetPrimaryTableId() const  { return m_nPrimaryTableId; }
    int             GetProjectId() const       { return GetItemId(); }
    void            SetFullProjectName( const TSString& sNewFullProjectName ) 
                      { m_nItemId = 0; m_sFullProjectName = sNewFullProjectName; }
    virtual int     SetItemId( int nNewItemId );
    void            SetProjectId( int nNewProjectId )
                      { SetItemId( nNewProjectId ); }
    
    // The Read method in this class will either read by table id and
    //  project id (m_nItemId in base class) or if the project id is 0 and
    //  the full project name is not empty, it will read by full project
    //  name. The name, and either the project id or full project name,
    //  will then be populated.
    // This requires a roundtrip to the server.
    virtual int Read(); 

    // This method will set the m_sFullProjectName member and clear the
    //  project id member before calling Read().
    int ReadByFullProjectName( TSString sFullProjectName );

    // For debugging
    TSString StringDump( TSString sIndentation );

  protected:
    // The IsValid method is called from the server and in Read
    //  to make sure that item id or full project name have been set.
    virtual bool IsValid() const;

    // Only intended to be called by member methods of TSServer.
    int Receive( TSSocket* socket );

    int      m_nPrimaryTableId;   // Id of the primary table associated with the project, e.g. issues
    TSString m_sFullProjectName;  // Tab-delimited string containing full project hierarchy

  private: 
    virtual int SetTableId( int nNewTableId );

};

typedef std::list< TSProject* > TSProjectList;

#endif
