// TSRecordRef.cpp: implementation of the TSRecordRef class.
//
/////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include <stdio.h>
#include "TSRecordRef.h"
#include "TSServer.h"

// This is the base class for several item classes. It can also be
//   instantiated directly in order to retrieve the name of an item.


TSRecordRef::TSRecordRef( TSServer& server, int nTableId /*=0*/, int nItemId /*=0*/ )
  : m_nItemId  ( nItemId ),
    m_nTableId ( nTableId ),
    m_sItemName( "" ),
    m_server   ( server )
{
}

TSRecordRef::TSRecordRef( const TSRecordRef& that )
  : m_nItemId  ( that.m_nItemId ),
    m_nTableId ( that.m_nTableId ),
    m_sItemName( that.m_sItemName ),
    m_server   ( that.m_server )
{
}

TSRecordRef::~TSRecordRef()
{
}

TSRecordRef& TSRecordRef::operator = ( const TSRecordRef& that )
{ 
  m_nItemId   = that.m_nItemId;
  m_nTableId  = that.m_nTableId;
  m_sItemName = that.m_sItemName;
  return *this;
}

bool TSRecordRef::IsValid() const
{
  if ( m_nTableId < 1 || m_nItemId < 1 )
  {
    return false;
  }
  return true;
}

int TSRecordRef::Read()
{
  if ( !IsValid() )
  {
    TSSetLastError( TS_INVALID_PARAMETERS );
    return TSGetLastError();
  }
  return m_server.TSRecordRefRead( *this );
}

int TSRecordRef::ReadById( int nItemId )
{
  SetItemId( nItemId );
  return Read();
}

int TSRecordRef::Receive( TSSocket* socket )
{
  if ( socket->ReceiveInt( &m_nItemId ) != TS_OK )
  {
    return TSGetLastError();
  }
  if ( socket->ReceiveInt( &m_nTableId ) != TS_OK )
  {
    return TSGetLastError();
  }
  if ( socket->ReceiveString( &m_sItemName ) != TS_OK )
  {
    return TSGetLastError();
  }
  return TS_OK;
}

int TSRecordRef::SetItemId( int nNewItemId )
{ 
  m_nItemId = nNewItemId;
  return TS_OK;
}

int TSRecordRef::SetTableId( int nNewTableId )
{
  m_nTableId = nNewTableId;
  return TS_OK;
}

TSString TSRecordRef::StringDump( TSString sIndentation )
{
  char tmpBuf[64];
  TSString sSpacer = sIndentation + "  ";
  TSString s = sIndentation + "RecordRef:\n";

  s += sSpacer + "Item Name = ";
  s += m_sItemName + "\n";

  s += sSpacer + "Item Id = ";
  sprintf( tmpBuf, "%ld", m_nItemId );
  s += tmpBuf;
  s += "\n";

  s += sSpacer + "Table Id = ";
  sprintf( tmpBuf, "%ld", m_nTableId );
  s += tmpBuf;
  s += "\n\n";

  return s;
}

