// TSRecordRef.h: interface for the TSRecordRef class.
//
/////////////////////////////////////////////////////////////////////////

#ifndef TSRECORDREF_H_
#define TSRECORDREF_H_

#pragma warning( push, 1 )
#include "DisableSTLWarnings.h"
#include <list>
#pragma warning( pop )

#include "TSDef.h"
#include "TSServer.h"
#include "TSString.h"


// This is the base class for several item classes. It can also be
//   instantiated directly in order to retrieve the name of an item.

class AFX_EXT_CLASS TSRecordRef
{
  friend class TSServer;

  public:

    // Constructors/destructor/operator =
    TSRecordRef( TSServer& server, int nTableId = 0, int nItemId = 0 );
    TSRecordRef( const TSRecordRef& that );
    virtual ~TSRecordRef();
    TSRecordRef& operator = ( const TSRecordRef& that );

    // Accessor methods:
    int             GetItemId() const   { return m_nItemId; }
    const TSString& GetItemName() const { return m_sItemName; }
    int             GetTableId() const  { return m_nTableId; }
    virtual int     SetItemId( int nNewItemId );
    virtual int     SetTableId( int nNewTableId );

    // Other Methods:

    // The Read method will cause a roundtrip to the server. All 
    //   appropriate data members will be filled in. The table id and
    //   item id must be set prior to using this method. The method
    //   will return TS_INVALID_PARAMETERS if either are not set. 
    // The base class method will only populate m_sItemName.
    virtual int Read();

    // The ReadById method will set the m_nItemId member and then
    //   call the virtual Read method.
    int ReadById( int nItemId );

    // Only intended to be called by member methods of TSServer
    //  or TSDisplayField to receive its m_selection.
    int Receive( TSSocket* socket );

    // The IsValid method is called from the server and in Read to 
    //   make sure that table id and item id have been set.
    virtual bool IsValid() const;

    // For debugging
    TSString StringDump( TSString sIndentation );

  protected:
    int       m_nItemId;   // Item Id (same as record id) of the item
    int       m_nTableId;  // Table id of the item (see TS_TBLID_ defines in TSDef.h)
    TSString  m_sItemName; // Name of item - filled in after a read
    TSServer& m_server;    // Reference to server connection

};

typedef std::list< TSRecordRef* > TSRecordRefList;

#endif

