// TSString.h: interface for the TSSTring class.
//
/////////////////////////////////////////////////////////////////////////

#ifndef TSSTRING_H_
#define TSSTRING_H_

#include <string.h>

#include "TSDef.h"
#include "TSObject.h"

class AFX_EXT_CLASS TSString : public TSObject
{
  public:
    TSString( const char* str );
    TSString();
    TSString( const TSString& str );
    ~TSString();

    TSString& operator += ( const char* str );
    TSString& operator += ( const TSString& str );
    TSString& operator += ( char c );
    TSString& operator =  ( const char* str );
    TSString& operator =  ( const TSString& str );

    BOOL operator == ( const TSString& str ) const;
    BOOL operator == ( const char* str ) const;

    BOOL operator != ( const TSString& str ) const;
    BOOL operator != ( const char* str ) const;

    // returns 0 if idx is out of range or if buffer doesn't exist
    char operator [] ( int idx ) const;

    TSString operator + ( const TSString& second );
    TSString operator + ( const char* str );

    operator const char*() const;

    int Length() const { return length; }

    void Empty();

    void TrimRight( const char* str=NULL );
    void TrimRight( const char c );
    void TrimRight( const TSString& str );
    void TrimLeft ( const char* str=NULL );
    void TrimLeft ( const char c );
    void TrimLeft ( const TSString& str );


    char *GetBuffer();
    char *GetBuffer( size_t minsize );

    int CompareNoCase( const char* str ) const;
    char* Find( const char* str ) const;

    // Inherited from TSObject
    virtual TSObject* NewObject();
    virtual void Copy( TSObject * );
    virtual TSObject* Duplicate( int type = 0 );
    virtual TSString StringDump( int recursive, TSString indentation );
    virtual int SocketString( TSString& str );

  private:

    char* buffer;
    unsigned int bufsize;
    static int BUFFER_EXCESS;
    size_t length;
};

#endif
