// TSTransition.cpp: implementation of the TSTransition class.
//
/////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include <stdio.h>
#include "TSServer.h"
#include "TSTransition.h"

// This class describes a transition.


TSTransition::TSTransition( TSServer& server, int nTransitionId /*=0*/ )
  : TSRecordRef( server, TS_TBLID_TRANSITIONS, nTransitionId )
{
}

TSTransition::TSTransition( const TSTransition& that )
  : TSRecordRef( that )
{
}

TSTransition::~TSTransition()
{
}

TSTransition& TSTransition::operator = ( const TSTransition& that )
{
  TSRecordRef::operator = ( that );
  return *this;
}

int TSTransition::SetTableId( int nNewTableId )
{ 
  nNewTableId;
  TSSetLastError( TS_ERROR );
  return TSGetLastError();
}

TSString TSTransition::StringDump( TSString sIndentation )
{
  char tmpBuf[64];
  TSString sSpacer = sIndentation + "  ";
  TSString s = sIndentation + "Transition:\n";

  s += sSpacer + "Item Name = ";
  s += m_sItemName + "\n";

  s += sSpacer + "Item Id = ";
  sprintf( tmpBuf, "%ld", m_nItemId );
  s += tmpBuf;
  s += "\n";

  s += sSpacer + "Table Id = ";
  sprintf( tmpBuf, "%ld", m_nTableId );
  s += tmpBuf;
  s += "\n\n";

  return s;
}