// TSTransition.h: interface for the TSTransition class.
//
/////////////////////////////////////////////////////////////////////////

#ifndef TSTRANSITION_H_
#define TSTRANSITION_H_

#pragma warning( push, 1 )
#include "DisableSTLWarnings.h"
#include <list>
#pragma warning( pop )

#include "TSRecordRef.h"


// This class describes a transition.

class AFX_EXT_CLASS TSTransition : public TSRecordRef
{
  friend class TSServer;  
  public:
    // Constructors/destructors/operator =
    TSTransition( TSServer& server, int nTransitionId = 0 ); // Will automatically set the table id 
    TSTransition( const TSTransition& that );
    virtual ~TSTransition();
    TSTransition& operator = ( const TSTransition& that );

    // For debugging
    TSString StringDump( TSString sIndentation );

  private:
    virtual int SetTableId( int nNewTableId );

};

typedef std::list< TSTransition* > TSTransitionList;

#endif
