# packaging/linux/p4dti.spec -- spec. for building a Linux RPM for P4DTI
#
# $Id: //info.ravenbrook.com/project/p4dti/version/2.1/packaging/linux/p4dti.spec#5 $
#
# This is the RPM "spec" file used to create the RPM distributed as part
# of a release of the Perforce Defect Tracking Integration (P4DTI).  This
# file is used during the Release Build Procedure [GDR 2000-10-17].  See
# that document for details of how to use this file when building a
# Linux distribution.  See [FJMD 2001-02-13] for an explanation of the
# entries in this file.
#
# This file must be edited each time a new release is created to update
# the "Version" field (which corresponds to the P4DTI project's notion
# of a "release", e.g. "1.0.6") and the "%description" with correct
# compatibility information.
#
# ---
#
# This file is copyright (c) 2001 Perforce Software, Inc.  All rights  
# reserved.
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
# 
# 1.  Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
# 
# 2.  Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in
#     the documentation and/or other materials provided with the
#     distribution.
# 
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# HOLDERS AND CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
# BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
# OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
# ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
# TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
# USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
# DAMAGE.
#

Name: p4dti
Version: 2.1.2
Group: Development/Tools
Source: p4dti-bugzilla-%{version}.tar.gz
Summary: An integration between Perforce SCM and Bugzilla
Prefix: /opt/p4dti
Prefix: /var/lock/subsys
Prefix: /var/run
Prefix: /etc/rc.d
Prefix: /usr/doc/p4dti-%{version}
License: see sources
Buildroot: /var/tmp/%{name}-buildroot
Release: 1
Vendor: Perforce Software, Inc.

%description
This is the Perforce Defect Tracking Integration (P4DTI).

P4DTI connects your defect tracking system to Perforce, so that you
don't have to switch between them and enter duplicate information about
your work.  It also links changes made in Perforce with defect tracker
issues, making it easy to find out why a change was made, find the work
that was done to resolve an issue, or generate reports relating issues
to files or codelines.

This package supports:

  - Perforce 2000.2, 2001.1, 2002.1, 2002.2, 2003.1, or 2003.2,
    on any platform;

  - Bugzilla 2.14.5 or 2.16.4;

  - Python 1.5.2, 2.0, or later;

Use of Bugzilla 2.14.4, 2.16.1, 2.16.2, or 2.16.3 is also supported,
but is deprecated: support may be dropped in a future version of the
P4DTI.

Support for Python 1.5.2 is deprecated, and may be dropped in a future
version of the P4DTI.

For more information see the Administrator's Guide installed as part of
this package, or the Perforce Software web site
<http://www.perforce.com/>.

%prep

# This is the name of the directory created by untarring the "Source"
# tar file [GDR 2000-10-17, 2.3].  This should be the same as the
# basename of the tar file itself.
%setup -n p4dti-bugzilla-%{version}

%build
rm -fr $RPM_BUILD_ROOT

%install
mkdir -p $RPM_BUILD_ROOT/opt/p4dti
cp *.py *.txt *-patch $RPM_BUILD_ROOT/opt/p4dti
touch $RPM_BUILD_ROOT/opt/p4dti/config.pyc
chmod 440 $RPM_BUILD_ROOT/opt/p4dti/config.py $RPM_BUILD_ROOT/opt/p4dti/config.pyc
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/init.d
install startup-script $RPM_BUILD_ROOT/etc/rc.d/init.d/p4dti

%clean
rm -fr $RPM_BUILD_ROOT

%pre
/usr/sbin/groupadd -r -f p4dti && /usr/sbin/useradd -c 'Perforce Defect Tracking Integrator' -d $RPM_INSTALL_PREFIX0 -g p4dti -r -M p4dti || printf "A p4dti user has not been created\n"

%post

# If the package is relocated, the start script will have to be altered
# so that it uses the correct directories.

printf "/^P4DTIDIR/c\nP4DTIDIR=%s\n.\nw\n" $RPM_INSTALL_PREFIX0 | ed -s $RPM_INSTALL_PREFIX3/init.d/p4dti
printf "/^LOCKFILE/c\nLOCKFILE=%s\n.\nw\n" $RPM_INSTALL_PREFIX1/p4dti | ed -s $RPM_INSTALL_PREFIX3/init.d/p4dti
printf "/^PIDFILE/c\nPIDFILE=%s\n.\nw\n" $RPM_INSTALL_PREFIX2/p4dti.pid | ed -s $RPM_INSTALL_PREFIX3/init.d/p4dti

# We need symlinks from the right runlevel directories to the actual script

ln -sf $RPM_INSTALL_PREFIX3/init.d/p4dti $RPM_INSTALL_PREFIX3/rc0.d/K90p4dti
ln -sf $RPM_INSTALL_PREFIX3/init.d/p4dti $RPM_INSTALL_PREFIX3/rc1.d/K90p4dti
ln -sf $RPM_INSTALL_PREFIX3/init.d/p4dti $RPM_INSTALL_PREFIX3/rc2.d/S90p4dti
ln -sf $RPM_INSTALL_PREFIX3/init.d/p4dti $RPM_INSTALL_PREFIX3/rc3.d/S90p4dti
ln -sf $RPM_INSTALL_PREFIX3/init.d/p4dti $RPM_INSTALL_PREFIX3/rc4.d/S90p4dti
ln -sf $RPM_INSTALL_PREFIX3/init.d/p4dti $RPM_INSTALL_PREFIX3/rc5.d/S90p4dti
ln -sf $RPM_INSTALL_PREFIX3/init.d/p4dti $RPM_INSTALL_PREFIX3/rc6.d/K90p4dti
chmod a+x $RPM_INSTALL_PREFIX3/init.d/p4dti

# These are only needed for package relocation, but should have no effect
# otherwise.

mkdir -p $RPM_INSTALL_PREFIX1
mkdir -p $RPM_INSTALL_PREFIX2

%preun
for i in $RPM_INSTALL_PREFIX0/p4dti.log $(ls $RPM_INSTALL_PREFIX0/*.pyc 2>/dev/null)
do
  [ -f $i ] && rm $i
done

%postun
if id p4dti 2>/dev/null
then
  /usr/sbin/userdel p4dti
fi

%files
%defattr(-,p4dti,p4dti)
%doc ug ag
/opt/p4dti
%attr(-,root,root) /etc/rc.d/init.d/p4dti

#
# A. REFERENCES
#
# [FJMD 2001-02-13] "Building RPMs for P4DTI"; Francis Davey;
# Ravenbrook Limited; 2001-02-13.
#
# [GDR 2000-10-17] "Perforce Defect Tracking Integration Release
# Build Procedure"; Gareth Rees; Ravenbrook Limited; 2000-10-17.
#
#
# B. DOCUMENT HISTORY
#
# 2002-02-04 GDR Updated for release 1.4.0.
#
# 2002-04-09 NB Updated for release 1.4.1.
#
# 2002-04-19 NB Updated for release 1.4.2.
#
# 2002-10-31 NB Updated for release 1.5.0.
#
# 2002-11-20 NB Updated for release 1.5.1.
#
# 2002-12-11 NB Updated for release 1.5.2.
#
# 2002-12-13 NB Extend support to Perforce 2002.2.
#
# 2002-12-13 NB Updated for release 1.5.3.
#
# 2003-06-02 NB Updated for release 2.0.0.
#
# 2003-09-26 NB Set permissions on config.py and config.pyc to restrict
# access to passwords which are stored in these files.
#
# 2003-12-13 NB Add Perforce 2003.1 and 2003.2.
#
# 2003-12-13 NB Updated for release 2.1.0.
#
# 2003-12-17 NB Updated for release 2.1.1.
#
# 2004-01-08 NB Updated for release 2.1.2.
