#             Perforce Defect Tracking Integration Project
#              <http://www.ravenbrook.com/project/p4dti/>
#
#       CONFIG_GROUSE.PY -- CONFIGURATION FOR TESTING ON GROUSE
#
#           Richard Brooksby, Ravenbrook Limited, 2000-12-08
#
#
# 1. INTRODUCTION
#
# This is the configuration script for testing the Bugzilla integration
# on grouse.ravenbrook.com.  See [RB 2000-08-10] for definition of the
# configuration parameters.
#
# The intended readership is project testers.
#
# This document is not confidential.

import message


# 2. ESSENTIAL CONFIGURATION PARAMETERS

dt_name = "Bugzilla"
administrator_address = 'nb@ravenbrook.com'
p4_port = '127.0.0.1:16667'
p4_user = 'P4DTI-replicator0'
p4_password = 'password'
replicator_address = 'nb+p4dti-replicator0@ravenbrook.com'
smtp_server = 'smtp.ravenbrook.com'
start_date = '1999-12-31 23:59:59'


# 3. BUGZILLA CONFIGURATION PARAMETERS

closed_state = 'RESOLVED'
replicated_fields = ['longdesc', 'priority', 'bug_severity', 'product']
dbms_host = 'localhost'
dbms_port = 3306
dbms_database = 'gdr_bugs'
dbms_user = 'bugs'
dbms_password = ''
bugzilla_directory = None


# 4. OTHER CONFIGURATION PARAMETERS

rid = 'replicator0'
sid = 'perforce0'
changelist_url = "http://grouse.ravenbrook.com:8080/%d?ac=10"
job_url = None
log_file = None
log_level = message.INFO
p4_client_executable = '/usr/local/bin/p4'
p4_server_description = 'Perforce server on grouse'
poll_period = 10
def replicate_p(self):
    return 1


# 5. CONFIGURATION PARAMETERS FOR THE TEST SUITE

p4_license_file = '/Users/gdr/info.ravenbrook.com/config/grouse.ravenbrook.com/usr/local/share/p4/license'
p4_server_executable = '/usr/local/bin/p4d'
bugzilla_version = '2.14.1'
bugzilla_admin_user = 'gdr+bugzilla@ravenbrook.com'
bugzilla_admin_password = 'p4dtitest'
bugzilla_mysqldump = 'bugzilla-2.14-mysqldump'


# A. REFERENCES
#
# [RB 2000-08-10] "Perforce Defect Tracking Integration Administrator's
# Guide"; Richard Brooksby; Ravenbrook Limited; 2000-08-10;
# <http://www.ravenbrook.com/project/p4dti/version/2.1/manual/ag/>.
#
#
# B. DOCUMENT HISTORY
#
# 2001-11-28 GDR Removed comments.
#
#
# C. COPYRIGHT AND LICENSE
#
# This file is copyright (c) 2001 Perforce Software, Inc.  All rights
# reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1.  Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#
# 2.  Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in
#     the documentation and/or other materials provided with the
#     distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
# FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
# COPYRIGHT HOLDERS AND CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
# INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
# STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
# OF THE POSSIBILITY OF SUCH DAMAGE.
#
#
# $Id: //info.ravenbrook.com/project/p4dti/version/2.1/test/config_grouse.py#2 $
