#             Perforce Defect Tracking Integration Project
#              <http://www.parrus.com/project/p4dti/>
#
#         CONFIG_PARRUS.PY -- CONFIGURATION FOR TESTING ON PARRUS
#
#           Ram Timmachipuram, Parrus Technologies, 2002-05-06
#
#
# 1. INTRODUCTION
#
# This is the configuration script for testing the Bugzilla integration
# on the parrus server.  
#
# The intended readership is project testers.
#
# This document is not confidential.
# 
# Note on running the test scripts:
# 1. If you are using a webserver, ensure that the bugzilla directory is visible under the webserver
#    and provide the base url to the bz_url_root variable below.
# 2. You have to manually enter the bugzilla admin user name and password for one of the testcases.
#    Make sure that you provide the same information as in the config file. 
# 3. Note that because the automated scripts make use of database dumps that populate the bugzilla db,
#    any change in the admin user information below will need additional effort to create new db dumps
# 4. Temporary files are created under C:\Documents and Settings\<user>\Local Settings\Temp 
# 5. You may have to start the p4d server in the local environment before running the test scripts.

import message


# 2. ESSENTIAL CONFIGURATION PARAMETERS

dt_name = "Bugzilla"
administrator_address = 'ram@parrus.com'
p4_port = 'parrus:1666'
p4_user = 'ram'
p4_password = ''
replicator_address = 'ram@parrus.com'
smtp_server = None
start_date = '1999-12-31 23:59:59'


# 3. BUGZILLA CONFIGURATION PARAMETERS

closed_state = 'RESOLVED'
replicated_fields = ['longdesc', 'priority', 'bug_severity', 'product','reporter']
dbms_host = 'localhost'
dbms_port = 3306
dbms_database = 'bugs'
dbms_user = 'bugs'
dbms_password = ''
bugzilla_directory = None


# 4. OTHER CONFIGURATION PARAMETERS

rid = 'replicator0'
sid = 'perforce0'
changelist_url = None
job_url = None
log_file = None
log_level = message.INFO
p4_client_executable = 'C:\\Perforce\\p4.exe'
p4_server_description = 'Perforce server '
poll_period = 10
def replicate_p(self):
    return 1


# 5. CONFIGURATION PARAMETERS FOR THE TEST SUITE

p4_license_file = 'C:\\Perforce\\license'
p4_server_executable = 'C:\\Perforce\\p4d.exe'
bugzilla_version = '2.14.1'
bugzilla_admin_user = 'magesh@parrus.com'
bugzilla_admin_password = 'parrus'
bugzilla_mysqldump = 'bugzilla-2.14-mysqldump'
#Provide the url root leading to the bugzilla directory. e.g. if the url is http://localhost/p4dti/bugzilla the toot is p4dti
bz_url_root = '/p4dti/'


# A. REFERENCES
#
# [RB 2000-08-10] "Perforce Defect Tracking Integration Administrator's
# Guide"; Richard Brooksby; Ravenbrook Limited; 2000-08-10;
# 
#
#
# B. DOCUMENT HISTORY
#
# 2002-05-06 Ram Config file for Win2000.
#
#
# C. COPYRIGHT AND LICENSE
#
# This file is copyright (c) 2001 Perforce Software, Inc.  All rights
# reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1.  Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#
# 2.  Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in
#     the documentation and/or other materials provided with the
#     distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
# FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
# COPYRIGHT HOLDERS AND CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
# INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
# STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
# OF THE POSSIBILITY OF SUCH DAMAGE.
#
#

