#                Perforce Defect Tracking Integration Project
#                 <http://www.ravenbrook.com/project/p4dti/>
#
#  CONFIG_RAVENBROOK_BZ.PY -- MIGRATION OF RAVENBROOK JOBS TO BUGZILLA
#
#             Gareth Rees, Ravenbrook Limited, 2001-11-06
#
#
# 1. INTRODUCTION
#
# This is the configuration used to test migration of Ravenbrook's jobs
# from a Perforce server on thrush.ravenbrook.com to a Bugzilla server
# on swan.ravenbrook.com.  See [RB 2000-08-10] for definition of the
# configuration parameters.
#
# The intended readership is project testers.
#
# This document is not confidential.

import message


# 2. ESSENTIAL CONFIGURATION PARAMETERS

dt_name = "Bugzilla"
administrator_address = "gdr+bugzilla@ravenbrook.com"
p4_port = "thrush.ravenbrook.com:16668"
p4_user = "p4dti-replicator0"
p4_password = ""
replicator_address = "gdr+p4dti-replicator0@ravenbrook.com"
smtp_server = "smtp.ravenbrook.com"
start_date = "1996-12-31 23:59:59"


# 3. BUGZILLA CONFIGURATION PARAMETERS

closed_state = "RESOLVED"
replicated_fields = ["longdesc", "bug_severity", "product"]
dbms_host = "localhost"
dbms_port = 3306
dbms_database = "ravenbrook_bugs"
dbms_user = "bugs"
dbms_password = ""
bugzilla_directory = None #"/home/gdr/bugzilla-2.14-ravenbrook"


# 4. OTHER CONFIGURATION PARAMETERS

rid = "replicator0"
sid = "perforce0"
changelist_url = None
job_url = None
log_file = None
log_level = message.INFO
p4_client_executable = "/home/p4/bin/p4"
p4_server_description = "Perforce server on " + p4_port
poll_period = 10
use_perforce_jobnames = 0

migrated_user_groups = ["editbugs", "canconfirm"]
migrated_user_password = "p4dtitest"

def replicate_p(issue):
    return 1

def translate_jobspec(job):
    status_map = {
        'open': ('assigned', ''),
        'closed': ('closed', 'FIXED'),
        'suspended': ('closed', 'LATER'),
        'duplicate': ('closed', 'DUPLICATE'),
        }
    status, resolution = status_map[job.get('Status', 'open')]
    job['Status'] = status
    job['Resolution'] = resolution
    job['Assigned_To'] = job.get('User','gdr')
    job['Summary'] = job.get('Title', 'No summary')
    job['Component'] = job['Product']
    job['Product'] = job['Project']
    return job

def prepare_issue(issue, job):
    issue['component'] = job['Component']
    issue['version'] = 'unspecified'
    pass

def migrate_p(job):
    return 1


# A. REFERENCES
#
# [RB 2000-08-10] "Perforce Defect Tracking Integration Administrator's
# Guide"; Richard Brooksby; Ravenbrook Limited; 2000-08-10;
# <http://www.ravenbrook.com/project/p4dti/version/2.1/manual/ag/>.
#
#
# B. DOCUMENT HISTORY
#
# 2001-11-27 GDR Created.
#
#
# C. COPYRIGHT AND LICENSE
#
# This file is copyright (c) 2001 Perforce Software, Inc.  All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# 1.  Redistributions of source code must retain the above copyright notice,
#     this list of conditions and the following disclaimer.
#
# 2.  Redistributions in binary form must reproduce the above copyright notice,
#     this list of conditions and the following disclaimer in the documentation
#     and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS AND CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
#
# $Id$
