#             Perforce Defect Tracking Integration Project
#              <http://www.ravenbrook.com/project/p4dti/>
#
#             CONFIG_SANDPIPER_BZ.PY -- CONFIGURATION FOR 
#                  WITH BUGZILLA TESTING ON SANDPIPER
#
#           Francis Irving, Ravenbrook Limited, 2002-10-11
#
#
# 1. INTRODUCTION
#
# This is a configuration script for the Bugzilla Integration on
# sandpiper.ravenbrook.com.  See [RB 2000-08-10] for definition of the
# configuration parameters.
#
# The intended readership is project testers.
#
# This document is not confidential.

# Set environment variable P4DTI_CONFIG=config_sandpiper_bz.py to select
# Bugzilla testing when running test_p4dti.py on sandpiper.

import message

# This finds the p4dti project level of the path that the test was
# run in.  Use to refer to files in import and so on.

# Uses find_module instead of getcwd, because when running as a
# service the CWD is C:\WINNT\system32.

import imp
fml = imp.find_module("init")[1]
curdir_list=fml.split("\\")
project_path="\\".join(curdir_list[:curdir_list.index("p4dti")+1])

# 2. ESSENTIAL CONFIGURATION PARAMETERS

dt_name = "Bugzilla"
administrator_address = 'nb@ravenbrook.com'
p4_port = 'sandpiper.ravenbrook.com:16667'
p4_user = 'P4DTI-replicator0'
p4_password = 'foo'
replicator_address = 'nb+p4dti-replicator0@ravenbrook.com'
smtp_server = 'smtp.ravenbrook.com'
start_date = '1999-12-31 23:59:59'


# 3. BUGZILLA CONFIGURATION PARAMETERS

closed_state = 'RESOLVED'
replicated_fields = ['longdesc', 'priority', 'bug_severity', 'product']
omitted_fields = []
field_names = [('assigned_to', 'User')]
dbms_host = 'localhost'
dbms_port = 3306
dbms_database = 'gdr_bugs'
dbms_user = 'bugs'
dbms_password = ''
bugzilla_directory = None


# 4. OTHER CONFIGURATION PARAMETERS

rid = 'replicator0'
sid = 'perforce0'
changelist_url = "http://sandpiper.ravenbrook.com:8080/%d?ac=10"
job_url = None
log_file = None
log_level = message.INFO
p4_client_executable = 'C:\\Program Files\\Perforce\\p4.exe'
p4_server_description = 'Perforce server on ' + p4_port
poll_period = 10
def replicate_p(self):
    return 1


# 5. CONFIGURATION PARAMETERS FOR THE TEST SUITE

p4_license_file = 'C:\\Program Files\\Perforce\\license'
p4_server_executable = 'C:\\Program Files\\Perforce\\p4d.exe'
bugzilla_version = '2.14.5'
bugzilla_admin_user = 'gdr+bugzilla@ravenbrook.com'
bugzilla_admin_password = 'p4dtitest'
bugzilla_mysqldump = 'bugzilla-2.14.5-mysqldump'


# A. REFERENCES
#
# [RB 2000-08-10] "Perforce Defect Tracking Integration Administrator's
# Guide"; Richard Brooksby; Ravenbrook Limited; 2000-08-10;
# <http://www.ravenbrook.com/project/p4dti/version/1.4/manual/ag/>.
#
#
# B. DOCUMENT HISTORY
#
# 2002-10-11 FAI Created.
#
#
# C. COPYRIGHT AND LICENSE
#
# This file is copyright (c) 2001 Perforce Software, Inc.  All rights
# reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
#
# 1.  Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#
# 2.  Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in
#     the documentation and/or other materials provided with the
#     distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# HOLDERS AND CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
# BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
# OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
# ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
# TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
# USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
# DAMAGE.
#
#
# $Id: //info.ravenbrook.com/project/p4dti/version/1.4/test/config_sandpiper.py#2 $




