#!/usr/bin/env python
#
#             Perforce Defect Tracking Integration Project
#              <http://www.ravenbrook.com/project/p4dti/>
#
#       FAKE_P4D.PY -- FAKE PERFORCE CLIENT (OLD SERVER VERSION)
#
#             Gareth Rees, Ravenbrook Limited, 2001-03-16
#
#
# 1. INTRODUCTION
#
# This script pretends to be a Perforce client executable that connects
# to a Perforce server that is not supported by the P4DTI because its
# version is too old.  This allows the test_p4dti.py script to test that
# old Perforce server versions are detected correctly and rejected with
# a suitable error message.
#
# The earliest supported server changelevel is 18974 (see
# replicator.py).
#
# The earliest supported client changelevel is 16895 (see p4.py).

import getopt
import marshal
import sys

# We have to fool p4.py into accepting us, so we fake a response to the
# -V option that prints a message with a valid client changelevel.
opts, args = getopt.getopt(sys.argv[1:], "VGu:p:P:c:")

if ('-V','') in opts:
    print "Perforce - The Fast Software Configuration Management System."
    print "Copyright 1995, 2000 Perforce Software.  All rights reserved."
    print "Rev. P4/FAKE/2000.1/16895 (2000/08/29)."
else:
    marshal.dump({
        'code': 'info',
        'data': "Server version: P4D/FAKE/2000.2/18973 (2000/12/18)"},
                 sys.stdout)


# A. REFERENCES
#
#
# B. DOCUMENT HISTORY
#
# 2001-03-16 GDR Created.
#
#
# C. COPYRIGHT AND LICENSE
#
# This file is copyright (c) 2001 Perforce Software, Inc.  All rights
# reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
#
# 1.  Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#
# 2.  Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in
#     the documentation and/or other materials provided with the
#     distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# HOLDERS AND CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
# BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
# OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
# ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
# TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
# USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
# DAMAGE.
#
#
# $Id: //info.ravenbrook.com/project/p4dti/version/2.1/test/fake_p4d_old_changelevel.py#1 $
