#             Perforce Defect Tracking Integration Project
#              <http://www.ravenbrook.com/project/p4dti/>
#
#                TEST_XHTML.PY -- CHECK XHTML DOCUMENTS
#
#             Gareth Rees, Ravenbrook Limited, 2001-07-25
#
#
# 1. INTRODUCTION
#
# This test case checks that all XHTML documents in the P4DTI project
# adhere to the XHTML 1.0 Transitional specification [XHTML 1.0].
#
# It uses the PyUnit unit test framework [PyUnit].
#
# The intended readership is project developers.
#
# This document is not confidential.

import check_xhtml
import os
import p4dti_unittest
import unittest


# 2. CHECK XHTML
#
# This checks all XHTML documents under the parent directory.  If the
# test cases are run from the test subdirectory, then this will include
# all files in the product.

class xhtml(p4dti_unittest.TestCase):
    def write(self, msg):
        self.addFailure(msg)

    def runTest(self):
        "XHTML documents (test_xhtml.xhtml)"
        check_xhtml.checker([], [], self).check(os.pardir)


# 3. RUNNING THE TESTS

def tests():
    suite = unittest.TestSuite()
    for t in [xhtml]:
        suite.addTest(t())
    return suite

if __name__ == "__main__":
    unittest.main(defaultTest="tests")


# A. REFERENCES
#
# [PyUnit] "PyUnit - a unit testing framework for Python"; Steve
# Purcell; <http://pyunit.sourceforge.net/>.
#
# [XHTML 1.0] "XHTML 1.0: The Extensible HyperText Markup Language";
# World Wide Web Consortium; 2000-01-26; <http://www.w3.org/TR/xhtml1/>.
#
#
# B. DOCUMENT HISTORY
#
# 2001-07-25 GDR Created.
#
#
# C. COPYRIGHT AND LICENSE
#
# This file is copyright (c) 2001 Perforce Software, Inc.  All
# rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
#
# 1.  Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#
# 2.  Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in
#     the documentation and/or other materials provided with the
#     distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# HOLDERS AND CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
# BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
# OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
# ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
# TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
# USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
# DAMAGE.
#
#
# $Id: //info.ravenbrook.com/project/p4dti/version/2.1/test/test_xhtml.py#1 $
